/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import net.minecraftforge.client.settings.KeyModifier;

public class KeyBindingMap {
    private static final EnumMap<KeyModifier, oh<Collection<bcc>>> map = new EnumMap(KeyModifier.class);

    public bcc lookupActive(int keyCode) {
        bcc binding;
        KeyModifier activeModifier = KeyModifier.getActiveModifier();
        if (!activeModifier.matches(keyCode) && (binding = this.getBinding(keyCode, activeModifier)) != null) {
            return binding;
        }
        return this.getBinding(keyCode, KeyModifier.NONE);
    }

    private bcc getBinding(int keyCode, KeyModifier keyModifier) {
        Collection bindings = (Collection)map.get((Object)keyModifier).a(keyCode);
        if (bindings != null) {
            for (bcc binding : bindings) {
                if (!binding.isActiveAndMatches(keyCode)) continue;
                return binding;
            }
        }
        return null;
    }

    public List<bcc> lookupAll(int keyCode) {
        ArrayList<bcc> matchingBindings = new ArrayList<bcc>();
        for (oh<Collection<bcc>> bindingsMap : map.values()) {
            Collection bindings = (Collection)bindingsMap.a(keyCode);
            if (bindings == null) continue;
            matchingBindings.addAll(bindings);
        }
        return matchingBindings;
    }

    public void addKey(int keyCode, bcc keyBinding) {
        KeyModifier keyModifier = keyBinding.getKeyModifier();
        oh<Collection<bcc>> bindingsMap = map.get((Object)keyModifier);
        ArrayList<bcc> bindingsForKey = (ArrayList<bcc>)bindingsMap.a(keyCode);
        if (bindingsForKey == null) {
            bindingsForKey = new ArrayList<bcc>();
            bindingsMap.a(keyCode, bindingsForKey);
        }
        bindingsForKey.add(keyBinding);
    }

    public void removeKey(bcc keyBinding) {
        KeyModifier keyModifier = keyBinding.getKeyModifier();
        int keyCode = keyBinding.j();
        oh<Collection<bcc>> bindingsMap = map.get((Object)keyModifier);
        Collection bindingsForKey = (Collection)bindingsMap.a(keyCode);
        if (bindingsForKey != null) {
            bindingsForKey.remove(keyBinding);
            if (bindingsForKey.isEmpty()) {
                bindingsMap.d(keyCode);
            }
        }
    }

    public void clearMap() {
        for (oh<Collection<bcc>> bindings : map.values()) {
            bindings.c();
        }
    }

    static {
        for (KeyModifier modifier : KeyModifier.values()) {
            map.put(modifier, (oh<Collection<bcc>>)new oh());
        }
    }
}

