/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.settings;

public enum KeyModifier {
    CONTROL{

        @Override
        public boolean matches(int keyCode) {
            if (bcf.a) {
                return keyCode == 219 || keyCode == 220;
            }
            return keyCode == 29 || keyCode == 157;
        }

        @Override
        public boolean isActive() {
            return bfb.q();
        }

        @Override
        public String getLocalizedComboName(int keyCode) {
            String keyName = bch.c((int)keyCode);
            String localizationFormatKey = bcf.a ? "forge.controlsgui.control.mac" : "forge.controlsgui.control";
            return bwo.a((String)localizationFormatKey, (Object[])new Object[]{keyName});
        }
    }
    ,
    SHIFT{

        @Override
        public boolean matches(int keyCode) {
            return keyCode == 42 || keyCode == 54;
        }

        @Override
        public boolean isActive() {
            return bfb.r();
        }

        @Override
        public String getLocalizedComboName(int keyCode) {
            String keyName = bch.c((int)keyCode);
            return bwo.a((String)"forge.controlsgui.shift", (Object[])new Object[]{keyName});
        }
    }
    ,
    ALT{

        @Override
        public boolean matches(int keyCode) {
            return keyCode == 56 || keyCode == 184;
        }

        @Override
        public boolean isActive() {
            return bfb.s();
        }

        @Override
        public String getLocalizedComboName(int keyCode) {
            String keyName = bch.c((int)keyCode);
            return bwo.a((String)"forge.controlsgui.alt", (Object[])new Object[]{keyName});
        }
    }
    ,
    NONE{

        @Override
        public boolean matches(int keyCode) {
            return false;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public String getLocalizedComboName(int keyCode) {
            return bch.c((int)keyCode);
        }
    };

    public static final KeyModifier[] MODIFIER_VALUES;

    public static KeyModifier getActiveModifier() {
        for (KeyModifier keyModifier : MODIFIER_VALUES) {
            if (!keyModifier.isActive()) continue;
            return keyModifier;
        }
        return NONE;
    }

    public static boolean isKeyCodeModifier(int keyCode) {
        for (KeyModifier keyModifier : MODIFIER_VALUES) {
            if (!keyModifier.matches(keyCode)) continue;
            return true;
        }
        return false;
    }

    public static KeyModifier valueFromString(String stringValue) {
        try {
            return KeyModifier.valueOf(stringValue);
        }
        catch (NullPointerException ignored) {
            return NONE;
        }
        catch (IllegalArgumentException ignored) {
            return NONE;
        }
    }

    public abstract boolean matches(int var1);

    public abstract boolean isActive();

    public abstract String getLocalizedComboName(int var1);

    static {
        MODIFIER_VALUES = new KeyModifier[]{SHIFT, CONTROL, ALT};
    }
}

