/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeRegistry {
    private static List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public static boolean addRecipe(adq input, adq ingredient, adq output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(adq input, String ingredient, adq output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingOreRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(IBrewingRecipe recipe) {
        return recipes.add(recipe);
    }

    public static adq getOutput(adq input, adq ingredient) {
        if (input == null || input.c() != 1 || input.b != 1) {
            return null;
        }
        if (ingredient == null || ingredient.b <= 0) {
            return null;
        }
        for (IBrewingRecipe recipe : recipes) {
            adq output = recipe.getOutput(input, ingredient);
            if (output == null) continue;
            return output;
        }
        return null;
    }

    public static boolean hasOutput(adq input, adq ingredient) {
        return BrewingRecipeRegistry.getOutput(input, ingredient) != null;
    }

    public static boolean canBrew(adq[] inputs, adq ingredient, int[] inputIndexes) {
        if (ingredient == null || ingredient.b <= 0) {
            return false;
        }
        for (int i2 : inputIndexes) {
            if (!BrewingRecipeRegistry.hasOutput(inputs[i2], ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void brewPotions(adq[] inputs, adq ingredient, int[] inputIndexes) {
        for (int i2 : inputIndexes) {
            adq output = BrewingRecipeRegistry.getOutput(inputs[i2], ingredient);
            if (output == null) continue;
            inputs[i2] = output;
        }
    }

    public static boolean isValidIngredient(adq stack) {
        if (stack == null || stack.b <= 0) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInput(adq stack) {
        if (stack == null || stack.c() != 1 || stack.b != 1) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<IBrewingRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }

    static {
        BrewingRecipeRegistry.addRecipe(new VanillaBrewingRecipe());
    }
}

