/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidBase
extends ajt
implements IFluidBlock {
    protected static final Map<ajt, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<ajt, Boolean> displacements = Maps.newHashMap();
    public static final arq LEVEL;
    public static final PropertyFloat[] LEVEL_CORNERS;
    public static final PropertyFloat FLOW_DIRECTION;
    public static final ImmutableList<IUnlistedProperty<Float>> FLUID_RENDER_PROPS;
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected ahm renderLayer = ahm.d;
    protected int maxScaledLight = 0;
    protected final String fluidName;
    protected final Fluid definedFluid;

    public BlockFluidBase(Fluid fluid, axe material) {
        super(material);
        this.a(true);
        this.q();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.definedFluid = fluid;
        this.displacements.putAll(defaultDisplacements);
        this.w(this.A.b().a((arr)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected ard b() {
        return new ExtendedBlockState(this, new arr[]{LEVEL}, (IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0]));
    }

    public int e(arc state) {
        return (Integer)state.c((arr)LEVEL);
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderLayer(ahm renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(ahx world, cj pos) {
        if (world.d(pos)) {
            return true;
        }
        arc state = world.o(pos);
        if (state.t() == this) {
            return false;
        }
        if (this.displacements.containsKey(state.t())) {
            return this.displacements.get(state.t());
        }
        axe material = state.a();
        if (material.c() || material == axe.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(aht world, cj pos) {
        if (world.d(pos)) {
            return true;
        }
        arc state = world.o(pos);
        ajt block = state.t();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (this.displacements.get(block).booleanValue()) {
                block.b(world, pos, state, 0);
                return true;
            }
            return false;
        }
        axe material = state.a();
        if (material.c() || material == axe.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity((ahx)world, pos);
        if (density == Integer.MAX_VALUE) {
            block.b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    public abstract int getQuantaValue(ahx var1, cj var2);

    public abstract boolean a(arc var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    public void c(aht world, cj pos, arc state) {
        world.a(pos, (ajt)this, this.tickRate);
    }

    public void a(aht world, cj pos, arc state, ajt neighborBlock) {
        world.a(pos, (ajt)this, this.tickRate);
    }

    public boolean s() {
        return false;
    }

    public boolean b(ahx world, cj pos) {
        return true;
    }

    public ado a(arc state, Random rand, int fortune) {
        return null;
    }

    public int a(Random par1Random) {
        return 0;
    }

    public int a(aht world) {
        return this.tickRate;
    }

    public bbj a(aht world, cj pos, rr entity, bbj vec) {
        if (this.densityDir > 0) {
            return vec;
        }
        bbj vec_flow = this.getFlowVector((ahx)world, pos);
        return vec.b(vec_flow.b * (double)(this.quantaPerBlock * 4), vec_flow.c * (double)(this.quantaPerBlock * 4), vec_flow.d * (double)(this.quantaPerBlock * 4));
    }

    public int getLightValue(arc state, ahx world, cj pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(state, world, pos);
        }
        int data = (Integer)state.c((arr)LEVEL);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public boolean b(arc state) {
        return false;
    }

    public boolean c(arc state) {
        return false;
    }

    public int c(arc state, ahx world, cj pos) {
        int lightThis = world.b(pos, 0);
        int lightUp = world.b(pos.a(), 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    public ahm f() {
        return this.renderLayer;
    }

    public boolean a(arc state, ahx world, cj pos, cq side) {
        arc neighbor = world.o(pos.a(side));
        if (neighbor.a() == state.a()) {
            return false;
        }
        if (this.densityDir == -1 && side == cq.b) {
            return true;
        }
        if (this.densityDir == 1 && side == cq.a) {
            return true;
        }
        return super.a(state, world, pos, side);
    }

    public arc getExtendedState(arc oldState, ahx worldIn, cj pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty(FLOW_DIRECTION, Float.valueOf((float)BlockFluidBase.getFlowDirection(worldIn, pos)));
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        height[1][1] = this.getFluidHeightForRender(worldIn, pos);
        if (height[1][1] == 1.0f) {
            for (int i2 = 0; i2 < 2; ++i2) {
                for (int j2 = 0; j2 < 2; ++j2) {
                    corner[i2][j2] = 1.0f;
                }
            }
        } else {
            int j3;
            int i3;
            for (i3 = 0; i3 < 3; ++i3) {
                for (j3 = 0; j3 < 3; ++j3) {
                    if (i3 == 1 && j3 == 1) continue;
                    height[i3][j3] = this.getFluidHeightForRender(worldIn, pos.a(i3 - 1, 0, j3 - 1));
                }
            }
            for (i3 = 0; i3 < 2; ++i3) {
                for (j3 = 0; j3 < 2; ++j3) {
                    corner[i3][j3] = this.getFluidHeightAverage(height[i3][j3], height[i3][j3 + 1], height[i3 + 1][j3], height[i3 + 1][j3 + 1]);
                }
            }
        }
        state = state.withProperty(LEVEL_CORNERS[0], Float.valueOf(corner[0][0]));
        state = state.withProperty(LEVEL_CORNERS[1], Float.valueOf(corner[0][1]));
        state = state.withProperty(LEVEL_CORNERS[2], Float.valueOf(corner[1][1]));
        state = state.withProperty(LEVEL_CORNERS[3], Float.valueOf(corner[1][0]));
        return state;
    }

    public static final int getDensity(ahx world, cj pos) {
        ajt block = world.o(pos).t();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static final int getTemperature(ahx world, cj pos) {
        ajt block = world.o(pos).t();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).temperature;
    }

    public static double getFlowDirection(ahx world, cj pos) {
        arc state = world.o(pos);
        if (!state.a().d()) {
            return -1000.0;
        }
        bbj vec = ((BlockFluidBase)state.t()).getFlowVector(world, pos);
        return vec.b == 0.0 && vec.d == 0.0 ? -1000.0 : Math.atan2(vec.d, vec.b) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(ahx world, cj pos, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(ahx world, cj pos, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(ahx world, cj pos) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        float end = 0.0f;
        for (int i2 = 0; i2 < flow.length; ++i2) {
            if (flow[i2] >= 0.875f && end != 1.0f) {
                end = flow[i2];
            }
            if (!(flow[i2] >= 0.0f)) continue;
            total += flow[i2];
            ++count;
        }
        if (end == 0.0f) {
            end = total / (float)count;
        }
        return end;
    }

    public float getFluidHeightForRender(ahx world, cj pos) {
        arc here = world.o(pos);
        arc up = world.o(pos.c(this.densityDir));
        if (here.t() == this) {
            if (up.a().d() || up.t() instanceof IFluidBlock) {
                return 1.0f;
            }
            if (this.e(here) == this.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        return !here.a().a() && up.t() == this ? 1.0f : this.getQuantaPercentage(world, pos) * 0.875f;
    }

    public bbj getFlowVector(ahx world, cj pos) {
        bbj vec = new bbj(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, pos);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = pos.p();
            int z2 = pos.r();
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            cj pos2 = new cj(x2, pos.q(), z2);
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.o(pos2).a().c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2.b())) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.b((double)((pos2.p() - pos.p()) * power), 0.0, (double)((pos2.r() - pos.r()) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.b((double)((pos2.p() - pos.p()) * power), 0.0, (double)((pos2.r() - pos.r()) * power));
        }
        if (world.o(pos.a()).t() == this) {
            boolean flag;
            boolean bl = flag = this.a(world, pos.a(0, 0, -1), cq.c) || this.a(world, pos.a(0, 0, 1), cq.d) || this.a(world, pos.a(-1, 0, 0), cq.e) || this.a(world, pos.a(1, 0, 0), cq.f) || this.a(world, pos.a(0, 1, -1), cq.c) || this.a(world, pos.a(0, 1, 1), cq.d) || this.a(world, pos.a(-1, 1, 0), cq.e) || this.a(world, pos.a(1, 1, 0), cq.f);
            if (flag) {
                vec = vec.a().b(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(aht world, cj pos) {
        int quantaRemaining = this.getQuantaValue((ahx)world, pos) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    public bbh a(arc blockState, aht worldIn, cj pos) {
        return null;
    }

    static {
        defaultDisplacements.put(aju.ao, false);
        defaultDisplacements.put(aju.ap, false);
        defaultDisplacements.put(aju.aq, false);
        defaultDisplacements.put(aju.ar, false);
        defaultDisplacements.put(aju.as, false);
        defaultDisplacements.put(aju.at, false);
        defaultDisplacements.put(aju.bd, false);
        defaultDisplacements.put(aju.cw, false);
        defaultDisplacements.put(aju.aO, false);
        defaultDisplacements.put(aju.aP, false);
        defaultDisplacements.put(aju.aQ, false);
        defaultDisplacements.put(aju.aR, false);
        defaultDisplacements.put(aju.aS, false);
        defaultDisplacements.put(aju.aT, false);
        defaultDisplacements.put(aju.bz, false);
        defaultDisplacements.put(aju.bo, false);
        defaultDisplacements.put(aju.bp, false);
        defaultDisplacements.put(aju.bq, false);
        defaultDisplacements.put(aju.br, false);
        defaultDisplacements.put(aju.bs, false);
        defaultDisplacements.put(aju.bt, false);
        defaultDisplacements.put(aju.aB, false);
        defaultDisplacements.put(aju.az, false);
        defaultDisplacements.put(aju.ch, false);
        defaultDisplacements.put(aju.ci, false);
        defaultDisplacements.put(aju.au, false);
        defaultDisplacements.put(aju.bi, false);
        defaultDisplacements.put(aju.bj, false);
        defaultDisplacements.put((ajt)aju.cH, false);
        defaultDisplacements.put((ajt)aju.aY, false);
        defaultDisplacements.put(aju.bF, false);
        defaultDisplacements.put(aju.bZ, false);
        defaultDisplacements.put(aju.cv, false);
        defaultDisplacements.put(aju.cK, false);
        defaultDisplacements.put(aju.cL, false);
        defaultDisplacements.put(aju.ba, false);
        defaultDisplacements.put(aju.aA, false);
        defaultDisplacements.put(aju.an, false);
        defaultDisplacements.put(aju.ax, false);
        defaultDisplacements.put((ajt)aju.aM, false);
        LEVEL = arq.a((String)"level", (int)0, (int)15);
        LEVEL_CORNERS = new PropertyFloat[4];
        FLOW_DIRECTION = new PropertyFloat("flow_direction");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)FLOW_DIRECTION);
        for (int i2 = 0; i2 < 4; ++i2) {
            BlockFluidBase.LEVEL_CORNERS[i2] = new PropertyFloat("level_corner_" + i2);
            builder.add((Object)LEVEL_CORNERS[i2]);
        }
        FLUID_RENDER_PROPS = builder.build();
    }
}

