/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Random;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidClassic
extends BlockFluidBase {
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];
    protected FluidStack stack;

    public BlockFluidClassic(Fluid fluid, axe material) {
        super(fluid, material);
        this.stack = new FluidStack(fluid, 1000);
    }

    public BlockFluidClassic setFluidStack(FluidStack stack) {
        this.stack = stack;
        return this;
    }

    public BlockFluidClassic setFluidStackAmount(int amount) {
        this.stack.amount = amount;
        return this;
    }

    @Override
    public int getQuantaValue(ahx world, cj pos) {
        arc state = world.o(pos);
        if (state.t() == aju.a) {
            return 0;
        }
        if (state.t() != this) {
            return -1;
        }
        int quantaRemaining = this.quantaPerBlock - (Integer)state.c((arr)LEVEL);
        return quantaRemaining;
    }

    @Override
    public boolean a(arc state, boolean fullHit) {
        return fullHit && (Integer)state.c((arr)LEVEL) == 0;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return 0;
    }

    @Override
    public int getLightValue(arc state, ahx world, cj pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(state, world, pos);
        }
        int data = this.quantaPerBlock - (Integer)state.c((arr)LEVEL) - 1;
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public void b(aht world, cj pos, arc state, Random rand) {
        int quantaRemaining = this.quantaPerBlock - (Integer)state.c((arr)LEVEL);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            if (world.o(pos.a(0, -this.densityDir, 0)).t() == this || world.o(pos.a(-1, -this.densityDir, 0)).t() == this || world.o(pos.a(1, -this.densityDir, 0)).t() == this || world.o(pos.a(0, -this.densityDir, -1)).t() == this || world.o(pos.a(0, -this.densityDir, 1)).t() == this) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((ahx)world, pos.a(-1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((ahx)world, pos.a(1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((ahx)world, pos.a(0, 0, -1), maxQuanta);
                maxQuanta = this.getLargerQuanta((ahx)world, pos.a(0, 0, 1), maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.g(pos);
                } else {
                    world.a(pos, state.a((arr)LEVEL, (Comparable)Integer.valueOf(this.quantaPerBlock - expQuanta)), 2);
                    world.a(pos, (ajt)this, this.tickRate);
                    world.d(pos, (ajt)this);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.a(pos, this.u(), 2);
        }
        if (this.canDisplace((ahx)world, pos.b(this.densityDir))) {
            this.flowIntoBlock(world, pos.b(this.densityDir), 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((ahx)world, pos) || !this.isFlowingVertically((ahx)world, pos)) {
            boolean[] flowTo;
            if (world.o(pos.c(this.densityDir)).t() == this) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, pos))[0]) {
                this.flowIntoBlock(world, pos.a(-1, 0, 0), flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, pos.a(1, 0, 0), flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, pos.a(0, 0, -1), flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, pos.a(0, 0, 1), flowMeta);
            }
        }
    }

    public boolean isFlowingVertically(ahx world, cj pos) {
        return world.o(pos.b(this.densityDir)).t() == this || world.o(pos).t() == this && this.canFlowInto(world, pos.b(this.densityDir));
    }

    public boolean isSourceBlock(ahx world, cj pos) {
        arc state = world.o(pos);
        return state.t() == this && (Integer)state.c((arr)LEVEL) == 0;
    }

    protected boolean[] getOptimalFlowDirections(aht world, cj pos) {
        int side;
        for (int side2 = 0; side2 < 4; ++side2) {
            this.flowCost[side2] = 1000;
            cj pos2 = pos;
            switch (side2) {
                case 0: {
                    pos2 = pos2.a(-1, 0, 0);
                    break;
                }
                case 1: {
                    pos2 = pos2.a(1, 0, 0);
                    break;
                }
                case 2: {
                    pos2 = pos2.a(0, 0, -1);
                    break;
                }
                case 3: {
                    pos2 = pos2.a(0, 0, 1);
                }
            }
            if (!this.canFlowInto((ahx)world, pos2) || this.isSourceBlock((ahx)world, pos2)) continue;
            this.flowCost[side2] = this.canFlowInto((ahx)world, pos2.a(0, this.densityDir, 0)) ? 0 : this.calculateFlowCost(world, pos2, 1, side2);
        }
        int min = this.flowCost[0];
        for (side = 1; side < 4; ++side) {
            if (this.flowCost[side] >= min) continue;
            min = this.flowCost[side];
        }
        for (side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(aht world, cj pos, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            int min;
            if (adjSide == 0 && side == 1 || adjSide == 1 && side == 0 || adjSide == 2 && side == 3 || adjSide == 3 && side == 2) continue;
            cj pos2 = pos;
            switch (adjSide) {
                case 0: {
                    pos2 = pos2.a(-1, 0, 0);
                    break;
                }
                case 1: {
                    pos2 = pos2.a(1, 0, 0);
                    break;
                }
                case 2: {
                    pos2 = pos2.a(0, 0, -1);
                    break;
                }
                case 3: {
                    pos2 = pos2.a(0, 0, 1);
                }
            }
            if (!this.canFlowInto((ahx)world, pos2) || this.isSourceBlock((ahx)world, pos2)) continue;
            if (this.canFlowInto((ahx)world, pos2.a(0, this.densityDir, 0))) {
                return recurseDepth;
            }
            if (recurseDepth >= 4 || (min = this.calculateFlowCost(world, pos2, recurseDepth + 1, adjSide)) >= cost) continue;
            cost = min;
        }
        return cost;
    }

    protected void flowIntoBlock(aht world, cj pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.a(pos, this.t().b().a((arr)LEVEL, (Comparable)Integer.valueOf(meta)), 3);
        }
    }

    protected boolean canFlowInto(ahx world, cj pos) {
        if (world.d(pos)) {
            return true;
        }
        arc state = world.o(pos);
        if (state.t() == this) {
            return true;
        }
        if (this.displacements.containsKey(state.t())) {
            return (Boolean)this.displacements.get(state.t());
        }
        axe material = state.a();
        if (material.c() || material == axe.h || material == axe.i || material == axe.E) {
            return false;
        }
        int density = BlockFluidClassic.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    protected int getLargerQuanta(ahx world, cj pos, int compare) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }

    @Override
    public FluidStack drain(aht world, cj pos, boolean doDrain) {
        if (!this.isSourceBlock((ahx)world, pos)) {
            return null;
        }
        if (doDrain) {
            world.g(pos);
        }
        return this.stack.copy();
    }

    @Override
    public boolean canDrain(aht world, cj pos) {
        return this.isSourceBlock((ahx)world, pos);
    }
}

