/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Locale;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;

public class Fluid {
    protected final String fluidName;
    protected String unlocalizedName;
    protected final kk still;
    protected final kk flowing;
    private nf fillSound;
    private nf emptySound;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int temperature = 300;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected aee rarity = aee.a;
    protected ajt block = null;

    public Fluid(String fluidName, kk still, kk flowing) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
        this.still = still;
        this.flowing = flowing;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlock(ajt block) {
        if (this.block == null || this.block == block) {
            this.block = block;
        } else {
            FMLLog.warning("A mod has attempted to assign Block " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to the Block " + this.block + ". You may have duplicate Fluid Blocks as a result. It *may* be possible to configure your mods to avoid this.", new Object[0]);
        }
        return this;
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public Fluid setRarity(aee rarity) {
        this.rarity = rarity;
        return this;
    }

    public Fluid setFillSound(nf fillSound) {
        this.fillSound = fillSound;
        return this;
    }

    public Fluid setEmptySound(nf emptySound) {
        this.emptySound = emptySound;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final ajt getBlock() {
        return this.block;
    }

    public final boolean canBePlacedInWorld() {
        return this.block != null;
    }

    public String getLocalizedName(FluidStack stack) {
        String s = this.getUnlocalizedName();
        return s == null ? "" : di.a((String)s);
    }

    public String getUnlocalizedName(FluidStack stack) {
        return this.getUnlocalizedName();
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public aee getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return -1;
    }

    public kk getStill() {
        return this.still;
    }

    public kk getFlowing() {
        return this.flowing;
    }

    public nf getFillSound() {
        if (this.fillSound == null) {
            this.fillSound = this.getBlock() != null && this.getBlock().u().a() == axe.i ? ng.O : ng.N;
        }
        return this.fillSound;
    }

    public nf getEmptySound() {
        if (this.emptySound == null) {
            this.emptySound = this.getBlock() != null && this.getBlock().u().a() == axe.i ? ng.M : ng.L;
        }
        return this.emptySound;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public aee getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public kk getStill(FluidStack stack) {
        return this.getStill();
    }

    public kk getFlowing(FluidStack stack) {
        return this.getFlowing();
    }

    public nf getFillSound(FluidStack stack) {
        return this.getFillSound();
    }

    public nf getEmptySound(FluidStack stack) {
        return this.getEmptySound();
    }

    public int getLuminosity(aht world, cj pos) {
        return this.getLuminosity();
    }

    public int getDensity(aht world, cj pos) {
        return this.getDensity();
    }

    public int getTemperature(aht world, cj pos) {
        return this.getTemperature();
    }

    public int getViscosity(aht world, cj pos) {
        return this.getViscosity();
    }

    public boolean isGaseous(aht world, cj pos) {
        return this.isGaseous();
    }

    public aee getRarity(aht world, cj pos) {
        return this.getRarity();
    }

    public int getColor(aht world, cj pos) {
        return this.getColor();
    }

    public kk getStill(aht world, cj pos) {
        return this.getStill();
    }

    public kk getFlowing(aht world, cj pos) {
        return this.getFlowing();
    }

    public nf getFillSound(aht world, cj pos) {
        return this.getFillSound();
    }

    public nf getEmptySound(aht world, cj pos) {
        return this.getEmptySound();
    }
}

