/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.eventhandler.Event;

public class FluidEvent
extends Event {
    private final FluidStack fluid;
    private final aht world;
    private final cj pos;

    public FluidEvent(FluidStack fluid, aht world, cj pos) {
        this.fluid = fluid;
        this.world = world;
        this.pos = pos;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public aht getWorld() {
        return this.world;
    }

    public cj getPos() {
        return this.pos;
    }

    public static final void fireEvent(FluidEvent event) {
        MinecraftForge.EVENT_BUS.post(event);
    }

    public static class FluidSpilledEvent
    extends FluidEvent {
        public FluidSpilledEvent(FluidStack fluid, aht world, cj pos) {
            super(fluid, world, pos);
        }
    }

    public static class FluidDrainingEvent
    extends FluidEvent {
        private final IFluidTank tank;
        private final int amount;

        public FluidDrainingEvent(FluidStack fluid, aht world, cj pos, IFluidTank tank, int amount) {
            super(fluid, world, pos);
            this.amount = amount;
            this.tank = tank;
        }

        public IFluidTank getTank() {
            return this.tank;
        }

        public int getAmount() {
            return this.amount;
        }
    }

    public static class FluidFillingEvent
    extends FluidEvent {
        private final IFluidTank tank;
        private final int amount;

        public FluidFillingEvent(FluidStack fluid, aht world, cj pos, IFluidTank tank, int amount) {
            super(fluid, world, pos);
            this.tank = tank;
            this.amount = amount;
        }

        public IFluidTank getTank() {
            return this.tank;
        }

        public int getAmount() {
            return this.amount;
        }
    }

    public static class FluidMotionEvent
    extends FluidEvent {
        public FluidMotionEvent(FluidStack fluid, aht world, cj pos) {
            super(fluid, world, pos);
        }
    }
}

