/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class FluidUtil {
    private FluidUtil() {
    }

    public static boolean interactWithTank(adq stack, zj player, IFluidHandler tank, cq side) {
        if (stack == null) {
            return true;
        }
        int slot = player.br.d;
        adq result = FluidUtil.tryFillBucket(stack, tank, side, player);
        if (result != null || (result = FluidUtil.tryEmptyBucket(stack, tank, side, player)) != null) {
            if (!player.bJ.d) {
                player.br.a(slot, 1);
                ItemHandlerHelper.giveItemToPlayer(player, result, slot);
            }
            if (player.bs != null) {
                player.bs.b();
            }
            return true;
        }
        adq original = stack;
        adq copy = stack.k();
        stack = stack.k();
        boolean changedBucket = false;
        if (adq.c((adq)stack, (adq)FluidContainerRegistry.EMPTY_BUCKET) && FluidRegistry.isUniversalBucketEnabled()) {
            stack = new adq((ado)ForgeModContainer.getInstance().universalBucket, copy.b);
            changedBucket = true;
        }
        if (FluidUtil.tryFillFluidContainerItem(stack, tank, side, player) || FluidUtil.tryEmptyFluidContainerItem(stack, tank, side, player)) {
            --original.b;
            if (player.bJ.d) {
                player.br.a(slot, copy);
            } else if (changedBucket && stack.b != copy.b) {
                copy.b = stack.b;
                player.br.a(slot, copy);
            } else if (copy.b > 1) {
                player.br.a(slot, stack);
            } else {
                player.br.a(slot, null);
                ItemHandlerHelper.giveItemToPlayer(player, stack, slot);
            }
            if (player.bs != null) {
                player.bs.b();
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static adq tryFillBucket(adq bucket, IFluidHandler tank, cq side) {
        return FluidUtil.tryFillBucket(bucket, tank, side, null);
    }

    public static adq tryFillBucket(adq bucket, IFluidHandler tank, cq side, zj player) {
        FluidTankInfo[] info = tank.getTankInfo(side);
        if (info == null || info.length == 0) {
            return null;
        }
        if (!FluidContainerRegistry.isEmptyContainer(bucket)) {
            return null;
        }
        FluidStack inTank = info[0].fluid;
        FluidStack liquid = tank.drain(side, FluidContainerRegistry.getContainerCapacity(inTank, bucket), false);
        if (liquid != null && liquid.amount > 0) {
            if (player != null) {
                nf soundevent = liquid.getFluid().getFillSound(liquid);
                player.a(soundevent, 1.0f, 1.0f);
            }
            tank.drain(side, FluidContainerRegistry.getContainerCapacity(liquid, bucket), true);
            return FluidContainerRegistry.fillFluidContainer(liquid, bucket);
        }
        return null;
    }

    @Deprecated
    public static adq tryEmptyBucket(adq bucket, IFluidHandler tank, cq side) {
        return FluidUtil.tryEmptyBucket(bucket, tank, side, null);
    }

    public static adq tryEmptyBucket(adq bucket, IFluidHandler tank, cq side, zj player) {
        int amount;
        if (!FluidContainerRegistry.isFilledContainer(bucket)) {
            return null;
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem(bucket);
        if (tank.canFill(side, liquid.getFluid()) && (amount = tank.fill(side, liquid, false)) == liquid.amount) {
            if (player != null) {
                nf soundevent = liquid.getFluid().getEmptySound(liquid);
                player.a(soundevent, 1.0f, 1.0f);
            }
            tank.fill(side, liquid, true);
            return FluidContainerRegistry.drainFluidContainer(bucket);
        }
        return null;
    }

    public static boolean tryFillFluidContainerItem(adq container, IFluidHandler tank, cq side, zj player) {
        return FluidUtil.tryFillFluidContainerItem(container, tank, side, new PlayerMainInvWrapper(player.br), -1, player);
    }

    public static boolean tryEmptyFluidContainerItem(adq container, IFluidHandler tank, cq side, zj player) {
        return FluidUtil.tryEmptyFluidContainerItem(container, tank, side, new PlayerMainInvWrapper(player.br), -1, player);
    }

    public static boolean tryFillFluidContainerItem(adq container, IFluidHandler tank, cq side, IItemHandler inventory, int max, zj player) {
        FluidStack liquid;
        if (!(container.b() instanceof IFluidContainerItem)) {
            return false;
        }
        IFluidContainerItem fluidContainer = (IFluidContainerItem)container.b();
        if (fluidContainer.getFluid(container) != null) {
            return false;
        }
        if (max <= 0) {
            max = fluidContainer.getCapacity(container);
        }
        if ((liquid = tank.drain(side, max, false)) != null && liquid.amount > 0) {
            if (container.b > 1) {
                adq toFill = container.k();
                toFill.b = 1;
                int filled = fluidContainer.fill(toFill, liquid, false);
                if (filled <= 0) {
                    return false;
                }
                filled = fluidContainer.fill(toFill, liquid, true);
                if (player == null || !player.l.E) {
                    adq remainder = ItemHandlerHelper.insertItemStacked(inventory, toFill, true);
                    if (remainder != null && player == null) {
                        return false;
                    }
                    remainder = ItemHandlerHelper.insertItemStacked(inventory, toFill, false);
                    if (remainder != null && player != null) {
                        ItemHandlerHelper.giveItemToPlayer(player, remainder);
                    }
                }
                tank.drain(side, filled, true);
                --container.b;
            } else {
                int filled = fluidContainer.fill(container, liquid, false);
                if (filled <= 0) {
                    return false;
                }
                filled = fluidContainer.fill(container, liquid, true);
                tank.drain(side, filled, true);
            }
            if (player != null) {
                nf soundevent = liquid.getFluid().getFillSound(liquid);
                player.a(soundevent, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public static boolean tryEmptyFluidContainerItem(adq container, IFluidHandler tank, cq side, IItemHandler inventory, int max, zj player) {
        if (!(container.b() instanceof IFluidContainerItem)) {
            return false;
        }
        IFluidContainerItem fluidContainer = (IFluidContainerItem)container.b();
        if (fluidContainer.getFluid(container) != null) {
            int filled;
            FluidStack drained;
            if (max <= 0) {
                max = fluidContainer.getCapacity(container);
            }
            if ((drained = fluidContainer.drain(container, max, false)) != null && (filled = tank.fill(side, drained, false)) > 0 && (drained = fluidContainer.drain(container, filled, false)) != null && drained.amount == filled) {
                if (container.b > 1) {
                    adq toEmpty = container.k();
                    toEmpty.b = 1;
                    drained = fluidContainer.drain(toEmpty, filled, true);
                    if (player == null || !player.l.E) {
                        adq remainder = ItemHandlerHelper.insertItemStacked(inventory, toEmpty, true);
                        if (remainder != null && player == null) {
                            return false;
                        }
                        remainder = ItemHandlerHelper.insertItemStacked(inventory, toEmpty, false);
                        if (remainder != null && player != null) {
                            ItemHandlerHelper.giveItemToPlayer(player, remainder);
                        }
                    }
                    tank.fill(side, drained, true);
                    --container.b;
                } else {
                    drained = fluidContainer.drain(container, filled, true);
                    tank.fill(side, drained, true);
                }
                if (player != null) {
                    nf soundevent = drained.getFluid().getEmptySound(drained);
                    player.a(soundevent, 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }
}

