/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Iterator;
import java.util.List;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class UniversalBucket
extends ado
implements IFluidContainerItem {
    private final int capacity;
    private final adq empty;
    private final boolean nbtSensitive;

    public UniversalBucket() {
        this(1000, FluidContainerRegistry.EMPTY_BUCKET, false);
    }

    public UniversalBucket(int capacity, adq empty, boolean nbtSensitive) {
        this.capacity = capacity;
        this.empty = empty;
        this.nbtSensitive = nbtSensitive;
        this.d(1);
        this.a(acq.f);
    }

    @SideOnly(value=Side.CLIENT)
    public void a(ado itemIn, acq tab, List<adq> subItems) {
        Iterator<Fluid> iterator = FluidRegistry.getRegisteredFluids().values().iterator();
        while (iterator.hasNext()) {
            adq stack = new adq((ado)this);
            Fluid fluid = iterator.next();
            FluidStack fs = new FluidStack(fluid, this.getCapacity());
            if (this.fill(stack, fs, true) != fs.amount) continue;
            subItems.add(stack);
        }
    }

    public String a(adq stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            if (this.getEmpty() != null) {
                return this.getEmpty().q();
            }
            return super.a(stack);
        }
        String unloc = this.j(stack);
        if (di.c((String)(unloc + "." + fluidStack.getFluid().getName()))) {
            return di.a((String)(unloc + "." + fluidStack.getFluid().getName()));
        }
        return di.a((String)(unloc + ".name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    public qp<adq> a(adq itemstack, aht world, zj player, qm hand) {
        cj targetPos;
        FluidStack fluidStack = this.getFluid(itemstack);
        if (fluidStack == null) {
            return qp.newResult((qo)qo.b, (Object)itemstack);
        }
        bbi mop = this.a(world, player, false);
        if (mop == null || mop.a != bbi.a.b) {
            return qp.newResult((qo)qo.b, (Object)itemstack);
        }
        cj clickPos = mop.a();
        if (world.a(player, clickPos) && player.a(targetPos = clickPos.a(mop.b), mop.b, itemstack) && this.tryPlaceFluid(player, player.e(), fluidStack.getFluid().getBlock(), targetPos) && !player.bJ.d) {
            adq emptyStack;
            player.b(nt.b((ado)this));
            --itemstack.b;
            adq adq2 = emptyStack = this.getEmpty() != null ? this.getEmpty().k() : new adq((ado)this);
            if (itemstack.b <= 0) {
                return qp.newResult((qo)qo.a, (Object)emptyStack);
            }
            ItemHandlerHelper.giveItemToPlayer(player, emptyStack);
            return qp.newResult((qo)qo.a, (Object)itemstack);
        }
        return qp.newResult((qo)qo.c, (Object)itemstack);
    }

    @Deprecated
    public boolean tryPlaceFluid(ajt block, aht worldIn, cj pos) {
        return this.tryPlaceFluid(null, worldIn, block, pos);
    }

    private boolean tryPlaceFluid(zj player, aht worldIn, ajt block, cj pos) {
        if (block == null) {
            return false;
        }
        if (worldIn == null && player != null) {
            worldIn = player.e();
        }
        axe material = worldIn.o(pos).a();
        boolean isSolid = material.a();
        if (!worldIn.d(pos) && isSolid) {
            return false;
        }
        if (worldIn.s.l() && (block == aju.i || block == aju.j)) {
            int i2 = pos.p();
            int j2 = pos.q();
            int k2 = pos.r();
            worldIn.a(null, pos, ng.bv, nh.e, 0.5f, 2.6f + (worldIn.r.nextFloat() - worldIn.r.nextFloat()) * 0.8f);
            for (int l2 = 0; l2 < 8; ++l2) {
                worldIn.a(cy.m, (double)i2 + Math.random(), (double)j2 + Math.random(), (double)k2 + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            Fluid fluid;
            if (!(worldIn.E || isSolid || material.d())) {
                worldIn.b(pos, true);
            }
            if (player != null && block instanceof IFluidBlock && (fluid = ((IFluidBlock)block).getFluid()) != null) {
                worldIn.a(pos, block.u(), 3);
                nf soundevent = fluid.getEmptySound(worldIn, pos);
                worldIn.a(player, pos, soundevent, nh.e, 1.0f, 1.0f);
            }
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFillBucket(FillBucketEvent event) {
        FluidStack drained;
        IFluidBlock fluidBlock;
        cj pos;
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        if (event.getEmptyBucket() == null || !event.getEmptyBucket().a(this.getEmpty()) || this.isNbtSensitive() && adq.a((adq)event.getEmptyBucket(), (adq)this.getEmpty())) {
            return;
        }
        if (event.getTarget() == null || event.getTarget().a != bbi.a.b) {
            return;
        }
        aht world = event.getWorld();
        arc state = world.o(pos = event.getTarget().a());
        if (state.t() instanceof IFluidBlock && (fluidBlock = (IFluidBlock)state.t()).canDrain(world, pos) && (drained = fluidBlock.drain(world, pos, false)) != null && drained.amount == this.getCapacity()) {
            adq filledBucket = new adq((ado)this);
            int filled = this.fill(filledBucket, drained, false);
            if (filled == drained.amount) {
                drained = fluidBlock.drain(world, pos, true);
                this.fill(filledBucket, drained, true);
                event.setResult(Event.Result.ALLOW);
                event.setFilledBucket(filledBucket);
                nf soundevent = drained.getFluid().getFillSound(drained);
                event.getEntityPlayer().a(soundevent, 1.0f, 1.0f);
            } else {
                event.setCanceled(true);
            }
        }
    }

    public static adq getFilledBucket(UniversalBucket item, Fluid fluid) {
        adq stack = new adq((ado)item);
        item.fill(stack, new FluidStack(fluid, item.getCapacity()), true);
        return stack;
    }

    @Override
    public FluidStack getFluid(adq container) {
        return FluidStack.loadFluidStackFromNBT(container.o());
    }

    @Override
    public int getCapacity(adq container) {
        return this.getCapacity();
    }

    @Override
    public int fill(adq container, FluidStack resource, boolean doFill) {
        if (container.b != 1) {
            return 0;
        }
        if (resource == null || resource.amount != this.getCapacity()) {
            return 0;
        }
        if (!FluidRegistry.getBucketFluids().contains(resource.getFluid())) {
            return 0;
        }
        if (doFill) {
            dn tag = container.o();
            if (tag == null) {
                tag = new dn();
            }
            resource.writeToNBT(tag);
            container.d(tag);
        }
        return this.getCapacity();
    }

    @Override
    public FluidStack drain(adq container, int maxDrain, boolean doDrain) {
        if (maxDrain < this.getCapacity()) {
            return null;
        }
        FluidStack fluidStack = this.getFluid(container);
        if (doDrain && fluidStack != null) {
            if (this.getEmpty() != null) {
                container.a(this.getEmpty().b());
                container.d(this.getEmpty().o());
                container.b(this.getEmpty().h());
            } else {
                container.b = 0;
            }
        }
        return fluidStack;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public adq getEmpty() {
        return this.empty;
    }

    public boolean isNbtSensitive() {
        return this.nbtSensitive;
    }
}

