/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import java.util.Arrays;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Level;

public class ObfuscationReflectionHelper {
    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, int fieldIndex) {
        try {
            return ReflectionHelper.getPrivateValue(classToAccess, instance, fieldIndex);
        }
        catch (ReflectionHelper.UnableToAccessFieldException e2) {
            FMLLog.log(Level.ERROR, e2, "There was a problem getting field index %d from %s", fieldIndex, classToAccess.getName());
            throw e2;
        }
    }

    public static String[] remapFieldNames(String className, String ... fieldNames) {
        String internalClassName = FMLDeobfuscatingRemapper.INSTANCE.unmap(className.replace('.', '/'));
        String[] mappedNames = new String[fieldNames.length];
        int i2 = 0;
        for (String fName : fieldNames) {
            mappedNames[i2++] = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(internalClassName, fName, null);
        }
        return mappedNames;
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        try {
            return ReflectionHelper.getPrivateValue(classToAccess, instance, ObfuscationReflectionHelper.remapFieldNames(classToAccess.getName(), fieldNames));
        }
        catch (ReflectionHelper.UnableToFindFieldException e2) {
            FMLLog.log(Level.ERROR, e2, "Unable to locate any field %s on type %s", Arrays.toString(fieldNames), classToAccess.getName());
            throw e2;
        }
        catch (ReflectionHelper.UnableToAccessFieldException e3) {
            FMLLog.log(Level.ERROR, e3, "Unable to access any field %s on type %s", Arrays.toString(fieldNames), classToAccess.getName());
            throw e3;
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, int fieldIndex) {
        try {
            ReflectionHelper.setPrivateValue(classToAccess, instance, value, fieldIndex);
        }
        catch (ReflectionHelper.UnableToAccessFieldException e2) {
            FMLLog.log(Level.ERROR, e2, "There was a problem setting field index %d on type %s", fieldIndex, classToAccess.getName());
            throw e2;
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, String ... fieldNames) {
        try {
            ReflectionHelper.setPrivateValue(classToAccess, instance, value, ObfuscationReflectionHelper.remapFieldNames(classToAccess.getName(), fieldNames));
        }
        catch (ReflectionHelper.UnableToFindFieldException e2) {
            FMLLog.log(Level.ERROR, e2, "Unable to locate any field %s on type %s", Arrays.toString(fieldNames), classToAccess.getName());
            throw e2;
        }
        catch (ReflectionHelper.UnableToAccessFieldException e3) {
            FMLLog.log(Level.ERROR, e3, "Unable to set any field %s on type %s", Arrays.toString(fieldNames), classToAccess.getName());
            throw e3;
        }
    }
}

