/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public class FMLNetworkEvent<T extends ep>
extends Event {
    private final T handler;
    private final ek manager;
    private final Class<T> type;

    FMLNetworkEvent(T thing, Class<T> type, ek manager) {
        this.handler = thing;
        this.type = type;
        this.manager = manager;
    }

    public Class<T> getHandlerType() {
        return this.getType();
    }

    public T getHandler() {
        return this.handler;
    }

    public ek getManager() {
        return this.manager;
    }

    public Class<T> getType() {
        return this.type;
    }

    public static class CustomNetworkEvent
    extends Event {
        private final Object wrappedEvent;

        public CustomNetworkEvent(Object wrappedEvent) {
            this.wrappedEvent = wrappedEvent;
        }

        public Object getWrappedEvent() {
            return this.wrappedEvent;
        }
    }

    public static class ServerCustomPacketEvent
    extends CustomPacketEvent<ig> {
        public ServerCustomPacketEvent(ek manager, FMLProxyPacket packet) {
            super((ig)manager.i(), ig.class, manager, packet);
        }

        @Override
        public Side side() {
            return Side.SERVER;
        }
    }

    public static class ClientCustomPacketEvent
    extends CustomPacketEvent<fi> {
        public ClientCustomPacketEvent(ek manager, FMLProxyPacket packet) {
            super((fi)manager.i(), fi.class, manager, packet);
        }

        @Override
        public Side side() {
            return Side.CLIENT;
        }
    }

    public static abstract class CustomPacketEvent<S extends ep>
    extends FMLNetworkEvent<S> {
        private final FMLProxyPacket packet;
        private FMLProxyPacket reply;

        CustomPacketEvent(S thing, Class<S> type, ek manager, FMLProxyPacket packet) {
            super(thing, type, manager);
            this.packet = packet;
        }

        public abstract Side side();

        public FMLProxyPacket getPacket() {
            return this.packet;
        }

        public FMLProxyPacket getReply() {
            return this.reply;
        }

        public void setReply(FMLProxyPacket reply) {
            this.reply = reply;
        }
    }

    public static class CustomPacketRegistrationEvent<S extends ep>
    extends FMLNetworkEvent<S> {
        private final ImmutableSet<String> registrations;
        private final String operation;
        private final Side side;

        public CustomPacketRegistrationEvent(ek manager, Set<String> registrations, String operation, Side side, Class<S> type) {
            super((ep)type.cast(manager.i()), type, manager);
            this.registrations = ImmutableSet.copyOf(registrations);
            this.side = side;
            this.operation = operation;
        }

        public ImmutableSet<String> getRegistrations() {
            return this.registrations;
        }

        public String getOperation() {
            return this.operation;
        }

        public Side getSide() {
            return this.side;
        }
    }

    public static class ClientDisconnectionFromServerEvent
    extends FMLNetworkEvent<fi> {
        public ClientDisconnectionFromServerEvent(ek manager) {
            super((fi)manager.i(), fi.class, manager);
        }
    }

    public static class ServerDisconnectionFromClientEvent
    extends FMLNetworkEvent<ig> {
        public ServerDisconnectionFromClientEvent(ek manager) {
            super((ig)manager.i(), ig.class, manager);
        }
    }

    public static class ServerConnectionFromClientEvent
    extends FMLNetworkEvent<ig> {
        private final boolean isLocal;

        public ServerConnectionFromClientEvent(ek manager) {
            super((ig)manager.i(), ig.class, manager);
            this.isLocal = manager.c();
        }

        public boolean isLocal() {
            return this.isLocal;
        }
    }

    public static class ClientConnectedToServerEvent
    extends FMLNetworkEvent<fi> {
        private final boolean isLocal;
        private final String connectionType;

        public ClientConnectedToServerEvent(ek manager, String connectionType) {
            super((fi)manager.i(), fi.class, manager);
            this.isLocal = manager.c();
            this.connectionType = connectionType;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public String getConnectionType() {
            return this.connectionType;
        }
    }
}

