/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<dn> {
    protected adq[] stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        this.stacks = new adq[size];
    }

    public ItemStackHandler(adq[] stacks) {
        this.stacks = stacks;
    }

    public void setSize(int size) {
        this.stacks = new adq[size];
    }

    @Override
    public void setStackInSlot(int slot, adq stack) {
        this.validateSlotIndex(slot);
        if (adq.b((adq)this.stacks[slot], (adq)stack)) {
            return;
        }
        this.stacks[slot] = stack;
        this.onContentsChanged(slot);
    }

    @Override
    public int getSlots() {
        return this.stacks.length;
    }

    @Override
    public adq getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.stacks[slot];
    }

    @Override
    public adq insertItem(int slot, adq stack, boolean simulate) {
        boolean reachedLimit;
        if (stack == null || stack.b == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        adq existing = this.stacks[slot];
        int limit = this.getStackLimit(slot, stack);
        if (existing != null) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.b;
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.b > limit;
        if (!simulate) {
            if (existing == null) {
                this.stacks[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack;
            } else {
                existing.b = existing.b + (reachedLimit ? limit : stack.b);
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.b - limit) : null;
    }

    @Override
    public adq extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        adq existing = this.stacks[slot];
        if (existing == null) {
            return null;
        }
        int toExtract = Math.min(amount, existing.c());
        if (existing.b <= toExtract) {
            if (!simulate) {
                this.stacks[slot] = null;
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks[slot] = ItemHandlerHelper.copyStackWithSize(existing, existing.b - toExtract);
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    protected int getStackLimit(int slot, adq stack) {
        return stack.c();
    }

    @Override
    public dn serializeNBT() {
        du nbtTagList = new du();
        for (int i2 = 0; i2 < this.stacks.length; ++i2) {
            if (this.stacks[i2] == null) continue;
            dn itemTag = new dn();
            itemTag.a("Slot", i2);
            this.stacks[i2].b(itemTag);
            nbtTagList.a((eb)itemTag);
        }
        dn nbt = new dn();
        nbt.a("Items", (eb)nbtTagList);
        nbt.a("Size", this.stacks.length);
        return nbt;
    }

    @Override
    public void deserializeNBT(dn nbt) {
        this.setSize(nbt.b("Size", 3) ? nbt.h("Size") : this.stacks.length);
        du tagList = nbt.c("Items", 10);
        for (int i2 = 0; i2 < tagList.c(); ++i2) {
            dn itemTags = tagList.b(i2);
            int slot = itemTags.h("Slot");
            if (slot < 0 || slot >= this.stacks.length) continue;
            this.stacks[slot] = adq.a((dn)itemTags);
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.length) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.length + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }
}

