/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperclip;

import io.papermc.paperclip.Util;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

record DownloadContext(byte[] hash, URL url, String fileName) {
    public Path getOutputFile(Path outputDir) {
        Path cacheDir = outputDir.resolve("cache");
        return cacheDir.resolve(this.fileName);
    }

    public static DownloadContext parseLine(String line) {
        if (line == null || line.isBlank()) {
            return null;
        }
        String[] parts = line.split("\t");
        if (parts.length != 3) {
            throw new IllegalStateException("Invalid download-context line: " + line);
        }
        try {
            return new DownloadContext(Util.fromHex(parts[0]), URI.create(parts[1]).toURL(), parts[2]);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Unable to parse URL in download-context", e);
        }
    }

    public void download(Path outputDir) throws IOException {
        Path outputFile = this.getOutputFile(outputDir);
        if (Files.exists(outputFile, new LinkOption[0]) && Util.isFileValid(outputFile, this.hash)) {
            return;
        }
        Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(outputFile);
        System.out.println("Downloading " + this.fileName);
        try (ReadableByteChannel source = Channels.newChannel(this.url.openStream());
             FileChannel fileChannel = FileChannel.open(outputFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            fileChannel.transferFrom(source, 0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            System.err.println("Failed to download " + this.fileName);
            e.printStackTrace();
            System.exit(1);
        }
        if (!Util.isFileValid(outputFile, this.hash)) {
            throw new IllegalStateException("Hash check failed for downloaded file " + this.fileName);
        }
    }
}

