/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.parameter;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.managed.ValueCompleter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.ValueParameterModifier;
import org.spongepowered.api.command.parameter.managed.ValueParser;
import org.spongepowered.api.command.parameter.managed.ValueUsage;
import org.spongepowered.api.command.parameter.managed.operator.Operator;
import org.spongepowered.api.command.parameter.managed.standard.ResourceKeyedValueParameters;
import org.spongepowered.api.command.parameter.managed.standard.VariableValueParameters;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.registry.DefaultedRegistryType;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.util.Builder;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.configurate.util.Types;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.plugin.PluginContainer;

public interface Parameter {
    public static <T> Key<T> key(@NonNull String key, @NonNull TypeToken<T> typeToken) {
        return Sponge.game().builderProvider().provide(Key.Builder.class).build(key, typeToken);
    }

    public static <T> Key<T> key(@NonNull String key, @NonNull Class<T> type) {
        Types.requireCompleteParameters(type);
        return Sponge.game().builderProvider().provide(Key.Builder.class).build(key, type);
    }

    public static <T> Value.Builder<T> builder(@NonNull Class<T> valueClass) {
        return Sponge.game().factoryProvider().provide(Factory.class).createParameterBuilder(valueClass);
    }

    public static <T> Value.Builder<T> builder(@NonNull TypeToken<T> typeToken) {
        return Sponge.game().factoryProvider().provide(Factory.class).createParameterBuilder(typeToken);
    }

    public static <T> Value.Builder<T> builder(@NonNull Key<T> key) {
        return Sponge.game().factoryProvider().provide(Factory.class).createParameterBuilder(key);
    }

    public static <T> Value.Builder<T> builder(@NonNull Class<T> valueClass, @NonNull ValueParameter<? extends T> parameter) {
        return Parameter.builder(valueClass).addParser(parameter);
    }

    public static <T> Value.Builder<T> builder(@NonNull TypeToken<T> typeToken, @NonNull ValueParameter<? extends T> parameter) {
        return Parameter.builder(typeToken).addParser(parameter);
    }

    public static <T, V extends ValueParameter<T>> Value.Builder<T> builder(@NonNull Class<T> valueClass, @NonNull DefaultedRegistryReference<V> parameter) {
        return Parameter.builder(valueClass, (ValueParameter)parameter.get());
    }

    public static <T, V extends ValueParameter<T>> Value.Builder<T> builder(@NonNull TypeToken<T> typeToken, @NonNull Supplier<V> parameter) {
        return Parameter.builder(typeToken, (ValueParameter)parameter.get());
    }

    public static Subcommand subcommand(@NonNull Command.Parameterized subcommand, @NonNull String alias, String ... aliases) {
        Subcommand.Builder builder = Sponge.game().builderProvider().provide(Subcommand.Builder.class).subcommand(subcommand).addAlias(alias);
        for (String a : aliases) {
            builder.addAlias(a);
        }
        return builder.build();
    }

    public static FirstOfBuilder firstOfBuilder(@NonNull Parameter parameter) {
        return Sponge.game().builderProvider().provide(FirstOfBuilder.class).or(parameter);
    }

    public static Parameter firstOf(@NonNull Parameter first, @NonNull Parameter second, Parameter ... parameters) {
        return Sponge.game().builderProvider().provide(FirstOfBuilder.class).or(first).or(second).orFirstOf(parameters).build();
    }

    public static Parameter firstOf(@NonNull Iterable<Parameter> parameters) {
        return Sponge.game().builderProvider().provide(FirstOfBuilder.class).orFirstOf(parameters).build();
    }

    public static SequenceBuilder seqBuilder(@NonNull Parameter parameter) {
        return Sponge.game().builderProvider().provide(SequenceBuilder.class).then(parameter);
    }

    public static Parameter seq(@NonNull Parameter first, @NonNull Parameter second, Parameter ... parameters) {
        return Sponge.game().builderProvider().provide(SequenceBuilder.class).then(first).then(second).then(parameters).build();
    }

    public static Parameter seq(@NonNull Iterable<Parameter> parameters) {
        return Sponge.game().builderProvider().provide(SequenceBuilder.class).then(parameters).build();
    }

    public static Value.Builder<BigDecimal> bigDecimal() {
        return Parameter.builder(BigDecimal.class, ResourceKeyedValueParameters.BIG_DECIMAL);
    }

    public static Value.Builder<BigInteger> bigInteger() {
        return Parameter.builder(BigInteger.class, ResourceKeyedValueParameters.BIG_INTEGER);
    }

    public static Value.Builder<BlockState> blockState() {
        return Parameter.builder(BlockState.class, ResourceKeyedValueParameters.BLOCK_STATE);
    }

    public static Value.Builder<Boolean> bool() {
        return Parameter.builder(Boolean.class, ResourceKeyedValueParameters.BOOLEAN);
    }

    public static Value.Builder<Color> color() {
        return Parameter.builder(Color.class, ResourceKeyedValueParameters.COLOR);
    }

    public static Value.Builder<DataContainer> dataContainer() {
        return Parameter.builder(DataContainer.class, ResourceKeyedValueParameters.DATA_CONTAINER);
    }

    public static Value.Builder<LocalDateTime> dateTime() {
        return Parameter.builder(LocalDateTime.class, ResourceKeyedValueParameters.DATE_TIME);
    }

    public static Value.Builder<Duration> duration() {
        return Parameter.builder(Duration.class, ResourceKeyedValueParameters.DURATION);
    }

    public static Value.Builder<Double> doubleNumber() {
        return Parameter.builder(Double.class, ResourceKeyedValueParameters.DOUBLE);
    }

    public static Value.Builder<Entity> entity() {
        return Parameter.builder(Entity.class, ResourceKeyedValueParameters.ENTITY);
    }

    public static Value.Builder<Entity> entityOrTarget() {
        return Parameter.entity().addParser(ResourceKeyedValueParameters.TARGET_ENTITY);
    }

    public static Value.Builder<Component> formattingCodeText() {
        return Parameter.builder(Component.class, ResourceKeyedValueParameters.TEXT_FORMATTING_CODE);
    }

    public static Value.Builder<Component> formattingCodeTextOfRemainingElements() {
        return Parameter.builder(Component.class, ResourceKeyedValueParameters.TEXT_FORMATTING_CODE_ALL);
    }

    public static Value.Builder<Integer> integerNumber() {
        return Parameter.builder(Integer.class, ResourceKeyedValueParameters.INTEGER);
    }

    public static Value.Builder<InetAddress> ip() {
        return Parameter.builder(InetAddress.class, ResourceKeyedValueParameters.IP);
    }

    public static Value.Builder<ItemStackSnapshot> itemStackSnapshot() {
        return Parameter.builder(ItemStackSnapshot.class, ResourceKeyedValueParameters.ITEM_STACK_SNAPSHOT);
    }

    public static Value.Builder<Component> jsonText() {
        return Parameter.builder(Component.class, ResourceKeyedValueParameters.TEXT_JSON);
    }

    public static Value.Builder<Component> jsonTextOfRemainingElements() {
        return Parameter.builder(Component.class, ResourceKeyedValueParameters.TEXT_JSON_ALL);
    }

    public static Value.Builder<ServerLocation> location() {
        return Parameter.builder(ServerLocation.class, ResourceKeyedValueParameters.LOCATION);
    }

    public static Value.Builder<Long> longNumber() {
        return Parameter.builder(Long.class, ResourceKeyedValueParameters.LONG);
    }

    public static Value.Builder<Operator> operator() {
        return Parameter.builder(Operator.class, ResourceKeyedValueParameters.OPERATOR);
    }

    public static Value.Builder<ServerPlayer> player() {
        return Parameter.builder(ServerPlayer.class, ResourceKeyedValueParameters.PLAYER);
    }

    public static Value.Builder<ServerPlayer> playerOrTarget() {
        return Parameter.player().addParser(ResourceKeyedValueParameters.TARGET_PLAYER);
    }

    public static Value.Builder<PluginContainer> plugin() {
        return Parameter.builder(PluginContainer.class, ResourceKeyedValueParameters.PLUGIN);
    }

    public static Value.Builder<Double> rangedDouble(double min2, double max) {
        return Parameter.builder(Double.class).addParser((ValueParser<Double>)VariableValueParameters.doubleRange().min(min2).max(max).build());
    }

    public static Value.Builder<Integer> rangedInteger(int min2, int max) {
        return Parameter.builder(Integer.class).addParser((ValueParser<Integer>)VariableValueParameters.integerRange().min(min2).max(max).build());
    }

    public static Value.Builder<String> remainingJoinedStrings() {
        return Parameter.builder(String.class, ResourceKeyedValueParameters.REMAINING_JOINED_STRINGS);
    }

    public static Value.Builder<ResourceKey> resourceKey() {
        return Parameter.builder(ResourceKey.class, ResourceKeyedValueParameters.RESOURCE_KEY);
    }

    public static Value.Builder<Vector3d> rotation() {
        return Parameter.builder(Vector3d.class, ResourceKeyedValueParameters.ROTATION);
    }

    public static Value.Builder<String> string() {
        return Parameter.builder(String.class, ResourceKeyedValueParameters.STRING);
    }

    public static Value.Builder<URL> url() {
        return Parameter.builder(URL.class, ResourceKeyedValueParameters.URL);
    }

    public static Value.Builder<UUID> user() {
        return Parameter.builder(UUID.class, ResourceKeyedValueParameters.USER);
    }

    public static Value.Builder<UUID> uuid() {
        return Parameter.builder(UUID.class, ResourceKeyedValueParameters.UUID);
    }

    public static Value.Builder<Vector3d> vector3d() {
        return Parameter.builder(Vector3d.class, ResourceKeyedValueParameters.VECTOR3D);
    }

    public static Value.Builder<ServerWorld> world() {
        return Parameter.builder(ServerWorld.class, ResourceKeyedValueParameters.WORLD);
    }

    public static <T> Value.Builder<T> registryElement(TypeToken<T> type, @NonNull Function<CommandContext, @Nullable RegistryHolder> holderProvider, @NonNull RegistryType<T> registryKey, String ... defaultNamespaces) {
        return Parameter.registryElement(type, Collections.singletonList(holderProvider), registryKey, defaultNamespaces);
    }

    public static <T> Value.Builder<T> registryElement(@NonNull TypeToken<T> type, @NonNull List<Function<CommandContext, @Nullable RegistryHolder>> holderProviders, @NonNull RegistryType<T> registryKey, String ... defaultNamespaces) {
        VariableValueParameters.RegistryEntryBuilder<T> vvp = VariableValueParameters.registryEntryBuilder(holderProviders, registryKey);
        for (String namespace : defaultNamespaces) {
            vvp.defaultNamespace(namespace);
        }
        return Parameter.builder(type, vvp.build());
    }

    public static <T> Value.Builder<T> registryElement(TypeToken<T> type, @NonNull DefaultedRegistryType<T> registryType, String ... defaultNamespaces) {
        VariableValueParameters.RegistryEntryBuilder<T> vvp = VariableValueParameters.registryEntryBuilder(registryType);
        for (String namespace : defaultNamespaces) {
            vvp.defaultNamespace(namespace);
        }
        return Parameter.builder(type, vvp.build());
    }

    public static Value.Builder<String> choices(String ... choices) {
        VariableValueParameters.StaticChoicesBuilder<String> builder = VariableValueParameters.staticChoicesBuilder(String.class).showInUsage(true);
        for (String choice : choices) {
            builder.addChoice(choice, choice);
        }
        return Parameter.builder(String.class, builder.build());
    }

    public static <T> Value.Builder<T> choices(@NonNull Class<T> returnType, @NonNull Map<String, ? extends T> choices) {
        return Parameter.builder(returnType, VariableValueParameters.staticChoicesBuilder(returnType).addChoices(choices).showInUsage(true).build());
    }

    public static <T> Value.Builder<T> choices(@NonNull Class<T> returnType, @NonNull Function<String, ? extends T> valueFunction, @NonNull Supplier<? extends Collection<String>> choices) {
        return Parameter.builder(returnType, VariableValueParameters.dynamicChoicesBuilder(returnType).showInUsage(true).choices(choices).results(valueFunction).build());
    }

    public static <T extends Enum<T>> Value.Builder<T> enumValue(@NonNull Class<T> enumClass) {
        return Parameter.builder(enumClass, VariableValueParameters.enumChoices(enumClass));
    }

    public static <T> Value.Builder<T> literal(@NonNull Class<T> returnType, @NonNull T returnedValue, String ... literal) {
        List<String> iterable = Arrays.asList(literal);
        return Parameter.literal(returnType, returnedValue, () -> iterable);
    }

    public static <T> Value.Builder<T> literal(@NonNull Class<T> returnType, @NonNull T returnedValue, @NonNull Supplier<? extends Collection<String>> literalSupplier) {
        return Parameter.builder(returnType, VariableValueParameters.literalBuilder(returnType).returnValue(() -> returnedValue).literal(literalSupplier).build());
    }

    public boolean isOptional();

    public boolean isTerminal();

    public static interface Factory {
        public <T> Value.Builder<T> createParameterBuilder(Key<T> var1);

        public <T> Value.Builder<T> createParameterBuilder(TypeToken<T> var1);

        public <T> Value.Builder<T> createParameterBuilder(Class<T> var1);
    }

    public static interface FirstOfBuilder
    extends Builder<Multi, FirstOfBuilder> {
        public FirstOfBuilder terminal();

        public FirstOfBuilder optional();

        public FirstOfBuilder or(Parameter var1);

        default public FirstOfBuilder orFirstOf(Parameter ... parameters) {
            return this.orFirstOf(Arrays.asList(parameters));
        }

        default public FirstOfBuilder orFirstOf(@NonNull Iterable<Parameter> parameters) {
            for (Parameter parameter : parameters) {
                this.or(parameter);
            }
            return this;
        }

        public Multi build();
    }

    public static interface SequenceBuilder
    extends Builder<Multi, SequenceBuilder> {
        public SequenceBuilder terminal();

        public SequenceBuilder optional();

        public SequenceBuilder then(Parameter var1);

        default public SequenceBuilder then(Parameter ... parameters) {
            return this.then(Arrays.asList(parameters));
        }

        default public SequenceBuilder then(@NonNull Iterable<Parameter> parameters) {
            for (Parameter parameter : parameters) {
                this.then(parameter);
            }
            return this;
        }

        public Multi build();
    }

    public static interface Multi
    extends Parameter {
        public List<Parameter> childParameters();
    }

    public static interface Subcommand
    extends Parameter {
        public Command.Parameterized command();

        public Set<String> aliases();

        public static interface Builder
        extends org.spongepowered.api.util.Builder<Subcommand, Builder> {
            public Builder addAlias(String var1);

            public Builder subcommand(Command.Parameterized var1);

            public Subcommand build();
        }
    }

    public static interface Value<T>
    extends Parameter {
        public Key<T> key();

        public Collection<ValueParser<? extends T>> parsers();

        public ValueCompleter completer();

        public Optional<ValueParameterModifier<T>> modifier();

        public Optional<ValueUsage> valueUsage();

        public Predicate<CommandCause> requirement();

        public void parse(@NonNull ArgumentReader.Mutable var1, @NonNull CommandContext.Builder var2) throws ArgumentParseException;

        public List<CommandCompletion> complete(@NonNull ArgumentReader.Immutable var1, @NonNull CommandContext var2) throws ArgumentParseException;

        public String usage(CommandCause var1);

        public boolean willConsumeAllRemaining();

        public static interface Builder<T>
        extends org.spongepowered.api.util.Builder<Value<T>, Builder<T>> {
            public Builder<T> key(String var1);

            public Builder<T> key(Key<T> var1);

            public Builder<T> addParser(ValueParser<? extends T> var1);

            default public <V extends ValueParser<? extends T>> Builder<T> addParser(@NonNull DefaultedRegistryReference<V> parser) {
                return this.addParser((ValueParser)parser.get());
            }

            public Builder<T> completer(@Nullable ValueCompleter var1);

            public Builder<T> modifier(@Nullable ValueParameterModifier<T> var1);

            public Builder<T> usage(@Nullable ValueUsage var1);

            public Builder<T> requiredPermission(@Nullable String var1);

            public Builder<T> requirements(@Nullable Predicate<CommandCause> var1);

            public Builder<T> consumeAllRemaining();

            public Builder<T> optional();

            public Builder<T> terminal();

            public Value<T> build();
        }
    }

    public static interface Key<T> {
        public String key();

        public Type type();

        public boolean isInstance(Object var1);

        public T cast(Object var1);

        public static interface Builder
        extends ResettableBuilder<Key<?>, Builder> {
            public <T> Key<T> build(@NonNull String var1, @NonNull TypeToken<T> var2);

            public <T> Key<T> build(@NonNull String var1, @NonNull Class<T> var2);
        }
    }
}

