/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.context;

import java.util.Map;
import java.util.Objects;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public final class Context
implements Map.Entry<String, String> {
    public static final String USER_KEY = "user";
    public static final String WORLD_KEY = "world";
    public static final String DIMENSION_KEY = "dimension";
    public static final String REMOTE_IP_KEY = "remoteip";
    public static final String LOCAL_HOST_KEY = "localhost";
    public static final String LOCAL_IP_KEY = "localip";
    public static final String LOCAL_PORT_KEY = "localport";
    private final Map.Entry<String, String> wrapped;

    public Context(String key, String value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.wrapped = UnmodifiableCollections.immutableMapEntry(key, value);
    }

    @Override
    public String getKey() {
        return this.wrapped.getKey();
    }

    @Override
    public String getValue() {
        return this.wrapped.getValue();
    }

    @Override
    @Deprecated
    public String setValue(String value) {
        throw new UnsupportedOperationException("Contexts are immutable");
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Map.Entry && this.wrapped.equals(other);
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }
}

