/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.server;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.util.annotation.DoNotStore;
import org.spongepowered.api.world.ChunkRegenerateFlag;
import org.spongepowered.api.world.ChunkRegenerateFlags;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.Ticket;
import org.spongepowered.api.world.server.TicketType;
import org.spongepowered.math.vector.Vector3i;

@DoNotStore
public interface ChunkManager {
    public ServerWorld world();

    public boolean valid(Ticket<?> var1);

    public Ticks timeLeft(Ticket<?> var1);

    default public Optional<Ticket<Vector3i>> requestTicket(DefaultedRegistryReference<TicketType<Vector3i>> type, Vector3i chunkOrigin, int radius) {
        return this.requestTicket(type.get(), chunkOrigin, radius);
    }

    default public Optional<Ticket<Vector3i>> requestTicket(TicketType<Vector3i> type, Vector3i chunkOrigin, int radius) {
        return this.requestTicket(type, chunkOrigin, chunkOrigin, radius);
    }

    public <T> Optional<Ticket<T>> requestTicket(TicketType<T> var1, Vector3i var2, T var3, int var4);

    default public <T> Optional<Ticket<T>> requestTicket(DefaultedRegistryReference<TicketType<T>> type, Vector3i chunkOrigin, T value, int radius) {
        return this.requestTicket(type.get(), chunkOrigin, value, radius);
    }

    public boolean renewTicket(Ticket<?> var1);

    public boolean releaseTicket(Ticket<?> var1);

    public <T> Collection<Ticket<T>> findTickets(TicketType<T> var1);

    default public <T> Collection<Ticket<T>> findTickets(DefaultedRegistryReference<TicketType<T>> type) {
        return this.findTickets(type.get());
    }

    default public CompletableFuture<Boolean> regenerateChunk(Vector3i chunkPosition) {
        Objects.requireNonNull(chunkPosition, "chunkPosition");
        return this.regenerateChunk(chunkPosition.x(), chunkPosition.y(), chunkPosition.z(), ChunkRegenerateFlags.ALL.get());
    }

    default public CompletableFuture<Boolean> regenerateChunk(int cx, int cy, int cz) {
        return this.regenerateChunk(cx, cy, cz, ChunkRegenerateFlags.ALL.get());
    }

    default public CompletableFuture<Boolean> regenerateChunk(Vector3i chunkPosition, ChunkRegenerateFlag flag) {
        Objects.requireNonNull(chunkPosition, "chunkPosition");
        return this.regenerateChunk(chunkPosition.x(), chunkPosition.y(), chunkPosition.z(), Objects.requireNonNull(flag, "flag"));
    }

    public CompletableFuture<Boolean> regenerateChunk(int var1, int var2, int var3, ChunkRegenerateFlag var4);
}

