/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SharedConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.common.SpongeMinecraftVersion;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.scheduler.AsyncScheduler;
import org.spongepowered.common.scheduler.ServerScheduler;

@Singleton
public final class SpongeCommon {
    private static final Logger LOGGER = LogManager.getLogger(((Launch)Launch.instance()).id());
    private static final SpongeMinecraftVersion MINECRAFT_VERSION = new SpongeMinecraftVersion(SharedConstants.func_215069_a().getName(), SharedConstants.func_215069_a().getProtocolVersion());
    @Inject
    private static @Nullable SpongeGame game;

    private SpongeCommon() {
    }

    public static boolean initialized() {
        return game != null;
    }

    public static Logger logger() {
        return LOGGER;
    }

    public static SpongeMinecraftVersion minecraftVersion() {
        return MINECRAFT_VERSION;
    }

    public static SpongeGame game() {
        if (game == null) {
            throw new IllegalStateException("SpongeCommon has not been initialized yet!");
        }
        return game;
    }

    public static MinecraftServer server() {
        return (MinecraftServer)Sponge.server();
    }

    public static ServerScheduler serverScheduler() {
        return (ServerScheduler)Sponge.server().scheduler();
    }

    public static AsyncScheduler asyncScheduler() {
        return SpongeCommon.game().asyncScheduler();
    }

    public static Path gameDirectory() {
        return ((Launch)Launch.instance()).pluginPlatform().baseDirectory();
    }

    public static Path pluginConfigDirectory() {
        return Paths.get(SpongeConfigs.getCommon().get().general.configDir.getParsed(), new String[0]);
    }

    public static Path spongeConfigDirectory() {
        return SpongeCommon.gameDirectory().resolve("config");
    }

    public static boolean post(Event event) {
        return Sponge.eventManager().post(event);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            @Nullable SpongeGame game = game;
            if (game != null) {
                try {
                    game.configManager().close();
                }
                catch (IOException e) {
                    SpongeCommon.logger().error("Failed to shut down configuration watch service", (Throwable)e);
                }
            }
        }, "Sponge shutdown thread"));
    }
}

