/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTrigger;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTriggerConfiguration;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.advancements.CriterionTrigger_ListenerAccessor;
import org.spongepowered.common.advancement.SpongeFilteredTrigger;
import org.spongepowered.common.bridge.advancements.CriterionTriggerBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;

public class SpongeCriterionTrigger
implements ICriterionTrigger<SpongeFilteredTrigger>,
CriterionTriggerBridge {
    private final Type triggerConfigurationType;
    final Function<JsonObject, FilteredTriggerConfiguration> constructor;
    private final ResourceLocation id;
    private final Multimap<PlayerAdvancements, ICriterionTrigger.Listener> listeners = HashMultimap.create();
    final @Nullable Consumer<CriterionEvent.Trigger> eventHandler;
    private final String name;

    SpongeCriterionTrigger(Type triggerConfigurationType, Function<JsonObject, FilteredTriggerConfiguration> constructor, ResourceLocation id, @Nullable Consumer<CriterionEvent.Trigger> eventHandler, String name) {
        this.triggerConfigurationType = triggerConfigurationType;
        this.eventHandler = eventHandler;
        this.constructor = constructor;
        this.id = id;
        this.name = name;
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener listener) {
        this.listeners.put((Object)playerAdvancementsIn, (Object)listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener listener) {
        this.listeners.remove((Object)playerAdvancementsIn, (Object)listener);
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.removeAll((Object)playerAdvancementsIn);
    }

    public SpongeFilteredTrigger createInstance(JsonObject json, ConditionArrayParser arrayParser) {
        return new SpongeFilteredTrigger(this, this.constructor.apply(json));
    }

    @Override
    public void bridge$trigger(ServerPlayer player) {
        PlayerAdvancements playerAdvancements = ((ServerPlayerEntity)player).func_192039_O();
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        TypeToken<?> typeToken = TypeToken.get(this.triggerConfigurationType);
        for (ICriterionTrigger.Listener listener : new ArrayList(this.listeners.get((Object)playerAdvancements))) {
            CriterionTrigger_ListenerAccessor mixinListener = (CriterionTrigger_ListenerAccessor)listener;
            Advancement advancement = (Advancement)mixinListener.accessor$advancement();
            AdvancementCriterion advancementCriterion = (AdvancementCriterion)((net.minecraft.advancements.Advancement)advancement).func_192073_f().get(mixinListener.accessor$criterion());
            CriterionEvent.Trigger<?> event = SpongeEventFactory.createCriterionEventTrigger(cause, advancement, advancementCriterion, typeToken, player, (FilteredTrigger)listener.func_192158_a(), this.eventHandler == null);
            if (this.eventHandler != null) {
                this.eventHandler.accept(event);
                if (!event.result()) continue;
            }
            SpongeCommon.post(event);
            if (!event.result()) continue;
            listener.func_192159_a(playerAdvancements);
        }
    }

    public @Nullable Consumer<CriterionEvent.Trigger> getEventHandler() {
        return this.eventHandler;
    }
}

