/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.bridge.adventure.ComponentBridge;
import org.spongepowered.common.bridge.network.chat.BaseComponentBridge;
import org.spongepowered.common.util.LocaleCache;

public class AdventureTextComponent
implements ITextComponent,
BaseComponentBridge {
    private @MonotonicNonNull ITextComponent converted;
    private @Nullable Locale deepConvertedLocalized;
    private final Component wrapped;
    private final @Nullable ComponentRenderer<Locale> renderer;
    private @Nullable Locale lastLocale;
    private @Nullable AdventureTextComponent lastRendered;

    public AdventureTextComponent(Component wrapped, @Nullable ComponentRenderer<Locale> renderer) {
        this.wrapped = wrapped;
        this.renderer = renderer;
    }

    public @Nullable ComponentRenderer<Locale> renderer() {
        return this.renderer;
    }

    public Component wrapped() {
        return this.wrapped;
    }

    public synchronized AdventureTextComponent rendered(Locale locale) {
        if (Objects.equals(locale, this.lastLocale)) {
            return this.lastRendered;
        }
        this.lastLocale = locale;
        this.lastRendered = this.renderer == null ? this : new AdventureTextComponent(this.renderer.render(this.wrapped, (Object)locale), null);
        return this.lastRendered;
    }

    ITextComponent deepConverted() {
        ITextComponent converted = this.converted;
        if (converted == null || this.deepConvertedLocalized != null) {
            converted = this.converted = ((ComponentBridge)this.wrapped).bridge$asVanillaComponent();
            this.deepConvertedLocalized = null;
        }
        return converted;
    }

    @OnlyIn(value=Dist.CLIENT)
    ITextComponent deepConvertedLocalized() {
        ITextComponent converted = this.converted;
        Locale target = LocaleCache.getLocale(Minecraft.func_71410_x().field_71474_y.field_74363_ab);
        if (converted == null || this.deepConvertedLocalized != target) {
            converted = this.converted = this.rendered(target).deepConverted();
            this.deepConvertedLocalized = target;
        }
        return converted;
    }

    public @Nullable ITextComponent deepConvertedIfPresent() {
        return this.converted;
    }

    public Style func_150256_b() {
        return this.deepConverted().func_150256_b();
    }

    public String getString() {
        return this.rendered(Locale.getDefault()).deepConverted().getString();
    }

    public String func_212636_a(int length) {
        return this.deepConverted().func_212636_a(length);
    }

    public String func_150261_e() {
        if (this.wrapped instanceof TextComponent) {
            return ((TextComponent)this.wrapped).content();
        }
        return this.deepConverted().func_150261_e();
    }

    public List<ITextComponent> func_150253_a() {
        return this.deepConverted().func_150253_a();
    }

    public IFormattableTextComponent func_230531_f_() {
        return this.deepConverted().func_230531_f_();
    }

    public IFormattableTextComponent func_230532_e_() {
        return this.deepConverted().func_230532_e_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public IReorderingProcessor func_241878_f() {
        return this.deepConvertedLocalized().func_241878_f();
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> Optional<T> func_230439_a_(ITextProperties.IStyledTextAcceptor<T> visitor, Style style) {
        return this.deepConvertedLocalized().func_230439_a_(visitor, style);
    }

    public <T> Optional<T> func_230438_a_(ITextProperties.ITextAcceptor<T> visitor) {
        return this.deepConverted().func_230438_a_(visitor);
    }

    @Override
    public Component bridge$asAdventureComponent() {
        return this.wrapped;
    }

    @Override
    public @Nullable Component bridge$adventureComponentIfPresent() {
        return this.bridge$asAdventureComponent();
    }
}

