/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.LanguageMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.common.accessor.client.KeyMappingAccessor;
import org.spongepowered.common.launch.Launch;

final class ComponentFlattenerProvider {
    private static final Pattern LOCALIZATION_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?s");
    static final ComponentFlattener INSTANCE;

    ComponentFlattenerProvider() {
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String resolveKeybind(KeybindComponent component) {
        KeyBinding mapping = KeyMappingAccessor.accessor$ALL().get(component.keybind());
        if (mapping != null) {
            return mapping.func_238171_j_().getString();
        }
        return component.keybind();
    }

    static {
        ComponentFlattener.Builder builder = (ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder();
        if (!((Launch)Launch.instance()).dedicatedServer()) {
            builder.mapper(KeybindComponent.class, ComponentFlattenerProvider::resolveKeybind);
        }
        builder.complexMapper(TranslatableComponent.class, (component, consumer) -> {
            String key = component.key();
            for (Translator registry : GlobalTranslator.get().sources()) {
                if (!(registry instanceof TranslationRegistry) || !((TranslationRegistry)registry).contains(key)) continue;
                consumer.accept(GlobalTranslator.render((Component)component, (Locale)Locale.getDefault()));
                return;
            }
            String translated = LanguageMap.func_74808_a().func_230503_a_(key);
            Matcher matcher = LOCALIZATION_PATTERN.matcher(translated);
            List args = component.args();
            int argPosition = 0;
            int lastIdx = 0;
            while (matcher.find()) {
                int idx;
                if (lastIdx < matcher.start()) {
                    consumer.accept(Component.text((String)translated.substring(lastIdx, matcher.start())));
                }
                lastIdx = matcher.end();
                String argIdx = matcher.group(1);
                if (argIdx != null) {
                    try {
                        idx = Integer.parseInt(argIdx);
                        if (idx >= args.size()) continue;
                        consumer.accept((Component)args.get(idx));
                    }
                    catch (NumberFormatException idx2) {}
                    continue;
                }
                if ((idx = argPosition++) >= args.size()) continue;
                consumer.accept((Component)args.get(idx));
            }
            if (lastIdx < translated.length()) {
                consumer.accept(Component.text((String)translated.substring(lastIdx)));
            }
        });
        INSTANCE = (ComponentFlattener)builder.build();
    }
}

