/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.util.Codec;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NbtLegacyHoverEventSerializer
implements LegacyHoverEventSerializer {
    public static final NbtLegacyHoverEventSerializer INSTANCE = new NbtLegacyHoverEventSerializer();
    private static final Codec<CompoundNBT, String, CommandSyntaxException, RuntimeException> SNBT_CODEC = Codec.of(JsonToNBT::func_180713_a, INBT::toString);
    static final String ITEM_TYPE = "id";
    static final String ITEM_COUNT = "Count";
    static final String ITEM_TAG = "tag";
    static final String ENTITY_NAME = "name";
    static final String ENTITY_TYPE = "type";
    static final String ENTITY_ID = "id";

    private NbtLegacyHoverEventSerializer() {
    }

    public HoverEvent.ShowItem deserializeShowItem(Component input) throws IOException {
        String rawContent = PlainTextComponentSerializer.plainText().serialize(input);
        try {
            CompoundNBT contents = (CompoundNBT)SNBT_CODEC.decode((Object)rawContent);
            CompoundNBT tag = contents.func_74775_l(ITEM_TAG);
            return HoverEvent.ShowItem.of((Key)Key.key((String)contents.func_74779_i("id")), (int)(contents.func_74764_b(ITEM_COUNT) ? contents.func_74771_c(ITEM_COUNT) : (byte)1), tag.isEmpty() ? null : BinaryTagHolder.encode((Object)tag, SNBT_CODEC));
        }
        catch (CommandSyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull HoverEvent.ShowEntity deserializeShowEntity(Component input, Codec.Decoder<Component, String, ? extends RuntimeException> componentCodec) throws IOException {
        String raw = PlainTextComponentSerializer.plainText().serialize(input);
        try {
            CompoundNBT contents = (CompoundNBT)SNBT_CODEC.decode((Object)raw);
            return HoverEvent.ShowEntity.of((Key)Key.key((String)contents.func_74779_i(ENTITY_TYPE)), (UUID)UUID.fromString(contents.func_74779_i("id")), (Component)((Component)componentCodec.decode((Object)contents.func_74779_i(ENTITY_NAME))));
        }
        catch (CommandSyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public @NonNull Component serializeShowItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull HoverEvent.ShowItem input) throws IOException {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("id", input.item().asString());
        tag.func_74774_a(ITEM_COUNT, (byte)input.count());
        if (input.nbt() != null) {
            try {
                tag.func_218657_a(ITEM_TAG, (INBT)input.nbt().get(SNBT_CODEC));
            }
            catch (CommandSyntaxException ex) {
                throw new IOException(ex);
            }
        }
        return Component.text((String)((String)SNBT_CODEC.encode((Object)tag)));
    }

    public @NonNull Component serializeShowEntity(HoverEvent.ShowEntity input, Codec.Encoder<Component, String, ? extends RuntimeException> componentCodec) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("id", input.id().toString());
        tag.func_74778_a(ENTITY_TYPE, input.type().asString());
        if (input.name() != null) {
            tag.func_74778_a(ENTITY_NAME, (String)componentCodec.encode((Object)input.name()));
        }
        return Component.text((String)((String)SNBT_CODEC.encode((Object)tag)));
    }
}

