/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.serializer.configurate4.ConfigurateComponentSerializer;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.util.Codec;
import net.kyori.adventure.util.TriState;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.server.ServerBossInfo;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.adventure.ResolveOperation;
import org.spongepowered.api.adventure.SpongeComponents;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.accessor.network.chat.HoverEvent_ItemStackInfoAccessor;
import org.spongepowered.common.accessor.network.chat.TextColorAccessor;
import org.spongepowered.common.adventure.AdventureTextComponent;
import org.spongepowered.common.adventure.CallbackCommand;
import org.spongepowered.common.adventure.ComponentFlattenerProvider;
import org.spongepowered.common.adventure.SpongeResolveOperation;
import org.spongepowered.common.bridge.adventure.BossBarBridge;
import org.spongepowered.common.bridge.adventure.StyleBridge;
import org.spongepowered.common.bridge.network.chat.BaseComponentBridge;
import org.spongepowered.common.bridge.world.BossEventBridge;
import org.spongepowered.common.launch.Launch;

public final class SpongeAdventure {
    public static final AttributeKey<Locale> CHANNEL_LOCALE = AttributeKey.newInstance((String)"sponge:locale");
    public static final Codec<CompoundNBT, String, IOException, IOException> NBT_CODEC = new Codec<CompoundNBT, String, IOException, IOException>(){

        public @NonNull CompoundNBT decode(@NonNull String encoded) throws IOException {
            try {
                return JsonToNBT.func_180713_a((String)encoded);
            }
            catch (CommandSyntaxException e) {
                throw new IOException(e);
            }
        }

        public @NonNull String encode(@NonNull CompoundNBT decoded) {
            return decoded.toString();
        }
    };
    public static final PrimitiveCodec<Component> STRING_CODEC = new PrimitiveCodec<Component>(){

        public <T> DataResult<Component> read(DynamicOps<T> ops, T input) {
            return ops.getStringValue(input).map(arg_0 -> ((GsonComponentSerializer)GsonComponentSerializer.gson()).deserialize(arg_0));
        }

        public <T> T write(DynamicOps<T> ops, Component value) {
            return (T)ops.createString((String)GsonComponentSerializer.gson().serialize(value));
        }

        public String toString() {
            return "String[Component]";
        }
    };
    public static final ConfigurateComponentSerializer CONFIGURATE = ConfigurateComponentSerializer.builder().scalarSerializer((ComponentSerializer)GsonComponentSerializer.gson()).build();
    private static final Set<ServerBossInfo> ACTIVE_BOSS_BARS = ConcurrentHashMap.newKeySet();

    public static TriState asAdventure(Tristate state) {
        if (state == Tristate.UNDEFINED) {
            return TriState.NOT_SET;
        }
        if (state == Tristate.FALSE) {
            return TriState.FALSE;
        }
        if (state == Tristate.TRUE) {
            return TriState.TRUE;
        }
        throw new IllegalArgumentException(state.name());
    }

    public static Key asAdventure(ResourceLocation key) {
        return (Key)key;
    }

    public static @Nullable ITextComponent asVanillaNullable(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        return SpongeAdventure.asVanilla(component);
    }

    public static ITextComponent asVanilla(Component component) {
        return new AdventureTextComponent(component, (ComponentRenderer<Locale>)GlobalTranslator.renderer());
    }

    public static Component asAdventure(ITextComponent component) {
        return ((BaseComponentBridge)component).bridge$asAdventureComponent();
    }

    public static Component asAdventure(Message message) {
        if (message instanceof ITextComponent) {
            return SpongeAdventure.asAdventure((ITextComponent)message);
        }
        if (message instanceof Component) {
            return (Component)message;
        }
        return Component.text((String)message.getString());
    }

    public static Style asVanilla(net.kyori.adventure.text.format.Style style) {
        return ((StyleBridge)style).bridge$asVanilla();
    }

    public static @Nullable Color asVanillaNullable(@Nullable TextColor color) {
        if (color == null) {
            return null;
        }
        return Color.func_240743_a_((int)color.value());
    }

    public static TextFormatting asVanilla(NamedTextColor color) {
        if (color == NamedTextColor.BLACK) {
            return TextFormatting.BLACK;
        }
        if (color == NamedTextColor.DARK_BLUE) {
            return TextFormatting.DARK_BLUE;
        }
        if (color == NamedTextColor.DARK_GREEN) {
            return TextFormatting.DARK_GREEN;
        }
        if (color == NamedTextColor.DARK_AQUA) {
            return TextFormatting.DARK_AQUA;
        }
        if (color == NamedTextColor.DARK_RED) {
            return TextFormatting.DARK_RED;
        }
        if (color == NamedTextColor.DARK_PURPLE) {
            return TextFormatting.DARK_PURPLE;
        }
        if (color == NamedTextColor.GOLD) {
            return TextFormatting.GOLD;
        }
        if (color == NamedTextColor.GRAY) {
            return TextFormatting.GRAY;
        }
        if (color == NamedTextColor.DARK_GRAY) {
            return TextFormatting.DARK_GRAY;
        }
        if (color == NamedTextColor.BLUE) {
            return TextFormatting.BLUE;
        }
        if (color == NamedTextColor.GREEN) {
            return TextFormatting.GREEN;
        }
        if (color == NamedTextColor.AQUA) {
            return TextFormatting.AQUA;
        }
        if (color == NamedTextColor.RED) {
            return TextFormatting.RED;
        }
        if (color == NamedTextColor.LIGHT_PURPLE) {
            return TextFormatting.LIGHT_PURPLE;
        }
        if (color == NamedTextColor.YELLOW) {
            return TextFormatting.YELLOW;
        }
        if (color == NamedTextColor.WHITE) {
            return TextFormatting.WHITE;
        }
        throw new IllegalArgumentException();
    }

    public static @Nullable TextColor asAdventure(@Nullable Color color) {
        if (color == null) {
            return null;
        }
        return TextColor.color((int)((TextColorAccessor)color).accessor$value());
    }

    public static @Nullable TextColor asAdventure(TextFormatting formatting) {
        if (formatting == null) {
            return null;
        }
        Integer color = formatting.func_211163_e();
        if (color == null) {
            return null;
        }
        return TextColor.color((int)color);
    }

    public static @Nullable NamedTextColor asAdventureNamed(@Nullable TextFormatting color) {
        if (color == null) {
            return null;
        }
        if (color == TextFormatting.BLACK) {
            return NamedTextColor.BLACK;
        }
        if (color == TextFormatting.DARK_BLUE) {
            return NamedTextColor.DARK_BLUE;
        }
        if (color == TextFormatting.DARK_GREEN) {
            return NamedTextColor.DARK_GREEN;
        }
        if (color == TextFormatting.DARK_AQUA) {
            return NamedTextColor.DARK_AQUA;
        }
        if (color == TextFormatting.DARK_RED) {
            return NamedTextColor.DARK_RED;
        }
        if (color == TextFormatting.DARK_PURPLE) {
            return NamedTextColor.DARK_PURPLE;
        }
        if (color == TextFormatting.GOLD) {
            return NamedTextColor.GOLD;
        }
        if (color == TextFormatting.GRAY) {
            return NamedTextColor.GRAY;
        }
        if (color == TextFormatting.DARK_GRAY) {
            return NamedTextColor.DARK_GRAY;
        }
        if (color == TextFormatting.BLUE) {
            return NamedTextColor.BLUE;
        }
        if (color == TextFormatting.GREEN) {
            return NamedTextColor.GREEN;
        }
        if (color == TextFormatting.AQUA) {
            return NamedTextColor.AQUA;
        }
        if (color == TextFormatting.RED) {
            return NamedTextColor.RED;
        }
        if (color == TextFormatting.LIGHT_PURPLE) {
            return NamedTextColor.LIGHT_PURPLE;
        }
        if (color == TextFormatting.YELLOW) {
            return NamedTextColor.YELLOW;
        }
        return NamedTextColor.WHITE;
    }

    public static @Nullable Boolean asVanillaNullable(TextDecoration.State state) {
        if (state == TextDecoration.State.TRUE) {
            return true;
        }
        if (state == TextDecoration.State.FALSE) {
            return false;
        }
        return null;
    }

    public static ChatType asVanilla(MessageType type) {
        if (type == MessageType.SYSTEM) {
            return ChatType.SYSTEM;
        }
        if (type == MessageType.CHAT) {
            return ChatType.CHAT;
        }
        throw new IllegalArgumentException(type.name());
    }

    public static net.kyori.adventure.text.event.HoverEvent<?> asAdventure(HoverEvent event) {
        HoverEvent.Action action = event.func_150701_a();
        if (action == HoverEvent.Action.field_230550_a_) {
            return net.kyori.adventure.text.event.HoverEvent.showText((Component)SpongeAdventure.asAdventure((ITextComponent)event.func_240662_a_(HoverEvent.Action.field_230550_a_)));
        }
        if (action == HoverEvent.Action.field_230552_c_) {
            HoverEvent.EntityHover value = (HoverEvent.EntityHover)event.func_240662_a_(HoverEvent.Action.field_230552_c_);
            return net.kyori.adventure.text.event.HoverEvent.showEntity((Key)SpongeAdventure.asAdventure(Registry.field_212629_r.func_177774_c((Object)value.field_240677_a_)), (UUID)value.field_240678_b_, (Component)SpongeAdventure.asAdventure(value.field_240679_c_));
        }
        if (action == HoverEvent.Action.field_230551_b_) {
            HoverEvent.ItemHover value = (HoverEvent.ItemHover)event.func_240662_a_(HoverEvent.Action.field_230551_b_);
            return net.kyori.adventure.text.event.HoverEvent.showItem((Key)SpongeAdventure.asAdventure(Registry.field_212630_s.func_177774_c((Object)((HoverEvent_ItemStackInfoAccessor)value).accessor$item())), (int)((HoverEvent_ItemStackInfoAccessor)value).accessor$count(), (BinaryTagHolder)SpongeAdventure.asBinaryTagHolder(((HoverEvent_ItemStackInfoAccessor)value).accessor$tag()));
        }
        throw new IllegalArgumentException(event.toString());
    }

    public static @Nullable net.minecraft.util.text.event.ClickEvent asVanillaNullable(@Nullable ClickEvent event) {
        if (event == null) {
            return null;
        }
        return new net.minecraft.util.text.event.ClickEvent(SpongeAdventure.asVanilla(event.action()), event.value());
    }

    public static @Nullable HoverEvent asVanillaNullable(@Nullable net.kyori.adventure.text.event.HoverEvent<?> event) {
        if (event == null) {
            return null;
        }
        HoverEvent.Action action = event.action();
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)SpongeAdventure.asVanilla((Component)event.value()));
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity value = (HoverEvent.ShowEntity)event.value();
            return new HoverEvent(HoverEvent.Action.field_230552_c_, (Object)new HoverEvent.EntityHover((EntityType)Registry.field_212629_r.func_82594_a(SpongeAdventure.asVanilla(value.type())), value.id(), SpongeAdventure.asVanillaNullable(value.name())));
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            HoverEvent.ShowItem value = (HoverEvent.ShowItem)event.value();
            return new HoverEvent(HoverEvent.Action.field_230551_b_, (Object)HoverEvent_ItemStackInfoAccessor.invoker$new((Item)Registry.field_212630_s.func_82594_a(SpongeAdventure.asVanilla(value.item())), value.count(), SpongeAdventure.asVanillaCompound(value.nbt())));
        }
        throw new IllegalArgumentException(event.toString());
    }

    public static HoverEvent.Action<?> asVanilla(HoverEvent.Action<?> action) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return HoverEvent.Action.field_230550_a_;
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            return HoverEvent.Action.field_230551_b_;
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            return HoverEvent.Action.field_230552_c_;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static ClickEvent.Action asAdventure(ClickEvent.Action action) {
        if (action == ClickEvent.Action.OPEN_URL) {
            return ClickEvent.Action.OPEN_URL;
        }
        if (action == ClickEvent.Action.OPEN_FILE) {
            return ClickEvent.Action.OPEN_FILE;
        }
        if (action == ClickEvent.Action.RUN_COMMAND) {
            return ClickEvent.Action.RUN_COMMAND;
        }
        if (action == ClickEvent.Action.SUGGEST_COMMAND) {
            return ClickEvent.Action.SUGGEST_COMMAND;
        }
        if (action == ClickEvent.Action.CHANGE_PAGE) {
            return ClickEvent.Action.CHANGE_PAGE;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static ClickEvent.Action asVanilla(ClickEvent.Action action) {
        if (action == ClickEvent.Action.OPEN_URL) {
            return ClickEvent.Action.OPEN_URL;
        }
        if (action == ClickEvent.Action.OPEN_FILE) {
            return ClickEvent.Action.OPEN_FILE;
        }
        if (action == ClickEvent.Action.RUN_COMMAND) {
            return ClickEvent.Action.RUN_COMMAND;
        }
        if (action == ClickEvent.Action.SUGGEST_COMMAND) {
            return ClickEvent.Action.SUGGEST_COMMAND;
        }
        if (action == ClickEvent.Action.CHANGE_PAGE) {
            return ClickEvent.Action.CHANGE_PAGE;
        }
        if (action == ClickEvent.Action.COPY_TO_CLIPBOARD) {
            return ClickEvent.Action.COPY_TO_CLIPBOARD;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static List<Component> json(List<String> strings) {
        GsonComponentSerializer gcs = GsonComponentSerializer.gson();
        ArrayList<Component> components = new ArrayList<Component>();
        for (String string : strings) {
            components.add(gcs.deserialize((Object)string));
        }
        return components;
    }

    public static ListNBT listTagJson(List<Component> components) {
        GsonComponentSerializer gcs = GsonComponentSerializer.gson();
        ListNBT nbt = new ListNBT();
        for (Component component : components) {
            nbt.add((Object)StringNBT.func_229705_a_((String)((String)gcs.serialize(component))));
        }
        return nbt;
    }

    public static BossBar asAdventure(BossInfo bar) {
        return ((BossEventBridge)bar).bridge$asAdventure();
    }

    public static ServerBossInfo asVanillaServer(BossBar bar) {
        return ((BossBarBridge)bar).bridge$asVanillaServerBar();
    }

    public static BossInfo.Color asVanilla(BossBar.Color color) {
        if (color == BossBar.Color.PINK) {
            return BossInfo.Color.PINK;
        }
        if (color == BossBar.Color.BLUE) {
            return BossInfo.Color.BLUE;
        }
        if (color == BossBar.Color.RED) {
            return BossInfo.Color.RED;
        }
        if (color == BossBar.Color.GREEN) {
            return BossInfo.Color.GREEN;
        }
        if (color == BossBar.Color.YELLOW) {
            return BossInfo.Color.YELLOW;
        }
        if (color == BossBar.Color.PURPLE) {
            return BossInfo.Color.PURPLE;
        }
        if (color == BossBar.Color.WHITE) {
            return BossInfo.Color.WHITE;
        }
        throw new IllegalArgumentException(color.name());
    }

    public static BossBar.Color asAdventure(BossInfo.Color color) {
        if (color == BossInfo.Color.PINK) {
            return BossBar.Color.PINK;
        }
        if (color == BossInfo.Color.BLUE) {
            return BossBar.Color.BLUE;
        }
        if (color == BossInfo.Color.RED) {
            return BossBar.Color.RED;
        }
        if (color == BossInfo.Color.GREEN) {
            return BossBar.Color.GREEN;
        }
        if (color == BossInfo.Color.YELLOW) {
            return BossBar.Color.YELLOW;
        }
        if (color == BossInfo.Color.PURPLE) {
            return BossBar.Color.PURPLE;
        }
        if (color == BossInfo.Color.WHITE) {
            return BossBar.Color.WHITE;
        }
        throw new IllegalArgumentException(color.name());
    }

    public static BossInfo.Overlay asVanilla(BossBar.Overlay overlay) {
        if (overlay == BossBar.Overlay.PROGRESS) {
            return BossInfo.Overlay.PROGRESS;
        }
        if (overlay == BossBar.Overlay.NOTCHED_6) {
            return BossInfo.Overlay.NOTCHED_6;
        }
        if (overlay == BossBar.Overlay.NOTCHED_10) {
            return BossInfo.Overlay.NOTCHED_10;
        }
        if (overlay == BossBar.Overlay.NOTCHED_12) {
            return BossInfo.Overlay.NOTCHED_12;
        }
        if (overlay == BossBar.Overlay.NOTCHED_20) {
            return BossInfo.Overlay.NOTCHED_20;
        }
        throw new IllegalArgumentException(overlay.name());
    }

    public static BossBar.Overlay asAdventure(BossInfo.Overlay overlay) {
        if (overlay == BossInfo.Overlay.PROGRESS) {
            return BossBar.Overlay.PROGRESS;
        }
        if (overlay == BossInfo.Overlay.NOTCHED_6) {
            return BossBar.Overlay.NOTCHED_6;
        }
        if (overlay == BossInfo.Overlay.NOTCHED_10) {
            return BossBar.Overlay.NOTCHED_10;
        }
        if (overlay == BossInfo.Overlay.NOTCHED_12) {
            return BossBar.Overlay.NOTCHED_12;
        }
        if (overlay == BossInfo.Overlay.NOTCHED_20) {
            return BossBar.Overlay.NOTCHED_20;
        }
        throw new IllegalArgumentException(overlay.name());
    }

    public static Set<BossBar.Flag> asAdventureFlags(boolean darkenScreen, boolean playBossMusic, boolean createWorldFog) {
        EnumSet<BossBar.Flag> flags = EnumSet.noneOf(BossBar.Flag.class);
        if (darkenScreen) {
            flags.add(BossBar.Flag.DARKEN_SCREEN);
        }
        if (playBossMusic) {
            flags.add(BossBar.Flag.PLAY_BOSS_MUSIC);
        }
        if (createWorldFog) {
            flags.add(BossBar.Flag.CREATE_WORLD_FOG);
        }
        return flags;
    }

    public static @Nullable CompoundNBT asVanillaCompound(@Nullable BinaryTagHolder tag) {
        if (tag == null) {
            return null;
        }
        try {
            return (CompoundNBT)tag.get(NBT_CODEC);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static @Nullable BinaryTagHolder asBinaryTagHolder(@Nullable CompoundNBT tag) {
        if (tag == null) {
            return null;
        }
        try {
            return BinaryTagHolder.encode((Object)tag, NBT_CODEC);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static ResourceLocation asVanilla(Key key) {
        if (key instanceof ResourceLocation) {
            return (ResourceLocation)key;
        }
        return new ResourceLocation(key.namespace(), key.value());
    }

    public static @Nullable ResourceLocation asVanillaNullable(@Nullable Key key) {
        if (key == null) {
            return null;
        }
        return SpongeAdventure.asVanilla(key);
    }

    public static Sound.Source asAdventure(SoundCategory source) {
        switch (source) {
            case MASTER: {
                return Sound.Source.MASTER;
            }
            case MUSIC: {
                return Sound.Source.MUSIC;
            }
            case RECORDS: {
                return Sound.Source.RECORD;
            }
            case WEATHER: {
                return Sound.Source.WEATHER;
            }
            case BLOCKS: {
                return Sound.Source.BLOCK;
            }
            case HOSTILE: {
                return Sound.Source.HOSTILE;
            }
            case NEUTRAL: {
                return Sound.Source.NEUTRAL;
            }
            case PLAYERS: {
                return Sound.Source.PLAYER;
            }
            case AMBIENT: {
                return Sound.Source.AMBIENT;
            }
            case VOICE: {
                return Sound.Source.VOICE;
            }
        }
        throw new IllegalArgumentException(source.name());
    }

    public static SoundCategory asVanilla(Sound.Source source) {
        switch (source) {
            case MASTER: {
                return SoundCategory.MASTER;
            }
            case MUSIC: {
                return SoundCategory.MUSIC;
            }
            case RECORD: {
                return SoundCategory.RECORDS;
            }
            case WEATHER: {
                return SoundCategory.WEATHER;
            }
            case BLOCK: {
                return SoundCategory.BLOCKS;
            }
            case HOSTILE: {
                return SoundCategory.HOSTILE;
            }
            case NEUTRAL: {
                return SoundCategory.NEUTRAL;
            }
            case PLAYER: {
                return SoundCategory.PLAYERS;
            }
            case AMBIENT: {
                return SoundCategory.AMBIENT;
            }
            case VOICE: {
                return SoundCategory.VOICE;
            }
        }
        throw new IllegalArgumentException(source.name());
    }

    public static @Nullable SoundCategory asVanillaNullable(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Sound.Source source) {
        if (source == null) {
            return null;
        }
        return SpongeAdventure.asVanilla(source);
    }

    public static Iterable<? extends Audience> unpackAudiences(Audience audience) {
        if (audience instanceof ForwardingAudience) {
            ArrayList list = new ArrayList();
            for (Audience subAudience : ((ForwardingAudience)audience).audiences()) {
                SpongeAdventure.unpackAudiences(subAudience).forEach(list::add);
            }
            return list;
        }
        return Collections.singletonList(audience);
    }

    public static void registerBossBar(ServerBossInfo mcBar) {
        ACTIVE_BOSS_BARS.add(mcBar);
    }

    public static void unregisterBossBar(ServerBossInfo mcBar) {
        ACTIVE_BOSS_BARS.remove(mcBar);
    }

    public static void forEachBossBar(Consumer<ServerBossInfo> info) {
        ACTIVE_BOSS_BARS.forEach(info);
    }

    public static class Factory
    implements SpongeComponents.Factory {
        @Override
        public @NonNull ClickEvent callbackClickEvent(@NonNull Consumer<CommandCause> callback) {
            Objects.requireNonNull(callback);
            UUID key = CallbackCommand.INSTANCE.registerCallback(callback);
            return ClickEvent.runCommand((String)String.format("/%s:%s %s", ((Launch)Launch.instance()).id(), "callback", key));
        }

        @Override
        @SafeVarargs
        public final @NonNull Component render(@NonNull Component component, @NonNull CommandCause senderContext, @Nullable Audience viewer, @NonNull DefaultedRegistryReference<ResolveOperation> firstOperation, DefaultedRegistryReference<ResolveOperation> ... otherOperations) {
            Component output = Objects.requireNonNull(component, "component");
            Objects.requireNonNull(senderContext, "senderContext");
            while (viewer instanceof ForwardingAudience.Single && !(viewer instanceof Entity)) {
                viewer = ((ForwardingAudience.Single)viewer).audience();
            }
            Entity backing = viewer instanceof Entity ? (Entity)viewer : null;
            output = ((SpongeResolveOperation)Objects.requireNonNull(firstOperation, "firstOperation").get()).resolve(output, senderContext, backing);
            for (DefaultedRegistryReference<ResolveOperation> ref : otherOperations) {
                output = ((SpongeResolveOperation)ref.get()).resolve(output, senderContext, backing);
            }
            return output;
        }

        @Override
        @SafeVarargs
        public final @NonNull Component render(@NonNull Component component, @NonNull CommandCause senderContext, @NonNull DefaultedRegistryReference<ResolveOperation> firstOperation, DefaultedRegistryReference<ResolveOperation> ... otherOperations) {
            return this.render(component, senderContext, (Audience)null, firstOperation, otherOperations);
        }

        @Override
        public ComponentFlattener flattener() {
            return ComponentFlattenerProvider.INSTANCE;
        }
    }
}

