/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandExecutor;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.common.command.SpongeParameterizedCommand;
import org.spongepowered.common.command.parameter.subcommand.SpongeSubcommandParameterBuilder;

public final class SpongeParameterizedCommandBuilder
implements Command.Builder {
    private final Set<String> claimedSubcommands = new HashSet<String>();
    private final Map<Command.Parameterized, List<String>> subcommands = new HashMap<Command.Parameterized, List<String>>();
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final List<Flag> flags = new ArrayList<Flag>();
    private final Set<String> flagAliases = new HashSet<String>();
    private @Nullable CommandExecutor commandExecutor;
    private Function<CommandCause, Optional<Component>> extendedDescription = cause -> Optional.empty();
    private Function<CommandCause, Optional<Component>> shortDescription = cause -> Optional.empty();
    private @Nullable Predicate<CommandCause> executionRequirements;
    private boolean isTerminal = false;

    @Override
    public @NonNull Command.Builder addChild(@NonNull Command.Parameterized child, @NonNull Iterable<String> aliases) {
        for (String alias : aliases) {
            if (!this.claimedSubcommands.contains(alias.toLowerCase())) continue;
            throw new IllegalStateException("The alias " + alias + " already has an associated subcommand.");
        }
        ArrayList s2 = new ArrayList();
        aliases.forEach(x -> s2.add(x.toLowerCase()));
        this.claimedSubcommands.addAll(s2);
        this.subcommands.put(child, s2);
        return this;
    }

    @Override
    public @NonNull Command.Builder addFlag(@NonNull Flag flag) {
        for (String alias : flag.aliases()) {
            if (!this.flagAliases.contains(alias)) continue;
            throw new IllegalArgumentException("The alias " + alias + " is already in use.");
        }
        this.flags.add(flag);
        this.flagAliases.addAll(flag.aliases());
        return this;
    }

    @Override
    public @NonNull Command.Builder addParameter(@NonNull Parameter parameter) {
        this.parameters.add(parameter);
        return this;
    }

    @Override
    public @NonNull Command.Builder executor(@NonNull CommandExecutor executor) {
        this.commandExecutor = executor;
        return this;
    }

    @Override
    public @NonNull Command.Builder extendedDescription(@Nullable Function<CommandCause, Optional<Component>> extendedDescriptionFunction) {
        this.extendedDescription = extendedDescriptionFunction == null ? cause -> Optional.empty() : extendedDescriptionFunction;
        return this;
    }

    @Override
    public @NonNull Command.Builder shortDescription(@Nullable Function<CommandCause, Optional<Component>> descriptionFunction) {
        this.shortDescription = descriptionFunction == null ? cause -> Optional.empty() : descriptionFunction;
        return this;
    }

    @Override
    public @NonNull Command.Builder permission(@Nullable String permission) {
        if (permission == null) {
            return this.executionRequirements(null);
        }
        return this.executionRequirements(commandCause -> commandCause.hasPermission(permission));
    }

    @Override
    public @NonNull Command.Builder executionRequirements(@Nullable Predicate<CommandCause> executionRequirements) {
        this.executionRequirements = executionRequirements;
        return this;
    }

    @Override
    public @NonNull Command.Builder terminal(boolean terminal) {
        this.isTerminal = terminal;
        return this;
    }

    @Override
    public @NonNull Command.Parameterized build() {
        if (this.subcommands.isEmpty()) {
            Preconditions.checkState((this.commandExecutor != null ? 1 : 0) != 0, (Object)"Either a subcommand or an executor must exist!");
        } else {
            Preconditions.checkState((this.parameters.isEmpty() || this.commandExecutor != null ? 1 : 0) != 0, (Object)"An executor must exist if you set parameters!");
        }
        Predicate<CommandCause> requirements = this.executionRequirements == null ? cause -> true : this.executionRequirements;
        List<Parameter.Subcommand> subcommands = this.subcommands.entrySet().stream().map(x -> new SpongeSubcommandParameterBuilder().aliases((Collection)x.getValue()).subcommand((Command.Parameterized)x.getKey()).build()).collect(Collectors.toList());
        return new SpongeParameterizedCommand(subcommands, (List<Parameter>)ImmutableList.copyOf(this.parameters), this.shortDescription, this.extendedDescription, requirements, this.commandExecutor, this.flags, this.isTerminal);
    }

    @Override
    public @NonNull Command.Builder reset() {
        this.subcommands.clear();
        this.claimedSubcommands.clear();
        this.commandExecutor = null;
        this.parameters.clear();
        this.flagAliases.clear();
        this.flags.clear();
        this.executionRequirements = null;
        this.extendedDescription = null;
        this.shortDescription = null;
        this.isTerminal = false;
        return this;
    }
}

