/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.dispatcher;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Collection;
import java.util.Locale;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.commands.CommandSourceStackBridge;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeCommandDispatcher;
import org.spongepowered.common.command.brigadier.tree.SpongePermissionWrappedLiteralCommandNode;
import org.spongepowered.common.service.server.permission.SpongePermissions;

public final class SpongeNodePermissionCache {
    private static final Pattern ILLEGAL_CHARS = Pattern.compile("[^a-zA-Z0-9]");
    private static final WeakHashMap<CommandNode<CommandSource>, Supplier<String>> PERMISSION_MAP = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canUse(boolean isRoot, SpongeCommandDispatcher dispatcher, CommandNode<CommandSource> node, CommandSource source) {
        CachingStringSupplier supplier = PERMISSION_MAP.get(node);
        if (supplier == null) {
            supplier = new CachingStringSupplier(() -> SpongeNodePermissionCache.createFromNode(dispatcher, node));
        }
        try {
            ((CommandSourceStackBridge)source).bridge$setPotentialPermissionNode(supplier);
            boolean result = node.canUse((Object)source);
            if (isRoot && node instanceof SpongePermissionWrappedLiteralCommandNode && ((CommandSourceStackBridge)source).bridge$getCommandSource() instanceof ServerPlayer) {
                SpongePermissions.registerPermission((String)supplier.get(), 0);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            ((CommandSourceStackBridge)source).bridge$setPotentialPermissionNode(null);
        }
    }

    public static String createFromNode(SpongeCommandDispatcher dispatcher, CommandNode<CommandSource> node) {
        String permission;
        if (node.getRedirect() != null && !(node.getRedirect() instanceof RootCommandNode) && node.getCommand() == null) {
            Supplier<String> permSupplier = PERMISSION_MAP.get(node);
            permission = permSupplier == null ? SpongeNodePermissionCache.createFromNode(dispatcher, (CommandNode<CommandSource>)node.getRedirect()) : permSupplier.get();
        } else {
            String permString;
            String pluginId;
            Collection path = dispatcher.getPath(node);
            if (path.isEmpty()) {
                pluginId = "unknown";
                permString = node.getName();
                SpongeCommon.logger().warn("No path to command node with name {} could be found when generating its permission node. Unable to determine owning plugin - using \"unknown\" as plugin ID", (Object)permString);
            } else {
                String original = (String)path.iterator().next();
                pluginId = dispatcher.getCommandManager().commandMapping(original).flatMap(x -> x.plugin().map(y -> y.metadata().id())).orElseGet(() -> {
                    SpongeCommon.logger().error("Root command /{} does not have an associated plugin! Using \"unknown\" in place of plugin ID for the permission.", (Object)original);
                    return "unknown";
                });
                permString = path.stream().map(x -> {
                    String replaced = ILLEGAL_CHARS.matcher((CharSequence)x).replaceAll("").toLowerCase(Locale.ROOT);
                    if (replaced.startsWith(pluginId)) {
                        return replaced.replaceFirst(pluginId, "");
                    }
                    if (replaced.isEmpty()) {
                        return "node";
                    }
                    return replaced;
                }).collect(Collectors.joining("."));
            }
            permission = pluginId + ".command." + permString + ".root";
        }
        PERMISSION_MAP.put(node, () -> permission);
        return permission;
    }

    private static final class CachingStringSupplier
    implements Supplier<String> {
        private @Nullable String cached = null;
        private final Supplier<String> stringSupplier;

        private CachingStringSupplier(Supplier<String> stringSupplier) {
            this.stringSupplier = stringSupplier;
        }

        @Override
        public String get() {
            if (this.cached == null) {
                this.cached = this.stringSupplier.get();
            }
            return this.cached;
        }
    }
}

