/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.builder;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.standard.VariableValueParameters;
import org.spongepowered.common.command.brigadier.argument.StandardArgumentParser;

public final class SpongeNumberRangeBuilder<T extends Number>
implements VariableValueParameters.NumberRangeBuilder<T> {
    private static final Definition<Double> DOUBLE = new Definition<Double>(){

        @Override
        public boolean validate(Double min2, Double max) {
            return min2 <= max;
        }

        @Override
        public ArgumentType<Double> createArgumentType(Double min2, Double max) {
            return DoubleArgumentType.doubleArg((double)min2, (double)max);
        }
    };
    private static final Definition<Float> FLOAT = new Definition<Float>(){

        @Override
        public boolean validate(Float min2, Float max) {
            return min2.floatValue() <= max.floatValue();
        }

        @Override
        public ArgumentType<Float> createArgumentType(Float min2, Float max) {
            return FloatArgumentType.floatArg((float)min2.floatValue(), (float)max.floatValue());
        }
    };
    private static final Definition<Integer> INTEGER = new Definition<Integer>(){

        @Override
        public boolean validate(Integer min2, Integer max) {
            return min2 <= max;
        }

        @Override
        public ArgumentType<Integer> createArgumentType(Integer min2, Integer max) {
            return IntegerArgumentType.integer((int)min2, (int)max);
        }
    };
    private static final Definition<Long> LONG = new Definition<Long>(){

        @Override
        public boolean validate(Long min2, Long max) {
            return min2 <= max;
        }

        @Override
        public ArgumentType<Long> createArgumentType(Long min2, Long max) {
            return LongArgumentType.longArg((long)min2, (long)max);
        }
    };
    private final Definition<T> definition;
    private final T defaultMin;
    private final T defaultMax;
    private T min;
    private T max;

    public static SpongeNumberRangeBuilder<Double> doubleBuilder() {
        return new SpongeNumberRangeBuilder<Double>((Double)Double.MIN_VALUE, (Double)Double.MAX_VALUE, DOUBLE);
    }

    public static SpongeNumberRangeBuilder<Float> floatBuilder() {
        return new SpongeNumberRangeBuilder<Float>(Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), FLOAT);
    }

    public static SpongeNumberRangeBuilder<Integer> intBuilder() {
        return new SpongeNumberRangeBuilder<Integer>(Integer.MIN_VALUE, Integer.MAX_VALUE, INTEGER);
    }

    public static SpongeNumberRangeBuilder<Long> longBuilder() {
        return new SpongeNumberRangeBuilder<Long>(Long.MIN_VALUE, Long.MAX_VALUE, LONG);
    }

    private SpongeNumberRangeBuilder(T min2, T max, Definition<T> definition) {
        this.defaultMin = min2;
        this.defaultMax = max;
        this.min = min2;
        this.max = max;
        this.definition = definition;
    }

    @Override
    public @NonNull VariableValueParameters.NumberRangeBuilder<T> min(@NonNull T min2) {
        this.min = (Number)Objects.requireNonNull(min2);
        return this;
    }

    @Override
    public @NonNull VariableValueParameters.NumberRangeBuilder<T> max(@NonNull T max) {
        this.max = (Number)Objects.requireNonNull(max);
        return this;
    }

    @Override
    public @NonNull ValueParameter<T> build() {
        if (!this.definition.validate(this.min, this.max)) {
            throw new IllegalStateException("Min must be smaller or equal to max!");
        }
        return StandardArgumentParser.createIdentity(this.definition.createArgumentType(this.min, this.max));
    }

    @Override
    public @NonNull VariableValueParameters.NumberRangeBuilder<T> reset() {
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        return this;
    }

    public static interface Definition<T extends Number> {
        public boolean validate(T var1, T var2);

        public ArgumentType<T> createArgumentType(T var1, T var2);
    }
}

