/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.command.brigadier.argument.AbstractArgumentParser;

public final class SpongeChoicesValueParameter<T>
extends AbstractArgumentParser<T> {
    private final Supplier<? extends Collection<String>> choices;
    private final Function<String, ? extends T> results;
    private final boolean showInUsage;
    private final boolean forceLowercase;

    public SpongeChoicesValueParameter(Map<String, Supplier<? extends T>> choices, boolean showInUsage, boolean forceLowercase) {
        this(choices::keySet, x -> ((Supplier)choices.get(x)).get(), showInUsage, forceLowercase);
    }

    public SpongeChoicesValueParameter(Supplier<? extends Collection<String>> choices, Function<String, ? extends T> results, boolean showInUsage, boolean forceLowercase) {
        this.choices = choices;
        this.results = results;
        this.showInUsage = showInUsage;
        this.forceLowercase = forceLowercase;
    }

    @Override
    public List<CommandCompletion> complete(@NonNull CommandContext context, String currentInput) {
        return this.choices.get().stream().filter(x -> x.startsWith(currentInput)).map(x -> {
            if (x.contains(" ")) {
                return "\"" + x + "\"";
            }
            return x;
        }).map(SpongeCommandCompletion::new).collect(Collectors.toList());
    }

    @Override
    public @NonNull Optional<? extends T> parseValue(@NonNull Parameter.Key<? super T> parameterKey, @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        T result;
        String read = reader.parseString();
        String entry = this.forceLowercase ? read.toLowerCase(Locale.ROOT) : read;
        if (this.choices.get().contains(entry) && (result = this.results.apply(entry)) != null) {
            return Optional.of(result);
        }
        if (this.showInUsage) {
            throw reader.createException((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(entry + " is not a valid choice!").append((Component)Component.newline())).append((Component)Component.newline())).append((Component)Component.text((String)("Valid choices include: " + this.choices.get().stream().filter(x -> !x.equals(entry)).limit(5L).collect(Collectors.joining(", ")))))).build());
        }
        throw reader.createException((Component)Component.text((String)(entry + " is not a valid choice!")));
    }
}

