/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueCompleter;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.command.brigadier.argument.AbstractArgumentParser;
import org.spongepowered.common.util.Constants;

public final class SpongeLiteralValueParameter<T>
extends AbstractArgumentParser<T>
implements ValueCompleter {
    private final Supplier<? extends Collection<String>> literalSupplier;
    private final Supplier<T> returnValue;
    private final ArgumentType<?> type = Constants.Command.STANDARD_STRING_ARGUMENT_TYPE;

    public SpongeLiteralValueParameter(Supplier<? extends Collection<String>> literalSupplier, Supplier<T> returnValue) {
        this.literalSupplier = literalSupplier;
        this.returnValue = returnValue;
    }

    @Override
    public @NonNull Optional<? extends T> parseValue(@NonNull Parameter.Key<? super T> parameterKey, @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        Collection<String> collection = this.literalSupplier.get();
        Iterator<String> iterator = collection.iterator();
        String[] toCompare = reader.parseString().split(" ");
        int x = 0;
        while (iterator.hasNext() && x < toCompare.length) {
            if (iterator.next().equals(toCompare[x++])) continue;
            throw reader.createException((Component)Component.text((String)("The provided literal was not " + String.join((CharSequence)" ", collection))));
        }
        if (iterator.hasNext()) {
            throw reader.createException((Component)Component.text((String)("The provided literal was not " + String.join((CharSequence)" ", collection))));
        }
        return Optional.of(this.returnValue.get());
    }

    @Override
    public List<CommandCompletion> complete(@NonNull CommandContext context, @NonNull String input) {
        String literal = String.join((CharSequence)" ", (Iterable<? extends CharSequence>)this.literalSupplier.get());
        if (literal.startsWith(input)) {
            return Collections.singletonList(new SpongeCommandCompletion(literal));
        }
        return Collections.emptyList();
    }

    @Override
    public @NonNull String usage(@NonNull String key) {
        return String.join((CharSequence)" ", (Iterable<? extends CharSequence>)this.literalSupplier.get());
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return ImmutableList.of(this.type);
    }
}

