/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.blockray.RayTrace;
import org.spongepowered.api.util.blockray.RayTraceResult;
import org.spongepowered.common.command.brigadier.argument.ResourceKeyedZeroAdvanceValueParameter;

public final class SpongeTargetEntityValueParameter
extends ResourceKeyedZeroAdvanceValueParameter<Entity> {
    private final boolean isPlayerOnly;

    public SpongeTargetEntityValueParameter(ResourceKey key, boolean isPlayerOnly) {
        super(key);
        this.isPlayerOnly = isPlayerOnly;
    }

    @Override
    public @NonNull Optional<? extends Entity> parseValue(@NonNull CommandCause cause, @NonNull ArgumentReader.Mutable reader) throws ArgumentParseException {
        Object root = cause.cause().root();
        if (root instanceof Living) {
            Living living = (Living)root;
            Optional<RayTraceResult<@NonNull Entity>> rayTraceResult = RayTrace.entity().sourceEyePosition(living).direction(living.headDirection()).limit(30).continueWhileBlock(RayTrace.onlyAir()).select(this.isPlayerOnly ? entity -> entity instanceof Player : entity -> true).continueWhileEntity(r -> false).execute();
            if (rayTraceResult.isPresent()) {
                return rayTraceResult.map(RayTraceResult::selectedObject);
            }
            throw reader.createException((Component)Component.text((String)"The cause root is not looking at a entity!"));
        }
        throw reader.createException((Component)Component.text((String)"The cause root must be a Living!"));
    }
}

