/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.inheritable;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationVisitor;
import org.spongepowered.configurate.serialize.Scalars;

final class DuplicateRemovalVisitor
implements ConfigurationVisitor.Safe<AtomicReference<ConfigurationNode>, Void> {
    private static final DuplicateRemovalVisitor INSTANCE = new DuplicateRemovalVisitor();

    private DuplicateRemovalVisitor() {
    }

    public static void visit(ConfigurationNode child, ConfigurationNode parent) {
        child.visit(INSTANCE, new AtomicReference<ConfigurationNode>(parent));
    }

    @Override
    public AtomicReference<ConfigurationNode> newState() {
        throw new IllegalArgumentException("A parent configuration must be provided as the state object to properly remove duplicates");
    }

    private boolean isListElement(ConfigurationNode node) {
        return node.parent() != null && node.parent().isList();
    }

    @Override
    public void beginVisit(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        Objects.requireNonNull(Objects.requireNonNull(parent, "parentRef").get(), "A parent configuration must be provided!");
    }

    @Override
    public void enterNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        if (node.parent() != null) {
            parent.set(parent.get().node(node.key()));
        }
    }

    @Override
    public void enterMappingNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
    }

    @Override
    public void enterListNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        if (!this.isListElement(node) && Objects.equals(node.raw(), parent.get().raw())) {
            node.raw(null);
        }
    }

    @Override
    public void enterScalarNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        Double parentVal;
        ConfigurationNode parentNode = this.popParent(parent);
        if (this.isListElement(node)) {
            return;
        }
        if (Objects.equals(node.key(), "version") && node.parent().parent() == null) {
            return;
        }
        if (Objects.equals(node.raw(), parentNode.raw())) {
            node.raw(null);
            return;
        }
        Double nodeVal = Scalars.DOUBLE.tryDeserialize(node.raw());
        if (nodeVal != null && ((parentVal = Scalars.DOUBLE.tryDeserialize(parentNode.raw())) == null && nodeVal == 0.0 || parentVal != null && nodeVal.doubleValue() == parentVal.doubleValue())) {
            node.raw(null);
        }
    }

    @Override
    public void exitMappingNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        this.popParent(parent);
        if (node.empty() && !this.isListElement(node)) {
            node.raw(null);
        }
    }

    @Override
    public void exitListNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        ConfigurationNode parentNode = this.popParent(parent);
        if (parentNode.empty() && node.empty()) {
            node.raw(null);
        }
    }

    @Override
    public Void endVisit(AtomicReference<ConfigurationNode> parent) {
        return null;
    }

    private ConfigurationNode popParent(AtomicReference<ConfigurationNode> parentRef) {
        ConfigurationNode parent = parentRef.get();
        if (parent.parent() != null) {
            parentRef.set(parent.parent());
        }
        return parent;
    }
}

