/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import io.leangen.geantyref.GenericTypeReflector;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.SpongeKeyValueMatcher;
import org.spongepowered.common.util.Constants;

public final class SpongeKeyValueMatcherBuilder<V>
implements KeyValueMatcher.Builder<V> {
    private KeyValueMatcher.Operator operator = KeyValueMatcher.Operator.EQUAL;
    private @Nullable Key<? extends Value<V>> key;
    private @Nullable V value;

    @Override
    public <NV> KeyValueMatcher.Builder<NV> key(Key<? extends Value<NV>> key) {
        Objects.requireNonNull(key, "key");
        this.key = key;
        return this;
    }

    @Override
    public KeyValueMatcher.Builder<V> operator(KeyValueMatcher.Operator operator) {
        Objects.requireNonNull(operator, "operator");
        this.operator = operator;
        return this;
    }

    @Override
    public KeyValueMatcher.Builder<V> value(@Nullable V value) {
        this.value = value;
        return this;
    }

    @Override
    public KeyValueMatcher.Builder<V> value(@Nullable Value<? extends V> value) {
        this.value = value == null ? null : value.get();
        return this;
    }

    @Override
    public KeyValueMatcher.Builder<V> from(KeyValueMatcher<V> value) {
        this.key = value.key();
        this.value = value.value().orElse(null);
        this.operator = value.operator();
        return this;
    }

    @Override
    public KeyValueMatcher.Builder<V> reset() {
        this.key = null;
        this.operator = KeyValueMatcher.Operator.EQUAL;
        this.value = null;
        return this;
    }

    @Override
    public KeyValueMatcher<V> build() {
        Objects.requireNonNull(this.key, "The key must be set");
        return new SpongeKeyValueMatcher<V>(this.key, this.operator, this.value);
    }

    @Override
    public Optional<KeyValueMatcher<V>> build(DataView container) throws InvalidDataException {
        Objects.requireNonNull(container, "container");
        Optional optKey = container.getDataKey(Constants.KeyValueMatcher.KEY);
        if (!optKey.isPresent()) {
            return Optional.empty();
        }
        Key key = optKey.get();
        Optional<KeyValueMatcher.Operator> operator = container.getString(Constants.KeyValueMatcher.OPERATOR).map(s2 -> KeyValueMatcher.Operator.valueOf(s2.toUpperCase()));
        if (!operator.isPresent()) {
            return Optional.empty();
        }
        Optional<?> value = container.getObject(Constants.KeyValueMatcher.VALUE, GenericTypeReflector.erase(key.elementType()));
        if (!value.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new SpongeKeyValueMatcher<Object>(key, operator.get(), value.orElse(null)));
    }
}

