/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.item.SpongeItemStack;
import org.spongepowered.common.item.SpongeItemStackSnapshot;
import org.spongepowered.common.util.Constants;

public final class SpongeItemStackSnapshotDataBuilder
extends AbstractDataBuilder<ItemStackSnapshot>
implements DataBuilder<ItemStackSnapshot> {
    public SpongeItemStackSnapshotDataBuilder() {
        super(ItemStackSnapshot.class, 2);
    }

    @Override
    protected Optional<ItemStackSnapshot> buildContent(DataView container) throws InvalidDataException {
        if (container.contains(Constants.ItemStack.TYPE, Constants.ItemStack.COUNT)) {
            ImmutableList manipulators;
            CompoundNBT compound;
            ItemType itemType = container.getRegistryValue(Constants.ItemStack.TYPE, RegistryTypes.ITEM_TYPE, Sponge.game()).get();
            if (itemType == ItemTypes.AIR.get()) {
                return Optional.of(ItemStackSnapshot.empty());
            }
            int count = container.getInt(Constants.ItemStack.COUNT).get();
            if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
                compound = NBTTranslator.INSTANCE.translate(container.getView(Constants.Sponge.UNSAFE_NBT).get());
                SpongeItemStack.BuilderImpl.fixEnchantmentData(itemType, compound);
            } else {
                compound = null;
            }
            if (container.contains(Constants.Sponge.DATA_MANIPULATORS)) {
                List<DataView> views = container.getViewList(Constants.Sponge.DATA_MANIPULATORS).get();
                manipulators = ImmutableList.of();
            } else {
                manipulators = ImmutableList.of();
            }
            return Optional.of(new SpongeItemStackSnapshot(itemType, count, (ImmutableList<DataManipulator.Immutable>)manipulators, compound));
        }
        return Optional.empty();
    }
}

