/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.datasync.entity;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.datasync.DataParameterConverter;

public final class EntityCustomNameConverter
extends DataParameterConverter<Optional<ITextComponent>> {
    public EntityCustomNameConverter() {
        super(EntityAccessor.accessor$DATA_CUSTOM_NAME());
    }

    @Override
    public Optional<DataTransactionResult> createTransaction(Entity entity, Optional<ITextComponent> oldValue, Optional<ITextComponent> newValue) {
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        oldValue.ifPresent(v -> builder.replace(Value.immutableOf(Keys.CUSTOM_NAME, SpongeAdventure.asAdventure(v))));
        newValue.ifPresent(v -> builder.success(Value.immutableOf(Keys.CUSTOM_NAME, SpongeAdventure.asAdventure(v))));
        return Optional.of(builder.result(DataTransactionResult.Type.SUCCESS).build());
    }

    @Override
    public Optional<ITextComponent> getValueFromEvent(Optional<ITextComponent> oldValue, DataTransactionResult result) {
        Optional<Component> component = result.successfulValue(Keys.CUSTOM_NAME).map(Value::get);
        if (component.isPresent()) {
            try {
                return Optional.of(SpongeAdventure.asVanilla(component.get()));
            }
            catch (Exception e) {
                return oldValue;
            }
        }
        return Optional.empty();
    }
}

