/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.datasync.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.data.datasync.DataParameterConverter;

public final class EntityFlagsConverter
extends DataParameterConverter<Byte> {
    public static final int ON_FIRE_MASK = 1;
    public static final int CROUCHED_MASK = 2;
    public static final int UNUSED_MASK = 4;
    public static final int SPRINTING_MASK = 8;
    public static final int UNUSED_2_MASK = 16;
    public static final int INVISIBLE_MASK = 32;
    public static final int GLOWING_MASK = 64;
    public static final int FLYING_ELYTRA_MASK = 128;

    public EntityFlagsConverter() {
        super(EntityAccessor.accessor$DATA_SHARED_FLAGS_ID());
    }

    @Override
    public Optional<DataTransactionResult> createTransaction(Entity entity, Byte currentValue, Byte value) {
        boolean onFire = this.getFlag(currentValue, 1);
        boolean isSneaking = this.getFlag(currentValue, 2);
        boolean sprinting = this.getFlag(currentValue, 8);
        boolean invisible = this.getFlag(currentValue, 32);
        boolean glowing = this.getFlag(currentValue, 64);
        boolean elytra = this.getFlag(currentValue, 128);
        boolean newOnFire = this.getFlag(value, 1);
        boolean newIsSneaking = this.getFlag(value, 2);
        boolean newSprinting = this.getFlag(value, 8);
        boolean newInvisible = this.getFlag(value, 32);
        boolean newGlowing = this.getFlag(value, 64);
        boolean newElytra = this.getFlag(value, 128);
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        boolean changed = false;
        if (isSneaking != newIsSneaking) {
            builder.replace(Value.immutableOf(Keys.IS_SNEAKING, Boolean.valueOf(isSneaking)));
            builder.success(Value.immutableOf(Keys.IS_SNEAKING, Boolean.valueOf(newIsSneaking)));
            changed = true;
        }
        if (sprinting != newSprinting) {
            builder.replace(Value.immutableOf(Keys.IS_SPRINTING, Boolean.valueOf(sprinting)));
            builder.success(Value.immutableOf(Keys.IS_SPRINTING, Boolean.valueOf(newSprinting)));
            changed = true;
        }
        if (invisible != newInvisible) {
            builder.replace(Value.immutableOf(Keys.IS_INVISIBLE, Boolean.valueOf(invisible)));
            builder.success(Value.immutableOf(Keys.IS_INVISIBLE, Boolean.valueOf(newInvisible)));
            changed = true;
        }
        if (glowing != newGlowing) {
            builder.replace(Value.immutableOf(Keys.IS_GLOWING, Boolean.valueOf(glowing)));
            builder.success(Value.immutableOf(Keys.IS_GLOWING, Boolean.valueOf(newGlowing)));
            changed = true;
        }
        if (elytra != newElytra) {
            builder.replace(Value.immutableOf(Keys.IS_ELYTRA_FLYING, Boolean.valueOf(elytra)));
            builder.success(Value.immutableOf(Keys.IS_ELYTRA_FLYING, Boolean.valueOf(newElytra)));
            changed = true;
        }
        builder.result(DataTransactionResult.Type.SUCCESS);
        return changed ? Optional.of(builder.build()) : Optional.empty();
    }

    @Override
    public Byte getValueFromEvent(Byte originalValue, DataTransactionResult result) {
        if (result.successfulData().isEmpty()) {
            return originalValue;
        }
        boolean onFire = this.getFlag(originalValue, 1);
        boolean newIsSneaking = result.successfulValue(Keys.IS_SNEAKING).map(Value::get).orElseGet(() -> this.getFlag(originalValue, 2));
        boolean newSprinting = result.successfulValue(Keys.IS_SPRINTING).map(Value::get).orElseGet(() -> this.getFlag(originalValue, 8));
        boolean newInvisible = result.successfulValue(Keys.IS_INVISIBLE).map(Value::get).orElseGet(() -> this.getFlag(originalValue, 32));
        boolean newGlowing = result.successfulValue(Keys.IS_GLOWING).map(Value::get).orElseGet(() -> this.getFlag(originalValue, 64));
        boolean newElytra = result.successfulValue(Keys.IS_ELYTRA_FLYING).map(Value::get).orElseGet(() -> this.getFlag(originalValue, 128));
        byte newValue = (byte)(onFire ? 1 : 0);
        newValue = (byte)(newIsSneaking ? newValue | 2 : newValue & 0xFFFFFFFD);
        newValue = (byte)(newSprinting ? newValue | 8 : newValue & 0xFFFFFFF7);
        newValue = (byte)(newInvisible ? newValue | 0x20 : newValue & 0xFFFFFFDF);
        newValue = (byte)(newGlowing ? newValue | 0x40 : newValue & 0xFFFFFFBF);
        newValue = (byte)(newElytra ? newValue | 0x80 : newValue & 0xFFFFFF7F);
        return newValue;
    }

    private boolean getFlag(byte value, int mask) {
        return (value & mask) != 0;
    }
}

