/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.block.entity;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.spawner.AbstractSpawner;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.animal.Pig;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.util.weighted.WeightedSerializableObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.accessor.util.WeighedRandom_WeighedRandomItemAccessor;
import org.spongepowered.common.accessor.world.level.BaseSpawnerAccessor;
import org.spongepowered.common.accessor.world.level.block.entity.SpawnerBlockEntityAccessor;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.util.SpongeTicks;

public final class MobSpawnerData {
    private MobSpawnerData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(SpawnerBlockEntityAccessor.class).create(Keys.MAX_NEARBY_ENTITIES).get(h2 -> ((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$maxNearbyEntities())).set((h2, v) -> ((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$maxNearbyEntities((int)v))).create(Keys.MAX_SPAWN_DELAY).get(h2 -> new SpongeTicks(((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$maxSpawnDelay()))).set((h2, v) -> ((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$maxSpawnDelay((int)v.ticks()))).create(Keys.MIN_SPAWN_DELAY).get(h2 -> new SpongeTicks(((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$minSpawnDelay()))).set((h2, v) -> ((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$minSpawnDelay((int)v.ticks()))).create(Keys.NEXT_ENTITY_TO_SPAWN).get(h2 -> MobSpawnerData.getNextEntity((BaseSpawnerAccessor)h2.accessor$spawner()))).set((h2, v) -> MobSpawnerData.setNextEntity(h2.accessor$spawner(), v))).create(Keys.REMAINING_SPAWN_DELAY).get(h2 -> new SpongeTicks(((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$spawnDelay()))).set((h2, v) -> ((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$spawnDelay((int)v.ticks()))).create(Keys.REQUIRED_PLAYER_RANGE).get(h2 -> ((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$requiredPlayerRange())).set((h2, v) -> ((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$requiredPlayerRange(v.intValue()))).create(Keys.SPAWN_COUNT).get(h2 -> ((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$spawnCount())).set((h2, v) -> ((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$spawnCount((int)v))).create(Keys.SPAWN_RANGE).get(h2 -> ((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$spawnRange())).set((h2, v) -> ((BaseSpawnerAccessor)h2.accessor$spawner()).accessor$spawnRange(v.intValue()))).create(Keys.SPAWNABLE_ENTITIES).get(h2 -> MobSpawnerData.getEntities(h2.accessor$spawner()))).set((h2, v) -> {
            BaseSpawnerAccessor logic = (BaseSpawnerAccessor)h2.accessor$spawner();
            MobSpawnerData.setEntities(logic, v);
            MobSpawnerData.setNextEntity((AbstractSpawner)logic, MobSpawnerData.getNextEntity(logic));
        });
    }

    private static WeightedSerializableObject<EntityArchetype> getNextEntity(BaseSpawnerAccessor logic) {
        int weight = ((WeighedRandom_WeighedRandomItemAccessor)logic.accessor$nextSpawnData()).accessor$weight();
        String resourceLocation = logic.accessor$nextSpawnData().func_185277_b().func_74779_i("id");
        EntityType<Pig> type = Registry.field_212629_r.func_241873_b(new ResourceLocation(resourceLocation)).map(EntityType.class::cast).orElse(EntityTypes.PIG.get());
        CompoundNBT data = logic.accessor$nextSpawnData().func_185277_b();
        EntityArchetype archetype = SpongeEntityArchetypeBuilder.pooled().type(type).entityData(NBTTranslator.INSTANCE.translateFrom(data)).build();
        return new WeightedSerializableObject<EntityArchetype>(archetype, weight);
    }

    private static void setNextEntity(AbstractSpawner logic, WeightedSerializableObject<EntityArchetype> value) {
        CompoundNBT compound = NBTTranslator.INSTANCE.translate(((EntityArchetype)value.get()).entityData());
        if (!compound.func_74764_b("id")) {
            ResourceKey key = (ResourceKey)net.minecraft.entity.EntityType.func_200718_a((net.minecraft.entity.EntityType)((net.minecraft.entity.EntityType)((EntityArchetype)value.get()).type()));
            compound.func_74778_a("id", key.toString());
        }
        logic.func_184993_a(new WeightedSpawnerEntity((int)value.weight(), compound));
    }

    private static WeightedTable<EntityArchetype> getEntities(AbstractSpawner logic) {
        WeightedTable<EntityArchetype> possibleEntities = new WeightedTable<EntityArchetype>();
        for (WeightedSpawnerEntity weightedEntity : ((BaseSpawnerAccessor)logic).accessor$spawnPotentials()) {
            CompoundNBT nbt = weightedEntity.func_185277_b();
            String resourceLocation = nbt.func_74779_i("id");
            EntityType<Pig> type = Registry.field_212629_r.func_241873_b(new ResourceLocation(resourceLocation)).map(EntityType.class::cast).orElse(EntityTypes.PIG.get());
            EntityArchetype archetype = SpongeEntityArchetypeBuilder.pooled().type(type).entityData(NBTTranslator.INSTANCE.translateFrom(nbt)).build();
            possibleEntities.add((TableEntry<EntityArchetype>)new WeightedSerializableObject<EntityArchetype>(archetype, ((WeighedRandom_WeighedRandomItemAccessor)weightedEntity).accessor$weight()));
        }
        return possibleEntities;
    }

    private static void setEntities(BaseSpawnerAccessor logic, WeightedTable<EntityArchetype> table) {
        logic.accessor$spawnPotentials().clear();
        for (TableEntry<EntityArchetype> tableEntry : table) {
            if (!(tableEntry instanceof WeightedObject)) continue;
            WeightedObject object = (WeightedObject)tableEntry;
            CompoundNBT compound = NBTTranslator.INSTANCE.translate(((EntityArchetype)object.get()).entityData());
            if (!compound.func_74764_b("id")) {
                ResourceKey key = (ResourceKey)net.minecraft.entity.EntityType.func_200718_a((net.minecraft.entity.EntityType)((net.minecraft.entity.EntityType)((EntityArchetype)object.get()).type()));
                compound.func_74778_a("id", key.toString());
            }
            logic.accessor$spawnPotentials().add(new WeightedSpawnerEntity((int)tableEntry.weight(), compound));
        }
    }
}

