/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.BannerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerPattern;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.meta.BannerPatternLayer;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.BannerPatternShapes;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;

public final class ShieldItemStackData {
    private static final Map<String, BannerPatternShape> SHAPE_BY_HASHNAME = new HashMap<String, BannerPatternShape>();

    private ShieldItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.DYE_COLOR).get(h2 -> {
            CompoundNBT tag = h2.func_179543_a("BlockEntityTag");
            if (tag == null || tag.func_150297_b("Patterns", 9)) {
                return DyeColors.WHITE.get();
            }
            int id = tag.func_74762_e("Base");
            return (DyeColor)net.minecraft.item.DyeColor.func_196056_a((int)id);
        })).set((h2, v) -> {
            CompoundNBT tag = h2.func_190925_c("BlockEntityTag");
            tag.func_74768_a("Base", ((net.minecraft.item.DyeColor)v).func_196059_a());
        })).supports(h2 -> h2.func_77973_b() instanceof ShieldItem)).create(Keys.BANNER_PATTERN_LAYERS).get(h2 -> {
            CompoundNBT tag = h2.func_179543_a("BlockEntityTag");
            if (tag == null || !tag.func_150297_b("Patterns", 9)) {
                return new ArrayList();
            }
            ListNBT layersList = tag.func_150295_c("Patterns", 10);
            return layersList.stream().map(layer -> ShieldItemStackData.layerFromNbt((CompoundNBT)layer)).collect(Collectors.toList());
        })).set((h2, v) -> {
            ListNBT layersTag = v.stream().filter(layer -> layer.shape() != BannerPatternShapes.BASE.get()).map(ShieldItemStackData::layerToNbt).collect(NBTCollectors.toTagList());
            CompoundNBT blockEntity = h2.func_190925_c("BlockEntityTag");
            blockEntity.func_218657_a("Patterns", (INBT)layersTag);
            if (h2.func_77973_b() instanceof ShieldItem) {
                v.stream().filter(layer -> layer.shape() == BannerPatternShapes.BASE.get()).forEach(layer -> blockEntity.func_74768_a("Base", ((net.minecraft.item.DyeColor)layer.color()).func_196059_a()));
            }
        })).supports(h2 -> h2.func_77973_b() instanceof ShieldItem || h2.func_77973_b() instanceof BannerItem);
    }

    public static BannerPatternLayer layerFromNbt(CompoundNBT nbt) {
        BannerPatternShape shape = SHAPE_BY_HASHNAME.get(nbt.func_74779_i("Pattern"));
        net.minecraft.item.DyeColor dyeColor = net.minecraft.item.DyeColor.func_196056_a((int)nbt.func_74762_e("Color"));
        return BannerPatternLayer.of(shape, (DyeColor)dyeColor);
    }

    public static CompoundNBT layerToNbt(BannerPatternLayer layer) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Pattern", ((BannerPattern)layer.shape()).func_190993_b());
        nbt.func_74768_a("Color", ((net.minecraft.item.DyeColor)layer.color()).func_196059_a());
        return nbt;
    }

    static {
        for (BannerPattern pattern : BannerPattern.values()) {
            SHAPE_BY_HASHNAME.put(pattern.func_190993_b(), (BannerPatternShape)pattern);
        }
    }
}

