/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.util.SharedConstants;
import org.apache.commons.io.FileUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.common.datapack.DataPackSerializedObject;
import org.spongepowered.common.datapack.SpongeDataPackType;

public class DataPackSerializer<T extends DataPackSerializedObject> {
    protected final String name;
    protected final String typeDirectoryName;

    public DataPackSerializer(String token, String typeDirectoryName) {
        this.name = token;
        this.typeDirectoryName = typeDirectoryName;
    }

    protected boolean serialize(SpongeDataPackType<@NonNull ?, T> type, Path datapacksDir, List<T> objects, int count) throws IOException {
        Path datapackDir = datapacksDir.resolve(this.getPackName());
        if (!type.persistent()) {
            FileUtils.deleteDirectory((File)datapackDir.toFile());
        }
        if (count == 0) {
            return false;
        }
        for (DataPackSerializedObject object : objects) {
            Path namespacedDataDirectory = datapackDir.resolve("data").resolve(object.getKey().namespace());
            Path objectFile = namespacedDataDirectory.resolve(this.typeDirectoryName).resolve(object.getKey().value() + ".json");
            Files.createDirectories(objectFile.getParent(), new FileAttribute[0]);
            DataPackSerializer.writeFile(objectFile, object.getObject());
            this.serializeAdditional(namespacedDataDirectory, object);
        }
        DataPackSerializer.writePackMetadata(this.name, datapackDir);
        return true;
    }

    protected void serializeAdditional(Path dataDirectory, T object) throws IOException {
    }

    public static void writePackMetadata(String token, Path directory) throws IOException {
        Path packMeta = directory.resolve("pack.mcmeta");
        Files.deleteIfExists(packMeta);
        JsonObject packDataRoot = new JsonObject();
        JsonObject packData = new JsonObject();
        packDataRoot.add("pack", packData);
        packData.addProperty("pack_format", SharedConstants.func_215069_a().getPackVersion());
        packData.addProperty("description", "Sponge plugin provided " + token);
        DataPackSerializer.writeFile(packMeta, packDataRoot);
    }

    public static void writeFile(Path file, JsonElement object) throws IOException {
        Files.deleteIfExists(file);
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(file, new OpenOption[0]);){
            bufferedwriter.write(object.toString());
        }
    }

    public String getPackName() {
        return "plugin_" + this.typeDirectoryName;
    }
}

