/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.datapack.DataPackSerializable;
import org.spongepowered.api.datapack.DataPackType;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.datapack.DataPackSerializedObject;
import org.spongepowered.common.datapack.SpongeDataPackType;
import org.spongepowered.common.event.lifecycle.RegisterDataPackValueEventImpl;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;

public final class SpongeDataPackManager {
    public static SpongeDataPackManager INSTANCE = new SpongeDataPackManager(Sponge.game());
    private final Game game;
    private Map<DataPackType, Runnable> delayed = new HashMap<DataPackType, Runnable>();

    private SpongeDataPackManager(Game game) {
        this.game = game;
    }

    public void callRegisterDataPackValueEvents(Path dataPacksDirectory) {
        this.callRegisterDataPackValueEvents(dataPacksDirectory, new ArrayList<String>());
    }

    public void callRegisterDataPackValueEvents(Path dataPacksDirectory, Collection<String> dataPacksToLoad) {
        SpongeIngredient.clearCache();
        IngredientResultUtil.clearCache();
        this.serialize(DataPackTypes.ADVANCEMENT, dataPacksDirectory, dataPacksToLoad, this.callRegisterDataPackValueEvent(DataPackTypes.ADVANCEMENT), false);
        this.serialize(DataPackTypes.RECIPE, dataPacksDirectory, dataPacksToLoad, this.callRegisterDataPackValueEvent(DataPackTypes.RECIPE), false);
        this.serialize(DataPackTypes.WORLD_TYPE, dataPacksDirectory, dataPacksToLoad, this.callRegisterDataPackValueEvent(DataPackTypes.WORLD_TYPE), false);
        this.serialize(DataPackTypes.WORLD, dataPacksDirectory, dataPacksToLoad, this.callRegisterDataPackValueEvent(DataPackTypes.WORLD), true);
        this.serialize(DataPackTypes.TAG, dataPacksDirectory, dataPacksToLoad, this.callRegisterDataPackValueEvent(DataPackTypes.TAG), false);
    }

    private <T extends DataPackSerializable> List<T> callRegisterDataPackValueEvent(DataPackType<T> type) {
        RegisterDataPackValueEventImpl<T> event = new RegisterDataPackValueEventImpl<T>(Cause.of(EventContext.empty(), this.game), this.game, type);
        this.game.eventManager().post(event);
        return event.serializables();
    }

    public <T extends DataPackSerializable> void serializeDelayedDataPack(DataPackType<T> type) {
        Runnable runnable = this.delayed.get(type);
        if (runnable != null) {
            runnable.run();
        }
    }

    public <T extends DataPackSerializable> void serialize(DataPackType<T> type, Path dataPacksDirectory, Collection<String> dataPacksToLoad, List<T> serializables, boolean delayed) {
        if (serializables.isEmpty()) {
            return;
        }
        SpongeDataPackType implType = (SpongeDataPackType)type;
        ArrayList<DataPackSerializedObject> serialized = new ArrayList<DataPackSerializedObject>();
        if (delayed) {
            this.delayed.put(type, () -> this.serialize(type, dataPacksDirectory, new ArrayList<String>(), serializables, false));
        } else {
            for (DataPackSerializable serializable : serializables) {
                JsonObject o = (JsonObject)implType.getObjectSerializer().serialize(serializable);
                serialized.add((DataPackSerializedObject)implType.getObjectFunction().apply(serializable, o));
            }
        }
        this.serializePack(dataPacksDirectory, dataPacksToLoad, implType, serialized, serializables.size());
    }

    private void serializePack(Path dataPacksDirectory, Collection<String> dataPacksToLoad, SpongeDataPackType implType, List<DataPackSerializedObject> serialized, int count) {
        try {
            if (implType.getPackSerializer().serialize(implType, dataPacksDirectory, serialized, count)) {
                dataPacksToLoad.add("file/" + implType.getPackSerializer().getPackName());
            } else {
                dataPacksToLoad.remove("file/" + implType.getPackSerializer().getPackName());
            }
        }
        catch (IOException e) {
            dataPacksToLoad.remove("file/" + implType.getPackSerializer().getPackName());
            SpongeCommon.logger().error(e);
        }
    }
}

