/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.leangen.geantyref.TypeToken;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.gen.ChunkGenerator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.datapack.DataPackSerializable;
import org.spongepowered.api.datapack.DataPackType;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.world.WorldTypeTemplate;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.common.accessor.world.level.dimension.DimensionTypeAccessor;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.datapack.DataPackSerializableSerializer;
import org.spongepowered.common.datapack.DataPackSerializedObject;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.datapack.TagDataPackSerializer;
import org.spongepowered.common.datapack.recipe.RecipeDataPackSerializer;
import org.spongepowered.common.datapack.recipe.RecipeSerializedObject;
import org.spongepowered.common.datapack.tag.TagSerializedObject;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.tag.SpongeTagTemplate;
import org.spongepowered.common.world.server.SpongeWorldTemplate;
import org.spongepowered.common.world.server.SpongeWorldTypeTemplate;

public final class SpongeDataPackType<T extends DataPackSerializable, U extends DataPackSerializedObject>
implements DataPackType<T> {
    private final TypeToken<T> token;
    private final DataPackSerializer<U> packSerializer;
    private final DataPackSerializableSerializer<T> objectSerializer;
    private final BiFunction<T, JsonObject, U> objectFunction;
    private final boolean persistent;

    public SpongeDataPackType(TypeToken<T> token, DataPackSerializer<U> packSerializer, DataPackSerializableSerializer<T> objectSerializer, BiFunction<T, JsonObject, U> objectFunction, boolean persistent) {
        this.token = token;
        this.packSerializer = packSerializer;
        this.objectSerializer = objectSerializer;
        this.objectFunction = objectFunction;
        this.persistent = persistent;
    }

    @Override
    public TypeToken<T> type() {
        return this.token;
    }

    @Override
    public boolean persistent() {
        return this.persistent;
    }

    public DataPackSerializer<U> getPackSerializer() {
        return this.packSerializer;
    }

    public DataPackSerializableSerializer<T> getObjectSerializer() {
        return this.objectSerializer;
    }

    public BiFunction<T, JsonObject, U> getObjectFunction() {
        return this.objectFunction;
    }

    public static final class FactoryImpl
    implements DataPackType.Factory {
        private final SpongeDataPackType<@NonNull Advancement, DataPackSerializedObject> advancement = new SpongeDataPackType<Advancement, DataPackSerializedObject>(TypeToken.get(Advancement.class), new DataPackSerializer("Advancements", "advancements"), s2 -> ((net.minecraft.advancements.Advancement)s2).func_192075_a().func_200273_b(), (i1, i2) -> new DataPackSerializedObject(i1.key(), (JsonObject)i2), false);
        private final SpongeDataPackType<@NonNull RecipeRegistration, RecipeSerializedObject> recipe = new SpongeDataPackType<RecipeRegistration, RecipeSerializedObject>(TypeToken.get(RecipeRegistration.class), new RecipeDataPackSerializer(), s2 -> ((IFinishedRecipe)s2).func_200441_a(), (i1, i2) -> new RecipeSerializedObject(i1.key(), (JsonObject)i2, new DataPackSerializedObject(i1.key(), ((IFinishedRecipe)i1).func_200440_c())), false);
        private final SpongeDataPackType<@NonNull WorldTypeTemplate, DataPackSerializedObject> worldType = new SpongeDataPackType<WorldTypeTemplate, DataPackSerializedObject>(TypeToken.get(WorldTypeTemplate.class), new DataPackSerializer("Dimension Types", "dimension_type"), s2 -> {
            OptionalLong fixedTime = !s2.fixedTime().isPresent() ? OptionalLong.empty() : OptionalLong.of(s2.fixedTime().get().asTicks().ticks());
            DimensionType type = DimensionTypeAccessor.invoker$new(fixedTime, s2.hasSkylight(), s2.hasCeiling(), s2.scorching(), s2.natural(), s2.coordinateMultiplier(), s2.createDragonFight(), s2.piglinSafe(), s2.bedsUsable(), s2.respawnAnchorsUsable(), s2.hasRaids(), s2.logicalHeight(), (IBiomeMagnifier)s2.biomeSampler(), (ResourceLocation)((SpongeWorldTypeTemplate)s2).infiniburn, (ResourceLocation)s2.effect().key(), s2.ambientLighting());
            return (JsonElement)SpongeWorldTypeTemplate.DIRECT_CODEC.encodeStart((DynamicOps)WorldGenSettingsExport.func_240896_a_((DynamicOps)JsonOps.INSTANCE, (DynamicRegistries)BootstrapProperties.registries), (Object)type).getOrThrow(false, e -> {});
        }, (i1, i2) -> new DataPackSerializedObject(i1.key(), (JsonObject)i2), true);
        private final SpongeDataPackType<@NonNull WorldTemplate, DataPackSerializedObject> world = new SpongeDataPackType<WorldTemplate, DataPackSerializedObject>(TypeToken.get(WorldTemplate.class), new DataPackSerializer("Dimensions", "dimension"), s2 -> {
            Dimension template = new Dimension(() -> (DimensionType)BootstrapProperties.registries.func_230520_a_().func_82594_a((ResourceLocation)s2.worldType().location()), (ChunkGenerator)s2.generator());
            ((LevelStemBridge)template).bridge$setFromSettings(false);
            ((LevelStemBridge)template).bridge$populateFromTemplate((SpongeWorldTemplate)s2);
            return (JsonElement)SpongeWorldTemplate.DIRECT_CODEC.encodeStart((DynamicOps)WorldGenSettingsExport.func_240896_a_((DynamicOps)JsonOps.INSTANCE, (DynamicRegistries)BootstrapProperties.registries), (Object)template).getOrThrow(false, e -> {});
        }, (i1, i2) -> new DataPackSerializedObject(i1.key(), (JsonObject)i2), true);
        private final SpongeDataPackType<@NonNull SpongeTagTemplate, TagSerializedObject> tag = new SpongeDataPackType<SpongeTagTemplate, TagSerializedObject>(TypeToken.get(SpongeTagTemplate.class), new TagDataPackSerializer("Tag", "tags"), s2 -> {
            JsonObject jsonObject = s2.toJson();
            jsonObject.addProperty("replace", s2.replace());
            return jsonObject;
        }, (i1, i2) -> new TagSerializedObject(i1.key(), (JsonObject)i2, i1.tagType()), false);

        @Override
        public DataPackType<RecipeRegistration> recipe() {
            return this.recipe;
        }

        @Override
        public DataPackType<Advancement> advancement() {
            return this.advancement;
        }

        @Override
        public DataPackType<WorldTypeTemplate> worldType() {
            return this.worldType;
        }

        @Override
        public DataPackType<WorldTemplate> world() {
            return this.world;
        }

        public DataPackType tag() {
            return this.tag;
        }
    }
}

