/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.effect.particle.CachedParticlePacket;
import org.spongepowered.common.effect.particle.NumericalParticleType;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3f;

public final class SpongeParticleHelper {
    public static void sendPackets(ParticleEffect particleEffect, Vector3d position, int radius, RegistryKey<World> type, PlayerList playerList) {
        List<IPacket<?>> packets = SpongeParticleHelper.toPackets(particleEffect, position);
        if (!packets.isEmpty()) {
            double x = position.x();
            double y = position.y();
            double z = position.z();
            for (IPacket<?> packet : packets) {
                playerList.func_148543_a(null, x, y, z, (double)radius, type, packet);
            }
        }
    }

    public static List<IPacket<?>> toPackets(ParticleEffect effect, Vector3d position) {
        SpongeParticleEffect spongeEffect = (SpongeParticleEffect)effect;
        CachedParticlePacket cachedPacket = spongeEffect.cachedPacket;
        if (cachedPacket == null) {
            cachedPacket = spongeEffect.cachedPacket = SpongeParticleHelper.getCachedPacket(spongeEffect);
        }
        ArrayList packets = new ArrayList();
        cachedPacket.process(position, packets);
        return packets;
    }

    public static CachedParticlePacket getCachedPacket(SpongeParticleEffect effect) {
        org.spongepowered.api.effect.particle.ParticleType type = effect.type();
        if (type instanceof NumericalParticleType) {
            return SpongeParticleHelper.getNumericalPacket(effect, (NumericalParticleType)type);
        }
        return SpongeParticleHelper.getNamedPacket(effect, (ParticleType)type);
    }

    private static CachedParticlePacket getNumericalPacket(ParticleEffect effect, NumericalParticleType type) {
        int effectId = type.getId();
        return new NumericalCachedPacket(effectId, type.getData(effect), false);
    }

    private static CachedParticlePacket getNamedPacket(ParticleEffect effect, ParticleType<?> internalType) {
        Vector3f offset = effect.optionOrDefault(ParticleOptions.OFFSET).get().toFloat();
        int quantity = effect.optionOrDefault(ParticleOptions.QUANTITY).get();
        Vector3f velocity = effect.optionOrDefault(ParticleOptions.VELOCITY).orElse(Vector3d.ZERO).toFloat();
        if (internalType instanceof BasicParticleType) {
            return new NamedCachedPacket((IParticleData)internalType, offset, quantity, velocity);
        }
        if (internalType.func_197571_g() == BlockParticleData.field_197585_a) {
            BlockState state = effect.optionOrDefault(ParticleOptions.BLOCK_STATE).get();
            BlockParticleData particleData = new BlockParticleData(internalType, (net.minecraft.block.BlockState)state);
            return new NamedCachedPacket((IParticleData)particleData, offset, quantity, velocity);
        }
        if (internalType.func_197571_g() == ItemParticleData.field_197557_a) {
            ItemStackSnapshot snapshot = effect.optionOrDefault(ParticleOptions.ITEM_STACK_SNAPSHOT).get();
            ItemParticleData particleData = new ItemParticleData(internalType, (ItemStack)snapshot.createStack());
            return new NamedCachedPacket((IParticleData)particleData, offset, quantity, velocity);
        }
        if (internalType.func_197571_g() == RedstoneParticleData.field_197565_b) {
            Color color = effect.optionOrDefault(ParticleOptions.COLOR).get();
            double scale = effect.optionOrDefault(ParticleOptions.SCALE).get();
            RedstoneParticleData particleData = new RedstoneParticleData((float)color.red() / 255.0f, (float)color.green() / 255.0f, (float)color.blue() / 255.0f, (float)scale);
            return new NamedCachedPacket((IParticleData)particleData, offset, quantity, velocity);
        }
        return EmptyCachedPacket.INSTANCE;
    }

    public static int getDirectionId(Direction direction) {
        if (direction.isSecondaryOrdinal()) {
            direction = Direction.closest(direction.asOffset(), Direction.Division.ORDINAL);
        }
        switch (direction) {
            case SOUTHEAST: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case SOUTHWEST: {
                return 2;
            }
            case EAST: {
                return 3;
            }
            case WEST: {
                return 5;
            }
            case NORTHEAST: {
                return 6;
            }
            case NORTH: {
                return 7;
            }
            case NORTHWEST: {
                return 8;
            }
        }
        return 4;
    }

    public static int getBlockStateId(ParticleEffect effect, Optional<BlockState> defaultBlockState) {
        Optional<BlockState> blockState = effect.option(ParticleOptions.BLOCK_STATE);
        if (blockState.isPresent()) {
            return Block.func_196246_j((net.minecraft.block.BlockState)((net.minecraft.block.BlockState)blockState.get()));
        }
        Optional<ItemStackSnapshot> itemSnapshot = effect.option(ParticleOptions.ITEM_STACK_SNAPSHOT);
        if (itemSnapshot.isPresent()) {
            Optional<BlockType> blockType = itemSnapshot.get().type().block();
            return blockType.map(type -> Block.func_196246_j((net.minecraft.block.BlockState)((net.minecraft.block.BlockState)type.defaultState()))).orElse(0);
        }
        return defaultBlockState.map(state -> Block.func_196246_j((net.minecraft.block.BlockState)((net.minecraft.block.BlockState)state))).orElse(0);
    }

    private static final class NumericalCachedPacket
    implements CachedParticlePacket {
        private final int type;
        private final int data;
        private final boolean broadcast;

        public NumericalCachedPacket(int type, int data, boolean broadcast) {
            this.type = type;
            this.data = data;
            this.broadcast = broadcast;
        }

        @Override
        public void process(Vector3d position, List<IPacket<?>> output) {
            BlockPos blockPos = new BlockPos(position.floorX(), position.floorY(), position.floorZ());
            SPlaySoundEventPacket packet = new SPlaySoundEventPacket(this.type, blockPos, this.data, this.broadcast);
            output.add((IPacket<?>)packet);
        }
    }

    private static final class NamedCachedPacket
    implements CachedParticlePacket {
        private final IParticleData particleData;
        private final Vector3f offset;
        private final int quantity;
        private final Vector3f velocity;

        public NamedCachedPacket(IParticleData particleData, Vector3f offset, int quantity, Vector3f velocity) {
            this.particleData = particleData;
            this.offset = offset;
            this.quantity = quantity;
            this.velocity = velocity;
        }

        @Override
        public void process(Vector3d position, List<IPacket<?>> output) {
            float posX = (float)position.x();
            float posY = (float)position.y();
            float posZ = (float)position.z();
            float offX = this.offset.x();
            float offY = this.offset.y();
            float offZ = this.offset.z();
            if (this.velocity.equals((Object)Vector3f.ZERO)) {
                SSpawnParticlePacket packet = new SSpawnParticlePacket(this.particleData, true, (double)posX, (double)posY, (double)posZ, offX, offY, offZ, 0.0f, this.quantity);
                output.add((IPacket<?>)packet);
            } else {
                float velocityX = this.velocity.x();
                float velocityY = this.velocity.y();
                float velocityZ = this.velocity.z();
                Random random = new Random();
                for (int i = 0; i < this.quantity; ++i) {
                    float px0 = posX + (random.nextFloat() * 2.0f - 1.0f) * offX;
                    float py0 = posY + (random.nextFloat() * 2.0f - 1.0f) * offY;
                    float pz0 = posZ + (random.nextFloat() * 2.0f - 1.0f) * offZ;
                    SSpawnParticlePacket message = new SSpawnParticlePacket(this.particleData, true, (double)px0, (double)py0, (double)pz0, velocityX, velocityY, velocityZ, 1.0f, 0);
                    output.add((IPacket<?>)message);
                }
            }
        }
    }

    private static final class EmptyCachedPacket
    implements CachedParticlePacket {
        public static final EmptyCachedPacket INSTANCE = new EmptyCachedPacket();

        private EmptyCachedPacket() {
        }

        @Override
        public void process(Vector3d position, List<IPacket<?>> output) {
        }
    }
}

