/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.storage.IWorldInfo;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.server.level.ServerPlayerAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.PlatformServerLevelBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.math.vector.Vector3d;

public final class EntityUtil {
    public static final Function<PhaseContext<?>, Supplier<Optional<UUID>>> ENTITY_CREATOR_FUNCTION = context -> () -> Stream.builder().add(() -> context.getSource(ServerPlayerEntity.class).map(net.minecraft.entity.Entity::func_110124_au)).add(() -> context.getSource(User.class).map(Identifiable::uniqueId)).add(context::getNotifier).add(context::getCreator).build().map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();

    private EntityUtil() {
    }

    public static void despawnFilteredEntities(Iterable<? extends net.minecraft.entity.Entity> originalEntities, SpawnEntityEvent event) {
        if (event.isCancelled()) {
            for (net.minecraft.entity.Entity entity : originalEntities) {
                ((net.minecraft.world.server.ServerWorld)entity.field_70170_p).func_217467_h(entity);
            }
        } else {
            for (net.minecraft.entity.Entity entity : originalEntities) {
                if (event.entities().contains(entity)) continue;
                ((net.minecraft.world.server.ServerWorld)entity.field_70170_p).func_217467_h(entity);
            }
        }
    }

    public static void performPostChangePlayerWorldLogic(ServerPlayerEntity player, net.minecraft.world.server.ServerWorld fromWorld, net.minecraft.world.server.ServerWorld originalToWorld, net.minecraft.world.server.ServerWorld toWorld, boolean isPortal) {
        ((ServerPlayerBridge)player).bridge$sendDimensionData(player.field_71135_a.field_147371_a, toWorld.func_230315_m_(), (RegistryKey<World>)toWorld.func_234923_W_());
        IWorldInfo worldinfo = toWorld.func_72912_H();
        if (!isPortal) {
            ((ServerPlayerBridge)player).bridge$sendChangeDimension(toWorld.func_230315_m_(), (RegistryKey<World>)toWorld.func_234923_W_(), BiomeManager.func_235200_a_((long)toWorld.func_72905_C()), player.field_71134_c.func_73081_b(), player.field_71134_c.func_241815_c_(), toWorld.func_234925_Z_(), toWorld.func_241109_A_(), true);
        }
        player.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = player.func_184102_h().func_184103_al();
        playerlist.func_187243_f(player);
        ((PlatformServerLevelBridge)fromWorld).bridge$removeEntity((net.minecraft.entity.Entity)player, true);
        ((PlatformEntityBridge)player).bridge$revive();
        player.func_70029_a((World)toWorld);
        toWorld.func_217447_b(player);
        if (isPortal) {
            ((ServerPlayerAccessor)player).invoker$triggerDimensionChangeTriggers(toWorld);
        }
        player.field_71134_c.func_73080_a(toWorld);
        player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        playerlist.func_72354_b(player, toWorld);
        playerlist.func_72385_f(player);
        for (EffectInstance effectinstance : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), effectinstance));
        }
        if (isPortal) {
            player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        }
        ((ServerLevelBridge)fromWorld).bridge$getBossBarManager().func_201382_b(player);
        ((ServerLevelBridge)toWorld).bridge$getBossBarManager().func_201382_b(player);
        ((ServerPlayerAccessor)player).accessor$lastSentExp(-1);
        ((ServerPlayerAccessor)player).accessor$lastSentHealth(-1.0f);
        ((ServerPlayerAccessor)player).accessor$lastSentFood(-1);
        if (!isPortal) {
            player.field_71135_a.func_147364_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
            player.field_71135_a.func_184342_d();
        }
        if (player.field_71070_bA != player.field_71069_bz) {
            player.func_71053_j();
        }
        Sponge.eventManager().post(SpongeEventFactory.createChangeEntityWorldEventPost(PhaseTracker.getCauseStackManager().currentCause(), (Entity)player, (ServerWorld)fromWorld, (ServerWorld)originalToWorld, (ServerWorld)toWorld));
    }

    public static boolean processEntitySpawn(Entity entity, Supplier<Optional<UUID>> supplier, Consumer<net.minecraft.entity.Entity> spawner) {
        Optional<net.minecraft.entity.Entity> customEntityItem;
        ItemStack item;
        net.minecraft.entity.Entity minecraftEntity = (net.minecraft.entity.Entity)entity;
        if (minecraftEntity instanceof ItemEntity && !(item = ((ItemEntity)minecraftEntity).func_92059_d()).func_190926_b() && (customEntityItem = Optional.ofNullable(PlatformHooks.INSTANCE.getWorldHooks().getCustomEntityIfItem(minecraftEntity))).isPresent()) {
            net.minecraft.entity.Entity entityToSpawn = customEntityItem.get();
            supplier.get().ifPresent(spawned -> {
                if (entityToSpawn instanceof CreatorTrackedBridge) {
                    ((CreatorTrackedBridge)entityToSpawn).tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, (UUID)spawned);
                }
            });
            if (entityToSpawn.field_70128_L) {
                entityToSpawn.field_70128_L = false;
            }
            entityToSpawn.field_70170_p.func_217376_c(entityToSpawn);
            return true;
        }
        spawner.accept((net.minecraft.entity.Entity)entity);
        return true;
    }

    public static Collection<Entity> spawnEntities(Iterable<? extends Entity> entities, Predicate<Entity> selector, Consumer<net.minecraft.entity.Entity> spawning) {
        ArrayList<Entity> entitiesToSpawn = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (!selector.test(entity)) continue;
            entitiesToSpawn.add(entity);
        }
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(PhaseTracker.getCauseStackManager().currentCause(), entitiesToSpawn);
        if (Sponge.eventManager().post(event)) {
            return Collections.emptyList();
        }
        for (Entity entity : event.entities()) {
            EntityUtil.processEntitySpawn(entity, Optional::empty, spawning);
        }
        return Collections.unmodifiableCollection(new ArrayList<Entity>(event.entities()));
    }

    private static Vector3d createDropMotion(boolean dropAround, PlayerEntity player, Random random) {
        double y;
        double z;
        double x;
        if (dropAround) {
            float f = random.nextFloat() * 0.5f;
            float f1 = random.nextFloat() * ((float)Math.PI * 2);
            x = -MathHelper.func_76126_a((float)f1) * f;
            z = MathHelper.func_76134_b((float)f1) * f;
            y = 0.2f;
        } else {
            float f2 = 0.3f;
            x = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
            z = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
            y = -MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
            float f3 = random.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * random.nextFloat();
            x += Math.cos(f3) * (double)f2;
            y += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
            z += Math.sin(f3) * (double)f2;
        }
        return new Vector3d(x, y, z);
    }

    public static boolean isUntargetable(net.minecraft.entity.Entity from, net.minecraft.entity.Entity target) {
        if (((VanishableBridge)target).bridge$vanishState().untargetable()) {
            return true;
        }
        return from.field_70170_p != target.field_70170_p;
    }
}

