/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.data.DataContainerHolder;
import org.spongepowered.common.data.AbstractArchetype;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.ValidationTypes;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.util.Constants;
import org.spongepowered.math.vector.Vector3d;

public final class SpongeEntityArchetype
extends AbstractArchetype<EntityType, EntitySnapshot, org.spongepowered.api.entity.Entity>
implements EntityArchetype,
DataContainerHolder.Mutable {
    public static final ImmutableList<RawDataValidator> VALIDATORS = ImmutableList.of();
    private static final DataProviderLookup lookup = SpongeDataManager.getProviderRegistry().getProviderLookup(SpongeEntityArchetype.class);
    private @Nullable Vector3d position;

    SpongeEntityArchetype(SpongeEntityArchetypeBuilder builder) {
        this(builder.entityType, builder.compound);
        this.position = builder.position;
    }

    private SpongeEntityArchetype(EntityType<@NonNull ?> type, @Nullable CompoundNBT compound) {
        super(type, compound != null ? compound : new CompoundNBT());
    }

    @Override
    public EntityType<@NonNull ?> type() {
        return (EntityType)this.type;
    }

    public @Nullable CompoundNBT getData() {
        return this.compound;
    }

    @Override
    public DataProviderLookup getLookup() {
        return lookup;
    }

    public Optional<Vector3d> getPosition() {
        if (this.position != null) {
            return Optional.of(this.position);
        }
        if (!this.compound.func_150297_b("Pos", 9)) {
            return Optional.empty();
        }
        try {
            ListNBT pos = this.compound.func_150295_c("Pos", 6);
            double x = pos.func_150309_d(0);
            double y = pos.func_150309_d(1);
            double z = pos.func_150309_d(2);
            this.position = new Vector3d(x, y, z);
            return Optional.of(this.position);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public DataContainer data$getDataContainer() {
        return this.entityData();
    }

    @Override
    public void data$setDataContainer(DataContainer container) {
        this.compound = NBTTranslator.INSTANCE.translate(Objects.requireNonNull(container, "DataContainer cannot be null!"));
    }

    @Override
    public DataContainer entityData() {
        return NBTTranslator.INSTANCE.translateFrom(this.compound);
    }

    @Override
    public Optional<org.spongepowered.api.entity.Entity> apply(ServerLocation location) {
        boolean requiresInitialSpawn;
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return Optional.empty();
        }
        ServerWorld spongeWorld = (ServerWorld)location.world();
        net.minecraft.world.server.ServerWorld level = (net.minecraft.world.server.ServerWorld)spongeWorld;
        ResourceLocation key = net.minecraft.entity.EntityType.func_200718_a((net.minecraft.entity.EntityType)((net.minecraft.entity.EntityType)this.type));
        if (key == null) {
            return Optional.empty();
        }
        CompoundNBT compound = this.compound.func_74737_b();
        compound.func_74778_a("id", key.toString());
        ListNBT pos = new ListNBT();
        pos.add((Object)DoubleNBT.func_229684_a_((double)location.x()));
        pos.add((Object)DoubleNBT.func_229684_a_((double)location.y()));
        pos.add((Object)DoubleNBT.func_229684_a_((double)location.z()));
        compound.func_218657_a("Pos", (INBT)pos);
        compound.func_82580_o("UUID");
        if (compound.func_74764_b("RequireInitialSpawn")) {
            requiresInitialSpawn = compound.func_74767_n("RequireInitialSpawn");
            compound.func_82580_o("RequireInitialSpawn");
        } else {
            requiresInitialSpawn = true;
        }
        @Nullable Entity entity = net.minecraft.entity.EntityType.func_220335_a((CompoundNBT)compound, (World)level, e -> {
            e.func_225653_b_(location.x(), location.y(), location.z());
            if (requiresInitialSpawn && e instanceof MobEntity) {
                ((MobEntity)e).func_213386_a((IServerWorld)level, level.func_175649_E(e.func_233580_cy_()), SpawnReason.COMMAND, null, compound);
            }
            return e;
        });
        if (entity == null) {
            return Optional.empty();
        }
        if (level.func_242106_g(entity)) {
            return Optional.of((org.spongepowered.api.entity.Entity)entity);
        }
        return Optional.empty();
    }

    @Override
    public EntitySnapshot toSnapshot(ServerLocation location) {
        SpongeEntitySnapshotBuilder builder = new SpongeEntitySnapshotBuilder();
        builder.entityType = (EntityType)this.type;
        CompoundNBT newCompound = this.compound.func_74737_b();
        Vector3d pos = location.position();
        newCompound.func_218657_a("Pos", (INBT)Constants.NBT.newDoubleNBTList(pos.x(), pos.y(), pos.z()));
        newCompound.func_74778_a("WorldKey", location.worldKey().formatted());
        builder.compound = newCompound;
        builder.worldKey = ((ServerWorld)location.world()).properties().key();
        builder.position = pos;
        builder.rotation = this.getRotation();
        builder.scale = Vector3d.ONE;
        return builder.build();
    }

    private Vector3d getRotation() {
        ListNBT tag = this.compound.func_150295_c("Rotation", 5);
        float rotationYaw = tag.func_150308_e(0);
        float rotationPitch = tag.func_150308_e(1);
        return new Vector3d(rotationPitch, rotationYaw, 0.0f);
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED).set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Sponge.EntityArchetype.ENTITY_TYPE, this.type).set(Constants.Sponge.EntityArchetype.ENTITY_DATA, this.entityData());
    }

    @Override
    protected ValidationType getValidationType() {
        return ValidationTypes.ENTITY.get();
    }

    @Override
    public SpongeEntityArchetype copy() {
        return new SpongeEntityArchetype((EntityType)this.type, this.compound.func_74737_b());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeEntityArchetype that = (SpongeEntityArchetype)o;
        return Objects.equals(this.position, that.position);
    }

    @Override
    protected ImmutableList<RawDataValidator> getValidators() {
        return VALIDATORS;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.position);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("position", (Object)this.position).add("type", this.type).toString();
    }
}

