/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.data.nbt.validation.DelegateDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationTypes;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.entity.SpongeEntityArchetype;
import org.spongepowered.common.entity.living.human.HumanEntity;
import org.spongepowered.common.util.Constants;
import org.spongepowered.math.vector.Vector3d;

public class SpongeEntityArchetypeBuilder
extends AbstractDataBuilder<EntityArchetype>
implements EntityArchetype.Builder {
    private static final Deque<SpongeEntityArchetypeBuilder> pool = new ConcurrentLinkedDeque<SpongeEntityArchetypeBuilder>();
    @MonotonicNonNull EntityType<@NonNull ?> entityType = null;
    @Nullable CompoundNBT compound;
    @Nullable DataManipulator.Mutable manipulator;
    @Nullable Vector3d position;
    private final boolean pooled;

    public static SpongeEntityArchetypeBuilder unpooled() {
        return new SpongeEntityArchetypeBuilder(false);
    }

    public static SpongeEntityArchetypeBuilder pooled() {
        @Nullable SpongeEntityArchetypeBuilder builder = pool.pollFirst();
        if (builder != null) {
            return builder.reset();
        }
        return new SpongeEntityArchetypeBuilder(true);
    }

    private SpongeEntityArchetypeBuilder(boolean pooled) {
        super(EntityArchetype.class, 1);
        this.pooled = pooled;
    }

    @Override
    public SpongeEntityArchetypeBuilder reset() {
        this.entityType = null;
        this.manipulator = null;
        this.compound = null;
        this.position = null;
        return this;
    }

    @Override
    public EntityArchetype.Builder from(EntityArchetype value) {
        this.entityType = value.type();
        this.compound = NBTTranslator.INSTANCE.translate(value.entityData());
        SpongeEntityArchetypeBuilder.stripCompound(this.compound);
        this.manipulator = null;
        return this;
    }

    @Override
    protected Optional<EntityArchetype> buildContent(DataView container) throws InvalidDataException {
        SpongeEntityArchetypeBuilder builder = SpongeEntityArchetypeBuilder.pooled();
        if (!container.contains(Constants.Sponge.EntityArchetype.ENTITY_TYPE)) {
            throw new InvalidDataException("Missing the EntityType! Cannot re-construct an EntityArchetype!");
        }
        builder.type(container.getRegistryValue(Constants.Sponge.EntityArchetype.ENTITY_TYPE, RegistryTypes.ENTITY_TYPE, Sponge.game()).orElseThrow(() -> new InvalidDataException("Could not deserialize an EntityType!")));
        if (container.contains(Constants.Sponge.EntityArchetype.ENTITY_DATA)) {
            builder.entityData(container.getView(Constants.Sponge.EntityArchetype.ENTITY_DATA).orElseThrow(() -> new InvalidDataException("No DataView found for the 'EntityData' data tag!")));
        }
        return Optional.of(builder.build());
    }

    @Override
    public EntityArchetype.Builder type(EntityType<@NonNull ?> type) {
        if (this.entityType != Objects.requireNonNull(type, "EntityType cannot be null!")) {
            this.compound = null;
        }
        this.entityType = type;
        return this;
    }

    @Override
    public EntityArchetype.Builder from(org.spongepowered.api.entity.Entity entity) {
        EntityType<@NonNull ?> entityType = Objects.requireNonNull(Objects.requireNonNull(entity, "Cannot build an EntityArchetype for a null entity!").type(), "Entity is returning a null EntityType!");
        if (!((net.minecraft.entity.EntityType)entityType).func_200715_a() && entityType != HumanEntity.TYPE) {
            throw new IllegalArgumentException("Attempting to archetype a non-serializable entity: " + entity);
        }
        this.entityType = entityType;
        CompoundNBT compound = new CompoundNBT();
        Entity mcEntity = (Entity)entity;
        if (entityType == HumanEntity.TYPE) {
            mcEntity.func_189511_e(compound);
        } else {
            mcEntity.func_184198_c(compound);
        }
        this.position = new Vector3d(mcEntity.func_226277_ct_(), mcEntity.func_226278_cu_(), mcEntity.func_226281_cx_());
        SpongeEntityArchetypeBuilder.stripCompound(compound);
        compound.func_74757_a("RequireInitialSpawn", true);
        this.position = entity.position();
        this.compound = compound;
        return this;
    }

    @Override
    public EntityArchetype.Builder entityData(DataView view) {
        DataContainer container = Objects.requireNonNull(view, "Provided DataView cannot be null!").copy();
        new DelegateDataValidator(SpongeEntityArchetype.VALIDATORS, ValidationTypes.ENTITY.get()).validate(container);
        this.compound = NBTTranslator.INSTANCE.translate(container);
        SpongeEntityArchetypeBuilder.stripCompound(this.compound);
        return this;
    }

    @Override
    public <V> EntityArchetype.Builder add(Key<? extends Value<V>> key, V value) {
        if (this.manipulator == null) {
            this.manipulator = DataManipulator.mutableOf();
        }
        this.manipulator.set(Objects.requireNonNull(key, "Key cannot be null!"), Objects.requireNonNull(value, "Value cannot be null!"));
        return this;
    }

    @Override
    public EntityArchetype build() {
        Objects.requireNonNull(this.entityType, "Entity type cannot be nulL!");
        SpongeEntityArchetype archetype = new SpongeEntityArchetype(this);
        if (this.manipulator != null) {
            archetype.copyFrom(this.manipulator);
        }
        if (this.pooled) {
            this.reset();
            pool.push(this);
        }
        return archetype;
    }

    protected static void stripCompound(CompoundNBT compound) {
        compound.func_82580_o("UUID");
        compound.func_82580_o("UUIDMost");
        compound.func_82580_o("UUIDLeast");
        compound.func_82580_o("Pos");
    }
}

