/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.attribute;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.AttributeOperation;

public final class SpongeAttributeModifierBuilder
implements AttributeModifier.Builder {
    private UUID id = UUID.randomUUID();
    private String name;
    private AttributeOperation operation;
    private double amount;

    @Override
    public AttributeModifier.Builder id(UUID id) {
        this.id = (UUID)Preconditions.checkNotNull((Object)id, (Object)"Modifier id cannot be null");
        return this;
    }

    @Override
    public AttributeModifier.Builder name(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        return this;
    }

    @Override
    public AttributeModifier.Builder operation(AttributeOperation operation) {
        this.operation = (AttributeOperation)Preconditions.checkNotNull((Object)operation, (Object)"Operation cannot be null");
        return this;
    }

    @Override
    public AttributeModifier.Builder amount(double amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public org.spongepowered.api.entity.attribute.AttributeModifier build() {
        Preconditions.checkNotNull((Object)this.name, (Object)"Name must be set");
        Preconditions.checkNotNull((Object)this.operation, (Object)"Operation must be set");
        return (org.spongepowered.api.entity.attribute.AttributeModifier)new AttributeModifier(this.id, this.name, this.amount, (AttributeModifier.Operation)this.operation);
    }

    @Override
    public AttributeModifier.Builder reset() {
        this.id = UUID.randomUUID();
        this.name = null;
        this.amount = 0.0;
        this.operation = null;
        return this;
    }
}

