/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.effect;

import com.google.common.base.Objects;
import org.spongepowered.api.effect.VanishState;

public final class SpongeVanishState
implements VanishState {
    private static final VanishState VISIBLE = new SpongeVanishState(false, true, false, true, true, true);
    private static final VanishState DEFAULT_VANISHED = new SpongeVanishState(true, false, false, false, false, false);
    private final boolean vanished;
    private final boolean ignoresCollisions;
    private final boolean untargetable;
    private final boolean affectsSpawning;
    private final boolean createsSounds;
    private final boolean createsParticles;

    SpongeVanishState(boolean vanished, boolean collisions, boolean untargetable, boolean affectsSpawning, boolean createsSounds, boolean createsParticles) {
        this.vanished = vanished;
        if (!vanished) {
            this.ignoresCollisions = false;
            this.untargetable = false;
            this.affectsSpawning = true;
            this.createsSounds = true;
            this.createsParticles = true;
            return;
        }
        this.ignoresCollisions = collisions;
        this.untargetable = untargetable;
        this.affectsSpawning = affectsSpawning;
        this.createsSounds = createsSounds;
        this.createsParticles = createsParticles;
    }

    @Override
    public boolean invisible() {
        return this.vanished;
    }

    @Override
    public VanishState vanish() {
        if (this.vanished) {
            return this;
        }
        return DEFAULT_VANISHED;
    }

    @Override
    public VanishState unvanish() {
        return VISIBLE;
    }

    @Override
    public boolean ignoresCollisions() {
        return this.ignoresCollisions;
    }

    @Override
    public VanishState ignoreCollisions(boolean ignoresCollisions) {
        if (!this.vanished) {
            return this;
        }
        if (this.ignoresCollisions == ignoresCollisions) {
            return this;
        }
        return new SpongeVanishState(true, ignoresCollisions, this.untargetable, this.affectsSpawning, this.createsSounds, this.createsParticles);
    }

    @Override
    public boolean untargetable() {
        return this.untargetable;
    }

    @Override
    public VanishState untargetable(boolean untargetable) {
        if (!this.vanished) {
            return this;
        }
        if (this.untargetable == untargetable) {
            return this;
        }
        return new SpongeVanishState(true, this.ignoresCollisions, untargetable, this.affectsSpawning, this.createsSounds, this.createsParticles);
    }

    @Override
    public boolean affectsMonsterSpawning() {
        return false;
    }

    @Override
    public VanishState affectMonsterSpawning(boolean affectsMonsterSpawning) {
        if (!this.vanished) {
            return this;
        }
        if (this.affectsSpawning == affectsMonsterSpawning) {
            return this;
        }
        return new SpongeVanishState(true, this.ignoresCollisions, this.untargetable, affectsMonsterSpawning, this.createsSounds, this.createsParticles);
    }

    @Override
    public boolean createsSounds() {
        return this.createsSounds;
    }

    @Override
    public VanishState createSounds(boolean createSounds) {
        if (!this.vanished) {
            return this;
        }
        if (this.createsSounds == createSounds) {
            return this;
        }
        return new SpongeVanishState(true, this.ignoresCollisions, this.untargetable, this.affectsSpawning, createSounds, this.createsParticles);
    }

    @Override
    public boolean createsParticles() {
        return this.createsParticles;
    }

    @Override
    public VanishState createParticles(boolean createParticles) {
        if (!this.vanished) {
            return this;
        }
        if (this.createsParticles == createParticles) {
            return this;
        }
        return new SpongeVanishState(true, this.ignoresCollisions, this.untargetable, this.affectsSpawning, this.createsSounds, createParticles);
    }

    public String toString() {
        return "VanishedState{ignoresCollisions=" + this.ignoresCollisions + ", untargetable=" + this.untargetable + "}";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{true, this.ignoresCollisions, this.untargetable});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VanishState)) {
            return false;
        }
        VanishState other = (VanishState)obj;
        return this.invisible() == other.invisible() && this.ignoresCollisions == other.ignoresCollisions() && this.untargetable == other.untargetable();
    }

    public static final class SpongeVanishStateFactory
    implements VanishState.Factory {
        @Override
        public VanishState vanished() {
            return DEFAULT_VANISHED;
        }

        @Override
        public VanishState unvanished() {
            return VISIBLE;
        }
    }
}

