/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.effect.VanishState;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.entity.UserInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.RespawnLocation;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.bridge.authlib.GameProfileHolderBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.permissions.SubjectBridge;
import org.spongepowered.common.bridge.world.entity.player.BedLocationHolderBridge;
import org.spongepowered.common.data.DataUtil;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.entity.player.SpongeUserInventory;
import org.spongepowered.common.entity.player.SpongeUserInventoryEnderchest;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.service.server.permission.BridgeSubject;
import org.spongepowered.common.service.server.permission.SubjectHelper;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.FileUtil;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.math.vector.Vector3d;

public final class SpongeUserData
implements Identifiable,
DataSerializable,
BedLocationHolderBridge,
SpongeMutableDataHolder,
DataCompoundHolder,
VanishableBridge,
GameProfileHolderBridge,
User,
BridgeSubject {
    private final Map<ResourceKey, RespawnLocation> spawnLocations = Maps.newHashMap();
    private ResourceKey worldKey = (ResourceKey)World.field_234918_g_.func_240901_a_();
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private boolean invulnerable;
    private boolean isVanished;
    private boolean isInvisible;
    private VanishState vanishState;
    private boolean vanishIgnoresCollision;
    private boolean vanishPreventsTargeting;
    private final GameProfile profile;
    private @Nullable SpongeUserInventory inventory;
    private @Nullable EnderChestInventory enderChest;
    private CompoundNBT compound;
    private boolean isConstructing;

    public static SpongeUserData create(GameProfile profile) throws IOException {
        net.minecraft.world.server.ServerWorld world = SpongeCommon.server().func_241755_D_();
        if (world == null) {
            SpongeCommon.logger().warn("Overworld not initialized, cannot create users!");
            throw new IllegalStateException("Overworld not initialized, cannot create users!");
        }
        SaveFormat.LevelSave storageSource = ((MinecraftServerAccessor)((Object)Sponge.server())).accessor$storageSource();
        File file = storageSource.func_237285_a_(FolderName.field_237247_c_).resolve(profile.getId().toString() + ".dat").toFile();
        if (!file.exists()) {
            return new SpongeUserData(profile, new CompoundNBT());
        }
        try {
            CompoundNBT compound;
            try (FileInputStream in = new FileInputStream(file);){
                compound = CompressedStreamTools.func_74796_a((InputStream)in);
            }
            int version = compound.func_150297_b("DataVersion", 3) ? compound.func_74762_e("DataVersion") : -1;
            NBTUtil.func_210822_a((DataFixer)DataFixesManager.func_210901_a(), (DefaultTypeReferences)DefaultTypeReferences.PLAYER, (CompoundNBT)compound, (int)version);
            return new SpongeUserData(profile, compound);
        }
        catch (IOException e) {
            SpongeCommon.logger().warn("Unable to load corrupt user file '{}'!", (Object)file.toPath().relativize(Paths.get("", new String[0])).toString(), (Object)e);
            FileUtil.copyCorruptedFile(file);
            throw e;
        }
    }

    private SpongeUserData(GameProfile profile, CompoundNBT tag) {
        this.profile = profile;
        this.compound = tag;
        this.readCompound(this.compound);
        SubjectHelper.applySubject((SubjectBridge)((Object)this), "user");
    }

    public User asUser() {
        return ((SpongeServer)SpongeCommon.server()).userManager().asUser(this);
    }

    private void reset() {
        this.spawnLocations.clear();
    }

    @Override
    public List<DataHolder> impl$delegateDataHolder() {
        return Collections.singletonList(this.getDataHolder(true));
    }

    public DataHolder.Mutable getDataHolder(boolean markDirty) {
        if (this.isOnline()) {
            return this.player().get();
        }
        if (markDirty) {
            this.markDirty();
        }
        return this;
    }

    private UserInventory loadInventory() {
        if (this.inventory == null) {
            this.inventory = new SpongeUserInventory(this);
            ListNBT listNBT = this.compound.func_150295_c("Inventory", 10);
            this.inventory.readList(listNBT);
            this.inventory.currentItem = this.compound.func_74762_e("SelectedItemSlot");
        }
        return (UserInventory)((Object)this.inventory);
    }

    private SpongeUserData loadEnderInventory() {
        if (this.enderChest == null) {
            this.enderChest = new SpongeUserInventoryEnderchest(this);
            if (this.compound.func_150297_b("EnderItems", 9)) {
                ListNBT nbttaglist1 = this.compound.func_150295_c("EnderItems", 10);
                this.enderChest.func_70486_a(nbttaglist1);
            }
        }
        return this;
    }

    public void readCompound(CompoundNBT compound) {
        this.reset();
        this.compound = compound;
        if (!compound.func_74764_b("WorldKey")) {
            this.worldKey = ResourceKey.resolve(compound.func_74779_i("WorldKey"));
        }
        ListNBT position = compound.func_150295_c("Pos", 6);
        ListNBT rotation = compound.func_150295_c("Rotation", 5);
        this.x = position.func_150309_d(0);
        this.y = position.func_150309_d(1);
        this.z = position.func_150309_d(2);
        this.yaw = rotation.func_150308_e(0);
        this.pitch = rotation.func_150308_e(1);
        this.isConstructing = true;
        DataUtil.syncTagToData(this);
        this.isConstructing = false;
    }

    public void writeCompound(CompoundNBT compound) {
        compound.func_74778_a("WorldKey", this.worldKey.formatted());
        this.loadInventory();
        this.loadEnderInventory();
        compound.func_218657_a("Inventory", (INBT)this.inventory.writeList(new ListNBT()));
        compound.func_218657_a("EnderItems", (INBT)this.enderChest.func_70487_g());
        compound.func_74768_a("SelectedItemSlot", this.inventory.currentItem);
        compound.func_218657_a("Pos", (INBT)Constants.NBT.newDoubleNBTList(this.x, this.y, this.z));
        compound.func_218657_a("Rotation", (INBT)Constants.NBT.newFloatNBTList(this.yaw, this.pitch));
        if (DataUtil.syncDataToTag(this)) {
            compound.func_197643_a(this.data$getCompound());
        }
    }

    @Override
    public UUID uniqueId() {
        return this.profile.getId();
    }

    @Override
    public String name() {
        return this.profile.getName();
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Entity.Player.UUID, this.profile.getId()).set(Constants.Entity.Player.NAME, this.profile.getName()).set(Constants.Entity.Player.SPAWNS, this.spawnLocations);
    }

    @Override
    public boolean canEquip(EquipmentType type) {
        return true;
    }

    @Override
    public boolean canEquip(EquipmentType type, @Nullable ItemStack equipment) {
        return true;
    }

    @Override
    public Optional<ItemStack> equipped(EquipmentType type) {
        throw new MissingImplementationException("SpongeUser", "equipped");
    }

    @Override
    public boolean equip(EquipmentType type, @Nullable ItemStack equipment) {
        if (this.canEquip(type, equipment)) {
            this.loadInventory();
            this.setEquippedItem(type, equipment);
            return true;
        }
        return false;
    }

    public UserInventory inventory() {
        return this.loadInventory();
    }

    @Override
    public EquipmentInventory equipment() {
        return this.inventory().equipment();
    }

    @Override
    public ItemStack itemInHand(HandType handType) {
        if (handType == HandTypes.MAIN_HAND.get()) {
            this.equipped(EquipmentTypes.MAIN_HAND.get()).orElseThrow(IllegalStateException::new);
        } else if (handType == HandTypes.OFF_HAND.get()) {
            this.equipped(EquipmentTypes.OFF_HAND.get()).orElseThrow(IllegalStateException::new);
        }
        throw new IllegalArgumentException("Invalid hand " + handType);
    }

    @Override
    public ItemStack head() {
        return this.equipped(EquipmentTypes.HEAD.get()).orElseThrow(IllegalStateException::new);
    }

    @Override
    public void setHead(ItemStack helmet) {
        this.equip(EquipmentTypes.HEAD.get(), helmet);
    }

    @Override
    public ItemStack chest() {
        return this.equipped(EquipmentTypes.CHEST.get()).orElseThrow(IllegalStateException::new);
    }

    @Override
    public void setChest(ItemStack chestplate) {
        this.equip(EquipmentTypes.CHEST.get(), chestplate);
    }

    @Override
    public ItemStack legs() {
        return this.equipped(EquipmentTypes.LEGS.get()).orElseThrow(IllegalStateException::new);
    }

    @Override
    public void setLegs(ItemStack leggings) {
        this.equip(EquipmentTypes.LEGS.get(), leggings);
    }

    @Override
    public ItemStack feet() {
        return this.equipped(EquipmentTypes.FEET.get()).orElseThrow(IllegalStateException::new);
    }

    @Override
    public void setFeet(ItemStack boots) {
        this.equip(EquipmentTypes.FEET.get(), boots);
    }

    @Override
    public void setItemInHand(HandType handType, @Nullable ItemStack itemInHand) {
        if (handType == HandTypes.MAIN_HAND.get()) {
            this.setEquippedItem(EquipmentTypes.MAIN_HAND, itemInHand);
        } else if (handType == HandTypes.OFF_HAND.get()) {
            this.setEquippedItem(EquipmentTypes.OFF_HAND, itemInHand);
        } else {
            throw new IllegalArgumentException("Invalid hand " + handType);
        }
    }

    @Override
    public Map<ResourceKey, RespawnLocation> bridge$getBedlocations() {
        Optional<ServerPlayer> player = this.player();
        return player.map(value -> ((BedLocationHolderBridge)((Object)value)).bridge$getBedlocations()).orElse(this.spawnLocations);
    }

    @Override
    public boolean bridge$setBedLocations(Map<ResourceKey, RespawnLocation> value) {
        Optional<ServerPlayer> player = this.player();
        if (player.isPresent()) {
            return ((BedLocationHolderBridge)((Object)player.get())).bridge$setBedLocations(value);
        }
        this.spawnLocations.clear();
        this.spawnLocations.putAll(value);
        if (value.isEmpty()) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.RESPAWN_LOCATIONS);
        } else {
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.RESPAWN_LOCATIONS, value);
        }
        this.markDirty();
        return true;
    }

    @Override
    public ImmutableMap<ResourceKey, RespawnLocation> bridge$removeAllBeds() {
        Optional<ServerPlayer> player = this.player();
        if (player.isPresent()) {
            return ((BedLocationHolderBridge)((Object)player.get())).bridge$removeAllBeds();
        }
        ImmutableMap locations = ImmutableMap.copyOf(this.spawnLocations);
        this.spawnLocations.clear();
        ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.RESPAWN_LOCATIONS);
        this.markDirty();
        return locations;
    }

    public void markDirty() {
        if (this.isConstructing) {
            return;
        }
        ((SpongeServer)SpongeCommon.server()).userManager().markDirty(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        SpongeUserData spongeUserData = this;
        synchronized (spongeUserData) {
            SpongeUserManager userManager = ((SpongeServer)SpongeCommon.server()).userManager();
            SaveFormat.LevelSave storageSource = ((MinecraftServerAccessor)((Object)Sponge.server())).accessor$storageSource();
            File file = storageSource.func_237285_a_(FolderName.field_237247_c_).resolve(this.uniqueId() + ".dat").toFile();
            this.writeCompound(this.compound);
            try (FileOutputStream out = new FileOutputStream(file);){
                CompressedStreamTools.func_74799_a((CompoundNBT)this.compound, (OutputStream)out);
                userManager.unmarkDirty(this);
            }
            catch (IOException e) {
                SpongeCommon.logger().warn("Failed to save user file [{}]!", (Object)file, (Object)e);
                throw e;
            }
        }
    }

    private void setEquippedItem(Supplier<? extends EquipmentType> type, @Nullable ItemStack item) {
        this.setEquippedItem(type.get(), item);
    }

    private void setEquippedItem(EquipmentType type, @Nullable ItemStack item) {
        throw new MissingImplementationException("SpongeUser", "setEquippedItem");
    }

    @Override
    public org.spongepowered.api.profile.GameProfile profile() {
        return SpongeGameProfile.of(this.profile);
    }

    @Override
    public boolean isOnline() {
        return this.player().isPresent();
    }

    @Override
    public Optional<ServerPlayer> player() {
        return Optional.ofNullable((ServerPlayer)SpongeCommon.server().func_184103_al().func_177451_a(this.profile.getId()));
    }

    @Override
    public Vector3d position() {
        return this.player().map(Entity::position).orElseGet(() -> new Vector3d(this.x, this.y, this.z));
    }

    @Override
    public ResourceKey worldKey() {
        Optional<ServerPlayer> player = this.player();
        return player.map(serverPlayer -> serverPlayer.world().key()).orElseGet(() -> this.worldKey);
    }

    @Override
    public boolean setLocation(ResourceKey key, Vector3d position) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)position);
        Optional<ServerPlayer> player = this.player();
        if (player.isPresent()) {
            Optional<ServerWorld> world = Sponge.server().worldManager().world(key);
            return world.filter(serverWorld -> ((ServerPlayer)player.get()).setLocation(ServerLocation.of(serverWorld, position))).isPresent();
        }
        this.worldKey = key;
        this.x = position.x();
        this.y = position.y();
        this.z = position.z();
        this.markDirty();
        return true;
    }

    @Override
    public Vector3d rotation() {
        return this.player().map(Entity::rotation).orElseGet(() -> new Vector3d(this.pitch, this.yaw, 0.0f));
    }

    @Override
    public void setRotation(Vector3d rotation) {
        Preconditions.checkNotNull((Object)rotation, (Object)"Rotation was null!");
        Optional<ServerPlayer> playerOpt = this.player();
        if (playerOpt.isPresent()) {
            playerOpt.get().setRotation(rotation);
            return;
        }
        this.markDirty();
        this.pitch = (float)rotation.x() % 360.0f;
        this.yaw = (float)rotation.y() % 360.0f;
    }

    @Override
    public Inventory enderChestInventory() {
        Optional<ServerPlayer> playerOpt = this.player();
        if (playerOpt.isPresent()) {
            return playerOpt.get().enderChestInventory();
        }
        this.loadEnderInventory();
        return (Inventory)this.enderChest;
    }

    @Override
    public VanishState bridge$vanishState() {
        return this.vanishState;
    }

    @Override
    public void bridge$vanishState(VanishState state) {
        Optional<ServerPlayer> playerOpt = this.player();
        if (playerOpt.isPresent()) {
            ((VanishableBridge)((Object)playerOpt.get())).bridge$vanishState(state);
            return;
        }
        this.vanishState = state;
        this.markDirty();
        ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.VANISH_STATE, state);
    }

    @Override
    public boolean bridge$isInvisible() {
        return this.player().map(player -> ((VanishableBridge)((Object)player)).bridge$isInvisible()).orElseGet(() -> this.isInvisible);
    }

    @Override
    public void bridge$setInvisible(boolean invisible) {
        Optional<ServerPlayer> player = this.player();
        if (player.isPresent()) {
            ((VanishableBridge)((Object)player.get())).bridge$setInvisible(invisible);
            return;
        }
        this.isInvisible = invisible;
        if (invisible) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.IS_INVISIBLE, true);
        } else {
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.IS_INVISIBLE);
        }
    }

    @Override
    public CompoundNBT data$getCompound() {
        return this.compound;
    }

    @Override
    public void data$setCompound(CompoundNBT nbt) {
        this.compound = nbt;
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.PLAYER;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpongeUserData other = (SpongeUserData)obj;
        return this.profile.getId().equals(other.profile.getId());
    }

    public int hashCode() {
        return this.profile.getId().hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("isOnline", this.isOnline()).add("profile", (Object)this.profile()).toString();
    }

    @Override
    public GameProfile bridge$getGameProfile() {
        return this.profile;
    }

    public Boolean isInvulnerable() {
        return this.player().map(player -> ((net.minecraft.entity.Entity)player).func_190530_aW()).orElse(this.invulnerable);
    }

    public void setInvulnerable(boolean invulnerable) {
        Optional<ServerPlayer> playerOpt = this.player();
        if (playerOpt.isPresent()) {
            ((net.minecraft.entity.Entity)playerOpt.get()).func_184224_h(invulnerable);
            return;
        }
        this.invulnerable = invulnerable;
        this.markDirty();
    }

    @Override
    public String identifier() {
        return this.uniqueId().toString();
    }
}

