/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.ArmorEquipable;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Equipable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.equipment.EquipmentInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.util.Nameable;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.bridge.permissions.SubjectBridge;
import org.spongepowered.common.entity.player.SpongeUserData;
import org.spongepowered.common.service.server.permission.BridgeSubject;
import org.spongepowered.common.service.server.permission.SubjectHelper;
import org.spongepowered.math.vector.Vector3d;

public abstract class SpongeUserView
implements User,
BridgeSubject {
    protected final UUID uuid;

    public static User create(UUID uuid) {
        return new Standard(uuid);
    }

    public static User createLoginEventUser(ServerPlayer serverPlayer) {
        return new Login(serverPlayer);
    }

    protected SpongeUserView(UUID uuid) {
        this.uuid = uuid;
        SubjectHelper.applySubject((SubjectBridge)((Object)this), "user");
    }

    @Override
    public <E> DataTransactionResult offer(Key<? extends Value<E>> key, E value) {
        return this.dataHolderBackingObject().offer(key, value);
    }

    @Override
    public DataTransactionResult offer(Value<?> value) {
        return this.dataHolderBackingObject().offer(value);
    }

    @Override
    public <E> DataTransactionResult offerSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        return this.dataHolderBackingObject().offerSingle(key, element);
    }

    @Override
    public <K, V> DataTransactionResult offerSingle(Key<? extends MapValue<K, V>> key, K valueKey, V value) {
        return this.dataHolderBackingObject().offerSingle(key, valueKey, value);
    }

    @Override
    public <K, V> DataTransactionResult offerAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> map) {
        return this.dataHolderBackingObject().offerAll(key, map);
    }

    @Override
    public DataTransactionResult offerAll(MapValue<?, ?> value) {
        return this.dataHolderBackingObject().offerAll(value);
    }

    @Override
    public DataTransactionResult offerAll(CollectionValue<?, ?> value) {
        return this.dataHolderBackingObject().offerAll(value);
    }

    @Override
    public <E> DataTransactionResult offerAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        return this.dataHolderBackingObject().offerAll(key, elements);
    }

    @Override
    public <E> DataTransactionResult removeSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        return this.dataHolderBackingObject().removeSingle(key, element);
    }

    @Override
    public <K> DataTransactionResult removeKey(Key<? extends MapValue<K, ?>> key, K mapKey) {
        return this.dataHolderBackingObject().removeKey(key, mapKey);
    }

    @Override
    public DataTransactionResult removeAll(CollectionValue<?, ?> value) {
        return this.dataHolderBackingObject().removeAll(value);
    }

    @Override
    public <E> DataTransactionResult removeAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        return this.dataHolderBackingObject().removeAll(key, elements);
    }

    @Override
    public DataTransactionResult removeAll(MapValue<?, ?> value) {
        return this.dataHolderBackingObject().removeAll(value);
    }

    @Override
    public <K, V> DataTransactionResult removeAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> map) {
        return this.dataHolderBackingObject().removeAll(key, map);
    }

    @Override
    public <E> DataTransactionResult tryOffer(Key<? extends Value<E>> key, E value) {
        return this.dataHolderBackingObject().tryOffer(key, value);
    }

    @Override
    public DataTransactionResult remove(Key<?> key) {
        return this.dataHolderBackingObject().remove(key);
    }

    @Override
    public DataTransactionResult undo(DataTransactionResult result) {
        return this.dataHolderBackingObject().undo(result);
    }

    @Override
    public DataTransactionResult copyFrom(ValueContainer that, MergeFunction function) {
        return this.dataHolderBackingObject().copyFrom(that, function);
    }

    @Override
    public <E> Optional<E> get(Key<? extends Value<E>> key) {
        return this.dataHolderBackingObject().get(key);
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return this.dataHolderBackingObject().getValue(key);
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.dataHolderBackingObject().supports(key);
    }

    @Override
    public Set<Key<?>> getKeys() {
        return this.dataHolderBackingObject().getKeys();
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.dataHolderBackingObject().getValues();
    }

    @Override
    public GameProfile profile() {
        return this.backingObject(Player::profile, SpongeUserData::profile);
    }

    @Override
    public String name() {
        return this.backingObject(Nameable::name, SpongeUserData::name);
    }

    @Override
    public boolean isOnline() {
        return this.player().isPresent();
    }

    @Override
    public Optional<ServerPlayer> player() {
        return Sponge.server().player(this.uuid);
    }

    @Override
    public Vector3d position() {
        return this.backingObject(Entity::position, SpongeUserData::position);
    }

    @Override
    public ResourceKey worldKey() {
        return this.backingObject(player -> player.world().key(), SpongeUserData::worldKey);
    }

    @Override
    public boolean setLocation(ResourceKey world, Vector3d position) {
        return this.backingObject(player -> player.setLocation(ServerLocation.of(world, position)), user -> user.setLocation(world, position));
    }

    @Override
    public void setRotation(Vector3d rotation) {
        this.backingObjectConsumer(player -> player.setRotation(rotation), user -> user.setRotation(rotation));
    }

    @Override
    public Vector3d rotation() {
        return this.backingObject(Entity::rotation, SpongeUserData::rotation);
    }

    @Override
    public CarriedInventory<? extends Carrier> inventory() {
        return this.backingObject(Player::inventory, SpongeUserData::inventory);
    }

    @Override
    public Inventory enderChestInventory() {
        return this.backingObject(Player::enderChestInventory, SpongeUserData::enderChestInventory);
    }

    @Override
    public ItemStack head() {
        return this.backingObject(ArmorEquipable::head, SpongeUserData::head);
    }

    @Override
    public void setHead(ItemStack head) {
        this.backingObjectConsumer(player -> player.setHead(head), user -> user.setHead(head));
    }

    @Override
    public ItemStack chest() {
        return this.backingObject(ArmorEquipable::chest, SpongeUserData::chest);
    }

    @Override
    public void setChest(ItemStack chest) {
        this.backingObjectConsumer(player -> player.setChest(chest), user -> user.setChest(chest));
    }

    @Override
    public ItemStack legs() {
        return this.backingObject(ArmorEquipable::legs, SpongeUserData::legs);
    }

    @Override
    public void setLegs(ItemStack legs) {
        this.backingObjectConsumer(player -> player.setLegs(legs), user -> user.setLegs(legs));
    }

    @Override
    public ItemStack feet() {
        return this.backingObject(ArmorEquipable::feet, SpongeUserData::feet);
    }

    @Override
    public void setFeet(ItemStack feet) {
        this.backingObjectConsumer(player -> player.setFeet(feet), user -> user.setFeet(feet));
    }

    @Override
    public ItemStack itemInHand(HandType handType) {
        return this.backingObject(player -> player.itemInHand(handType), user -> user.itemInHand(handType));
    }

    @Override
    public void setItemInHand(HandType handType, ItemStack itemInHand) {
        this.backingObjectConsumer(player -> player.setItemInHand(handType, itemInHand), user -> user.setItemInHand(handType, itemInHand));
    }

    @Override
    public EquipmentInventory equipment() {
        return this.backingObject(Equipable::equipment, SpongeUserData::equipment);
    }

    @Override
    public boolean canEquip(EquipmentType type) {
        return this.backingObject(player -> player.canEquip(type), user -> user.canEquip(type));
    }

    @Override
    public boolean canEquip(EquipmentType type, ItemStack equipment) {
        return this.backingObject(player -> player.canEquip(type, equipment), user -> user.canEquip(type, equipment));
    }

    @Override
    public Optional<ItemStack> equipped(EquipmentType type) {
        return this.backingObject(player -> player.equipped(type), user -> user.equipped(type));
    }

    @Override
    public boolean equip(EquipmentType type, ItemStack equipment) {
        return this.backingObject(player -> player.equip(type, equipment), user -> user.equip(type, equipment));
    }

    @Override
    public String identifier() {
        return this.uuid.toString();
    }

    @Override
    public UUID uniqueId() {
        return this.uuid;
    }

    private void backingObjectConsumer(FunctionConsumer<? super ServerPlayer> playerFunc, FunctionConsumer<? super SpongeUserData> userFunc) {
        this.backingObject(playerFunc, userFunc);
    }

    protected abstract DataHolder.Mutable dataHolderBackingObject();

    private <T> T backingObject(Function<? super ServerPlayer, T> playerFunc, Function<? super SpongeUserData, T> userFunc) {
        DataHolder.Mutable mutable = this.dataHolderBackingObject();
        if (mutable instanceof ServerPlayer) {
            return playerFunc.apply((ServerPlayer)mutable);
        }
        return userFunc.apply((SpongeUserData)mutable);
    }

    static final class Login
    extends SpongeUserView {
        private final WeakReference<ServerPlayer> player;

        Login(ServerPlayer serverPlayer) {
            super(serverPlayer.uniqueId());
            this.player = new WeakReference<ServerPlayer>(serverPlayer);
        }

        @Override
        protected DataHolder.Mutable dataHolderBackingObject() {
            @Nullable ServerPlayer player = (ServerPlayer)this.player.get();
            if (player == null) {
                throw new IllegalStateException("The Player is no longer available, do not store this object!");
            }
            return player;
        }
    }

    static final class Standard
    extends SpongeUserView {
        Standard(UUID uuid) {
            super(uuid);
        }

        @Override
        protected DataHolder.Mutable dataHolderBackingObject() {
            @Nullable ServerPlayer serverPlayer = (ServerPlayer)SpongeCommon.server().func_184103_al().func_177451_a(this.uuid);
            if (serverPlayer != null) {
                return serverPlayer;
            }
            SpongeUserData user = ((SpongeServer)SpongeCommon.server()).userManager().userFromCache(this.uuid);
            if (user != null) {
                return user;
            }
            throw new IllegalStateException("Player is not online and user is not loaded - it must be loaded from the UserManager.");
        }
    }

    @FunctionalInterface
    static interface FunctionConsumer<T>
    extends Function<T, Void>,
    Consumer<T> {
        @Override
        default public Void apply(T t2) {
            this.accept(t2);
            return null;
        }
    }
}

