/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerListHeaderFooterPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundPlayerInfoPacketAccessor;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundTabListPacketAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.entity.player.tab.SpongeTabListEntry;
import org.spongepowered.common.profile.SpongeGameProfile;

public final class SpongeTabList
implements TabList {
    private static final ITextComponent EMPTY_COMPONENT = new StringTextComponent("");
    private final ServerPlayerEntity player;
    private @Nullable Component header;
    private @Nullable Component footer;
    private final Map<UUID, TabListEntry> entries = Maps.newHashMap();

    public SpongeTabList(ServerPlayerEntity player) {
        this.player = player;
    }

    @Override
    public ServerPlayer player() {
        return (ServerPlayer)this.player;
    }

    @Override
    public Optional<Component> header() {
        return Optional.ofNullable(this.header);
    }

    @Override
    public TabList setHeader(@Nullable Component header) {
        this.header = header;
        this.refreshClientHeaderFooter();
        return this;
    }

    @Override
    public Optional<Component> footer() {
        return Optional.ofNullable(this.footer);
    }

    @Override
    public TabList setFooter(@Nullable Component footer) {
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    @Override
    public TabList setHeaderAndFooter(@Nullable Component header, @Nullable Component footer) {
        this.header = header;
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    private void refreshClientHeaderFooter() {
        SPlayerListHeaderFooterPacket packet = new SPlayerListHeaderFooterPacket();
        ((ClientboundTabListPacketAccessor)packet).accessor$header(this.header == null ? EMPTY_COMPONENT : SpongeAdventure.asVanilla(this.header));
        ((ClientboundTabListPacketAccessor)packet).accessor$footer(this.footer == null ? EMPTY_COMPONENT : SpongeAdventure.asVanilla(this.footer));
        this.player.field_71135_a.func_147359_a((IPacket)packet);
    }

    @Override
    public Collection<TabListEntry> entries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    @Override
    public Optional<TabListEntry> entry(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "unique id");
        return Optional.ofNullable(this.entries.get(uniqueId));
    }

    @Override
    public TabList addEntry(TabListEntry entry) throws IllegalArgumentException {
        Objects.requireNonNull(entry, "builder");
        Preconditions.checkState((boolean)entry.list().equals(this), (Object)"the provided tab list entry was not created for this tab list");
        this.addEntry(entry, true);
        return this;
    }

    private void addEntry(SPlayerListItemPacket.AddPlayerData entry) {
        GameProfile profile = entry.func_179962_a();
        if (!this.entries.containsKey(profile.getId())) {
            ITextComponent displayName = entry.func_179961_d();
            this.addEntry(new SpongeTabListEntry(this, SpongeGameProfile.of(profile), displayName == null ? null : SpongeAdventure.asAdventure(displayName), entry.func_179963_b(), (GameMode)entry.func_179960_c()), false);
        }
    }

    private void addEntry(TabListEntry entry, boolean exceptionOnDuplicate) {
        UUID uniqueId = entry.profile().uniqueId();
        @Nullable TabListEntry prev = this.entries.putIfAbsent(uniqueId, entry);
        if (exceptionOnDuplicate && prev != null) {
            throw new IllegalArgumentException("cannot add duplicate entry");
        }
        if (prev == null) {
            this.sendUpdate(entry, SPlayerListItemPacket.Action.ADD_PLAYER);
        }
    }

    @Override
    public Optional<TabListEntry> removeEntry(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "unique id");
        TabListEntry entry = this.entries.remove(uniqueId);
        if (entry != null) {
            this.sendUpdate(entry, SPlayerListItemPacket.Action.REMOVE_PLAYER);
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    void sendUpdate(TabListEntry entry, SPlayerListItemPacket.Action action) {
        SPlayerListItemPacket packet = new SPlayerListItemPacket();
        ((ClientboundPlayerInfoPacketAccessor)packet).accessor$action(action);
        SPlayerListItemPacket sPlayerListItemPacket = packet;
        Objects.requireNonNull(sPlayerListItemPacket);
        SPlayerListItemPacket.AddPlayerData data = new SPlayerListItemPacket.AddPlayerData(sPlayerListItemPacket, SpongeGameProfile.toMcProfile(entry.profile()), entry.latency(), (GameType)entry.gameMode(), entry.displayName().isPresent() ? SpongeAdventure.asVanilla(entry.displayName().get()) : null);
        ((ClientboundPlayerInfoPacketAccessor)packet).accessor$entries().add(data);
        this.player.field_71135_a.func_147359_a((IPacket)packet);
    }

    public void updateEntriesOnSend(SPlayerListItemPacket packet) {
        for (SPlayerListItemPacket.AddPlayerData update : ((ClientboundPlayerInfoPacketAccessor)packet).accessor$entries()) {
            SPlayerListItemPacket.Action action = ((ClientboundPlayerInfoPacketAccessor)packet).accessor$action();
            if (action == SPlayerListItemPacket.Action.ADD_PLAYER) {
                this.addEntry(update);
                continue;
            }
            if (action == SPlayerListItemPacket.Action.REMOVE_PLAYER) {
                this.removeEntry(update.func_179962_a().getId());
                continue;
            }
            this.entry(update.func_179962_a().getId()).ifPresent(entry -> {
                if (action == SPlayerListItemPacket.Action.UPDATE_DISPLAY_NAME) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setDisplayName(update.func_179961_d() == null ? null : SpongeAdventure.asAdventure(update.func_179961_d()));
                } else if (action == SPlayerListItemPacket.Action.UPDATE_LATENCY) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setLatency(update.func_179963_b());
                } else if (action == SPlayerListItemPacket.Action.UPDATE_GAME_MODE) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setGameMode((GameMode)update.func_179960_c());
                } else {
                    throw new IllegalArgumentException("unknown packet action: " + action);
                }
            });
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("player", (Object)this.player).add("header", (Object)this.header).add("footer", (Object)this.footer).add("entries", this.entries).toString();
    }
}

