/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.block.entity.carrier.Dispenser;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.common.accessor.world.level.block.DispenserBlockAccessor;
import org.spongepowered.common.entity.projectile.ProjectileLogic;
import org.spongepowered.common.entity.projectile.ProjectileSourceLogic;

public final class DispenserSourceLogic
implements ProjectileSourceLogic<Dispenser> {
    DispenserSourceLogic() {
    }

    @Override
    public <P extends Projectile> Optional<P> launch(ProjectileLogic<P> logic, Dispenser source, EntityType<P> projectileType, Object ... args) {
        if (args.length == 1 && args[0] instanceof Item) {
            return this.launch((DispenserTileEntity)source, projectileType, (Item)args[0]);
        }
        Optional<P> projectile = logic.createProjectile(source, projectileType, source.location());
        if (projectile.isPresent()) {
            Direction enumfacing = DispenserSourceLogic.getFacing((DispenserTileEntity)source);
            Entity projectileEntity = (Entity)projectile.get();
            BlockPos adjustedPosition = projectileEntity.func_233580_cy_().func_177971_a(enumfacing.func_176730_m());
            projectileEntity.func_70107_b((double)adjustedPosition.func_177958_n(), (double)adjustedPosition.func_177956_o(), (double)adjustedPosition.func_177952_p());
        }
        return projectile;
    }

    public static Direction getFacing(DispenserTileEntity dispenser) {
        BlockState state = dispenser.func_145831_w().func_180495_p(dispenser.func_174877_v());
        return (Direction)state.func_177229_b((Property)DispenserBlock.field_176441_a);
    }

    private <P extends Projectile> Optional<P> launch(DispenserTileEntity dispenser, EntityType<P> projectileType, Item item) {
        IDispenseItemBehavior behavior = DispenserBlockAccessor.accessor$DISPENSER_REGISTRY().get(item);
        ServerWorld world = (ServerWorld)dispenser.func_145831_w();
        behavior.dispense((IBlockSource)new ProxyBlockSource(world, dispenser.func_174877_v()), new ItemStack((IItemProvider)item));
        List entities = world.func_217482_a((net.minecraft.entity.EntityType)projectileType, entity -> true);
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Projectile)entities.get(entities.size() - 1));
    }
}

