/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.minecraft.block.Block;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapIdTracker;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.Jukebox;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.InstrumentType;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.CreateMapEvent;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.CollideBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.event.entity.ai.SetAITargetEvent;
import org.spongepowered.api.event.entity.explosive.DetonateExplosiveEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.DefaultWorldKeys;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.map.MapIdTrackerBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.map.SpongeMapStorage;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3d;

public final class SpongeCommonEventFactory {
    public static <T extends net.minecraft.entity.Entity> CollideEntityEvent callCollideEntityEvent(@Nullable net.minecraft.entity.Entity sourceEntity, List<T> entities) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseContext<@NonNull ?> currentContext = phaseTracker.getPhaseContext();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            if (sourceEntity != null && currentContext.getSource() != sourceEntity) {
                frame.pushCause(sourceEntity);
            }
            currentContext.addCreatorAndNotifierToCauseStack(frame);
            List<Entity> spEntities = entities;
            CollideEntityEvent event = SpongeEventFactory.createCollideEntityEvent(PhaseTracker.getCauseStackManager().currentCause(), spEntities);
            SpongeCommon.post(event);
            CollideEntityEvent collideEntityEvent = event;
            return collideEntityEvent;
        }
    }

    public static boolean handlePistonEvent(TrackedWorldBridge world, BlockPos pos, net.minecraft.block.BlockState blockstate, int eventId) {
        boolean extending = eventId == 0;
        Direction direction = (Direction)blockstate.func_177229_b((Property)DirectionalBlock.field_176387_N);
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)((Object)world)).state((BlockState)blockstate).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).build();
        HashSet<ServerLocation> locations = new HashSet<ServerLocation>();
        locations.add(ServerLocation.of((ServerWorld)((Object)world), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        PistonBlockStructureHelper movedBlocks = new PistonBlockStructureHelper((net.minecraft.world.World)((net.minecraft.world.server.ServerWorld)world), pos, direction, extending);
        movedBlocks.func_177253_a();
        Stream.concat(movedBlocks.func_177254_c().stream(), movedBlocks.func_177252_d().stream()).map(block -> ServerLocation.of((ServerWorld)((Object)world), block.func_177958_n(), block.func_177956_o(), block.func_177952_p())).collect(Collectors.toCollection(() -> locations));
        if (extending && movedBlocks.func_177252_d().isEmpty()) {
            List movedPositions = movedBlocks.func_177254_c();
            BlockPos offsetPos = movedPositions.isEmpty() ? pos.func_177972_a(direction) : ((BlockPos)movedPositions.get(movedPositions.size() - 1)).func_177972_a(direction);
            locations.add(ServerLocation.of((ServerWorld)((Object)world), offsetPos.func_177958_n(), offsetPos.func_177956_o(), offsetPos.func_177952_p()));
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            if (extending) {
                frame.addContext(EventContextKeys.PISTON_EXTEND, (ServerWorld)((Object)world));
            } else {
                frame.addContext(EventContextKeys.PISTON_RETRACT, (ServerWorld)((Object)world));
            }
            boolean bl = SpongeCommonEventFactory.callChangeBlockEventPre((ServerLevelBridge)((Object)world), (ImmutableList<ServerLocation>)ImmutableList.copyOf(locations), (Object)locatable).isCancelled();
            return bl;
        }
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerLevelBridge worldIn, BlockPos pos) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<ServerLocation>)ImmutableList.of((Object)ServerLocation.of((ServerWorld)((Object)worldIn), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), null);
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerLevelBridge worldIn, BlockPos pos, Object source) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<ServerLocation>)ImmutableList.of((Object)ServerLocation.of((ServerWorld)((Object)worldIn), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), source);
    }

    private static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerLevelBridge worldIn, ImmutableList<ServerLocation> locations, @Nullable Object source) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            PhaseContext<@NonNull ?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
            if (source == null) {
                source = phaseContext.getSource() == null ? worldIn : phaseContext.getSource();
            }
            PlayerEntity player = null;
            frame.pushCause(source);
            if (source instanceof Player && ((PlatformEntityBridge)(player = (PlayerEntity)source)).bridge$isFakePlayer()) {
                frame.addContext(EventContextKeys.FAKE_PLAYER, (Player)player);
            }
            if (phaseContext.getCreator().isPresent()) {
                phaseContext.getCreator().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
            } else if (player instanceof ServerPlayer) {
                frame.addContext(EventContextKeys.CREATOR, ((ServerPlayer)player).uniqueId());
            }
            phaseContext.applyNotifierIfAvailable(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            ChangeBlockEvent.Pre event = SpongeEventFactory.createChangeBlockEventPre(frame.currentCause(), locations, (ServerWorld)((Object)worldIn));
            SpongeCommon.post(event);
            ChangeBlockEvent.Pre pre = event;
            return pre;
        }
    }

    public static InteractEntityEvent.Primary callInteractEntityEventPrimary(ServerPlayerEntity player, ItemStack stack, net.minecraft.entity.Entity entity, Hand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext((PlayerEntity)player, stack, hand, null, entity, frame);
            InteractEntityEvent.Primary event = SpongeEventFactory.createInteractEntityEventPrimary(frame.currentCause(), (Entity)entity);
            if (entity instanceof Player && !((ServerWorld)player.func_71121_q()).properties().pvp()) {
                event.setCancelled(true);
            }
            SpongeCommon.post(event);
            InteractEntityEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractEntityEvent.Secondary callInteractEntityEventSecondary(ServerPlayerEntity player, ItemStack stack, net.minecraft.entity.Entity entity, Hand hand, @Nullable Vector3d hitVec) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext((PlayerEntity)player, stack, hand, null, entity, frame);
            InteractEntityEvent.Secondary event = hitVec == null ? SpongeEventFactory.createInteractEntityEventSecondaryOn(frame.currentCause(), (Entity)entity) : SpongeEventFactory.createInteractEntityEventSecondaryAt(frame.currentCause(), (Entity)entity, hitVec);
            SpongeCommon.post(event);
            InteractEntityEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static InteractItemEvent.Primary callInteractItemEventPrimary(PlayerEntity player, ItemStack stack, Hand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, stack, hand, null, null, frame);
            InteractItemEvent.Primary event = SpongeEventFactory.createInteractItemEventPrimary(frame.currentCause(), ItemStackUtil.snapshotOf(stack));
            SpongeCommon.post(event);
            InteractItemEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractItemEvent.Secondary callInteractItemEventSecondary(PlayerEntity player, ItemStack stack, Hand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, stack, hand, null, null, frame);
            InteractItemEvent.Secondary event = SpongeEventFactory.createInteractItemEventSecondary(frame.currentCause(), ItemStackUtil.snapshotOf(stack));
            SpongeCommon.post(event);
            InteractItemEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static InteractBlockEvent.Primary callInteractBlockEventPrimary(CPlayerDiggingPacket.Action action, PlayerEntity player, ItemStack heldItem, BlockSnapshot blockSnapshot, Hand hand, @Nullable Direction side) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            InteractBlockEvent.Primary event;
            SpongeCommonEventFactory.applyCommonInteractContext(player, heldItem, hand, blockSnapshot, null, frame);
            org.spongepowered.api.util.Direction direction = side != null ? DirectionFacingProvider.INSTANCE.getKey(side).get() : org.spongepowered.api.util.Direction.NONE;
            switch (action) {
                case START_DESTROY_BLOCK: {
                    event = SpongeEventFactory.createInteractBlockEventPrimaryStart(frame.currentCause(), blockSnapshot, direction);
                    break;
                }
                case ABORT_DESTROY_BLOCK: {
                    event = SpongeEventFactory.createInteractBlockEventPrimaryStop(frame.currentCause(), blockSnapshot, direction);
                    break;
                }
                case STOP_DESTROY_BLOCK: {
                    event = SpongeEventFactory.createInteractBlockEventPrimaryFinish(frame.currentCause(), blockSnapshot, direction);
                    break;
                }
                default: {
                    throw new IllegalStateException("unreachable code");
                }
            }
            SpongeCommon.post(event);
            InteractBlockEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractBlockEvent.Secondary callInteractBlockEventSecondary(PlayerEntity player, ItemStack heldItem, Vector3d hitVec, BlockSnapshot targetBlock, org.spongepowered.api.util.Direction targetSide, Hand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, heldItem, hand, targetBlock, null, frame);
            InteractBlockEvent.Secondary event = SpongeEventFactory.createInteractBlockEventSecondary(frame.currentCause(), Tristate.UNDEFINED, Tristate.UNDEFINED, Tristate.UNDEFINED, Tristate.UNDEFINED, targetBlock, hitVec, targetSide);
            SpongeCommon.post(event);
            InteractBlockEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static void applyCommonInteractContext(PlayerEntity player, ItemStack stack, Hand hand, @Nullable BlockSnapshot targetBlock, @Nullable net.minecraft.entity.Entity entity, CauseStackManager.StackFrame frame) {
        if (((PlatformEntityBridge)player).bridge$isFakePlayer()) {
            frame.addContext(EventContextKeys.FAKE_PLAYER, (Player)player);
        } else {
            frame.pushCause(player);
            frame.addContext(EventContextKeys.CREATOR, player.func_110124_au());
            frame.addContext(EventContextKeys.NOTIFIER, player.func_110124_au());
        }
        if (!stack.func_190926_b()) {
            frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
        }
        frame.addContext(EventContextKeys.USED_HAND, (HandType)hand);
        if (targetBlock != null) {
            frame.addContext(EventContextKeys.BLOCK_HIT, targetBlock);
        }
        if (entity != null) {
            frame.addContext(EventContextKeys.ENTITY_HIT, (Entity)entity);
        }
    }

    public static void callNaturalMoveEntityEvent(net.minecraft.entity.Entity entity) {
        if (entity.field_70128_L) {
            return;
        }
        double deltaX = entity.field_70142_S - entity.func_226277_ct_();
        double deltaY = entity.field_70137_T - entity.func_226278_cu_();
        double deltaZ = entity.field_70136_U - entity.func_226281_cx_();
        double deltaChange = Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0) + Math.pow(deltaZ, 2.0);
        if (deltaChange < 0.00390625) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.NATURAL);
            MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(frame.currentCause(), (Entity)entity, new Vector3d(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U), new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()), new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()));
            if (SpongeCommon.post(event)) {
                entity.func_70107_b(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U);
            } else {
                entity.func_70107_b(event.destinationPosition().x(), event.destinationPosition().y(), event.destinationPosition().z());
            }
        }
    }

    public static void callNaturalRotateEntityEvent(net.minecraft.entity.Entity entity) {
        if (entity.field_70128_L || entity.field_70125_A == entity.field_70127_C && entity.field_70177_z == entity.field_70126_B) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            RotateEntityEvent event = SpongeEventFactory.createRotateEntityEvent(frame.currentCause(), (Entity)entity, new Vector3d(entity.field_70127_C, entity.field_70126_B, 0.0f), new Vector3d(entity.field_70125_A, entity.field_70177_z, 0.0f));
            if (SpongeCommon.post(event)) {
                entity.field_70125_A = entity.field_70127_C;
                entity.field_70177_z = entity.field_70126_B;
            } else {
                entity.field_70125_A = (float)event.toRotation().x();
                entity.field_70177_z = (float)event.toRotation().y();
            }
        }
    }

    public static DestructEntityEvent.Death callDestructEntityEventDeath(LivingEntity entity, @Nullable DamageSource source) {
        return SpongeCommonEventFactory.callDestructEntityEventDeath(entity, source, Audience.empty());
    }

    public static DestructEntityEvent.Death callDestructEntityEventDeath(LivingEntity entity, @Nullable DamageSource source, Audience originalChannel) {
        CreatorTrackedBridge creatorBridge;
        EntityDamageSource damageSource;
        Optional<UUID> sourceCreator = Optional.empty();
        boolean messageCancelled = false;
        if (source instanceof EntityDamageSource && (damageSource = (EntityDamageSource)source).func_76364_f() instanceof CreatorTrackedBridge && (creatorBridge = (CreatorTrackedBridge)damageSource.func_76364_f()) != null) {
            sourceCreator = creatorBridge.tracker$getCreatorUUID();
        }
        Component originalMessage = SpongeAdventure.asAdventure(entity.func_110142_aN().func_151521_b());
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            if (source != null) {
                frame.pushCause(source);
            }
            sourceCreator.ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            DestructEntityEvent.Death event = SpongeEventFactory.createDestructEntityEventDeath(frame.currentCause(), originalChannel, Optional.of(originalChannel), originalMessage, originalMessage, (Living)entity, entity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c), false);
            SpongeCommon.post(event);
            DestructEntityEvent.Death death = event;
            return death;
        }
    }

    public static boolean handleCollideBlockEvent(Block block, net.minecraft.world.World world, BlockPos pos, net.minecraft.block.BlockState state, net.minecraft.entity.Entity entity, org.spongepowered.api.util.Direction direction, CollisionType type) {
        if (world.func_201670_d() || pos.func_177956_o() <= 0) {
            return false;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            EntityBridge spongeEntity;
            CollideBlockEvent event;
            frame.pushCause(entity);
            if (entity instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge spongeEntity2 = (CreatorTrackedBridge)entity;
                spongeEntity2.tracker$getCreatorUUID().ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            }
            ServerLocation loc = ServerLocation.of((ServerWorld)world, VecHelper.toVector3d(pos));
            switch (type) {
                case MOVE: {
                    event = SpongeEventFactory.createCollideBlockEventMove(frame.currentCause(), (BlockState)state, loc, direction);
                    break;
                }
                case FALL: {
                    event = SpongeEventFactory.createCollideBlockEventFall(frame.currentCause(), (BlockState)state, loc, direction);
                    break;
                }
                case STEP_ON: {
                    event = SpongeEventFactory.createCollideBlockEventStepOn(frame.currentCause(), (BlockState)state, loc, direction);
                    break;
                }
                case INSIDE: {
                    event = SpongeEventFactory.createCollideBlockEventInside(frame.currentCause(), (BlockState)state, loc, direction);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
                }
            }
            boolean cancelled = SpongeCommon.post(event);
            if (!cancelled && !pos.equals((Object)(spongeEntity = (EntityBridge)entity).bridge$getLastCollidedBlockPos())) {
                PhaseContext<?> context = PhaseTracker.getInstance().getPhaseContext();
                context.applyNotifierIfAvailable(notifier -> {
                    LevelChunkBridge spongeChunk = ((ActiveChunkReferantBridge)entity).bridge$getActiveChunk();
                    if (spongeChunk == null) {
                        spongeChunk = (LevelChunkBridge)world.func_175726_f(pos);
                    }
                    spongeChunk.bridge$addTrackedBlockPosition(block, pos, (UUID)notifier, PlayerTracker.Type.NOTIFIER);
                });
            }
            boolean bl = cancelled;
            return bl;
        }
    }

    public static boolean handleCollideImpactEvent(net.minecraft.entity.Entity projectile, @Nullable ProjectileSource projectileSource, RayTraceResult movingObjectPosition) {
        RayTraceResult.Type movingObjectType = movingObjectPosition.func_216346_c();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(projectile);
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, projectileSource == null ? UnknownProjectileSource.UNKNOWN : projectileSource);
            Optional<UUID> creator = PhaseTracker.getInstance().getPhaseContext().getCreator();
            creator.ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            ServerLocation impactPoint = ServerLocation.of((ServerWorld)projectile.field_70170_p, VecHelper.toVector3d(movingObjectPosition.func_216347_e()));
            boolean cancelled = false;
            if (movingObjectType == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockMovingObjectPosition = (BlockRayTraceResult)movingObjectPosition;
                BlockPos blockPos = blockMovingObjectPosition.func_216350_a();
                if (blockPos.func_177956_o() <= 0) {
                    boolean bl = false;
                    return bl;
                }
                BlockSnapshot targetBlock = ((ServerWorld)projectile.field_70170_p).createSnapshot(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
                org.spongepowered.api.util.Direction side = DirectionFacingProvider.INSTANCE.getKey(blockMovingObjectPosition.func_216354_b()).get();
                CollideBlockEvent.Impact event = SpongeEventFactory.createCollideBlockEventImpact(frame.currentCause(), impactPoint, targetBlock.state(), targetBlock.location().get(), side);
                cancelled = SpongeCommon.post(event);
                if (!cancelled && creator.isPresent()) {
                    BlockPos targetPos = VecHelper.toBlockPos(impactPoint.blockPosition());
                    LevelChunkBridge spongeChunk = (LevelChunkBridge)projectile.field_70170_p.func_175726_f(targetPos);
                    spongeChunk.bridge$addTrackedBlockPosition((Block)targetBlock.state().type(), targetPos, creator.get(), PlayerTracker.Type.NOTIFIER);
                }
            } else if (movingObjectType == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult entityMovingObjectPosition = (EntityRayTraceResult)movingObjectPosition;
                ArrayList<Entity> entityList = new ArrayList<Entity>();
                entityList.add((Entity)entityMovingObjectPosition.func_216348_a());
                CollideEntityEvent.Impact event = SpongeEventFactory.createCollideEntityEventImpact(frame.currentCause(), entityList, impactPoint);
                cancelled = SpongeCommon.post(event);
            }
            boolean bl = cancelled;
            return bl;
        }
    }

    public static SetAITargetEvent callSetAttackTargetEvent(@Nullable Entity target, Agent agent) {
        SetAITargetEvent event = SpongeEventFactory.createSetAITargetEvent(PhaseTracker.getCauseStackManager().currentCause(), agent, Optional.ofNullable(target));
        SpongeCommon.post(event);
        return event;
    }

    public static Optional<Explosion> detonateExplosive(ExplosiveBridge explosiveBridge, Explosion.Builder builder) {
        DetonateExplosiveEvent event = SpongeEventFactory.createDetonateExplosiveEvent(PhaseTracker.getCauseStackManager().currentCause(), builder, (Explosive)((Object)explosiveBridge), builder.build());
        if (!Sponge.eventManager().post(event)) {
            org.spongepowered.api.world.explosion.Explosion explosion = event.explosionBuilder().build();
            if (explosion.radius() > 0.0f) {
                ((TrackedWorldBridge)((Object)((Explosive)((Object)explosiveBridge)).world())).tracker$triggerInternalExplosion(explosion, e -> GeneralPhase.State.EXPLOSION.createPhaseContext(PhaseTracker.SERVER).explosion((Explosion)e));
            }
            return Optional.of((Explosion)explosion);
        }
        return Optional.empty();
    }

    public static @Nullable ItemStack throwDropItemAndConstructEvent(net.minecraft.entity.Entity entity, double posX, double posY, double posZ, ItemStackSnapshot snapshot, List<ItemStackSnapshot> original, CauseStackManager.StackFrame frame) {
        ItemStack item;
        frame.pushCause(entity);
        DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(frame.currentCause(), (List<ItemStackSnapshot>)ImmutableList.of((Object)snapshot), original);
        SpongeCommon.post(dropEvent);
        if (dropEvent.isCancelled()) {
            return null;
        }
        if (dropEvent.droppedItems().isEmpty()) {
            return null;
        }
        frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.currentCause(), ServerLocation.of((ServerWorld)entity.field_70170_p, posX, posY, posZ), new Vector3d(0.0f, 0.0f, 0.0f), EntityTypes.ITEM.get());
        frame.removeContext(EventContextKeys.SPAWN_TYPE);
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            return null;
        }
        ItemStack itemStack = item = event.isCancelled() ? null : ItemStackUtil.fromSnapshotToNative(dropEvent.droppedItems().get(0));
        if (item == null) {
            return null;
        }
        return item;
    }

    public static @Nullable PlaySoundEvent.Broadcast callPlaySoundBroadcastEvent(CauseStackManager.StackFrame frame, LevelBridge bridge, BlockPos pos, int effectID) {
        float volume;
        DefaultedRegistryReference<SoundType> soundType;
        if (effectID == 1023) {
            soundType = SoundTypes.ENTITY_WITHER_SPAWN;
            volume = 1.0f;
        } else if (effectID == 1028) {
            soundType = SoundTypes.ENTITY_ENDER_DRAGON_DEATH;
            volume = 5.0f;
        } else if (effectID == 1038) {
            soundType = SoundTypes.BLOCK_END_PORTAL_SPAWN;
            volume = 1.0f;
        } else {
            return null;
        }
        ServerLocation location = ServerLocation.of((ServerWorld)((Object)bridge), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        PlaySoundEvent.Broadcast event = SpongeEventFactory.createPlaySoundEventBroadcast(frame.currentCause(), location, Sound.Source.HOSTILE, (SoundType)soundType.get(), 1.0f, volume);
        SpongeCommon.post(event);
        return event;
    }

    public static PlaySoundEvent.Record callPlaySoundRecordEvent(Cause cause, JukeboxTileEntity jukebox, MusicDisc recordType, int data) {
        Jukebox apiJuke = (Jukebox)jukebox;
        ServerLocation location = (ServerLocation)apiJuke.location();
        PlaySoundEvent.Record event = data == 0 ? SpongeEventFactory.createPlaySoundEventRecordStart(cause, apiJuke, location, recordType, Sound.Source.RECORD, recordType.sound(), 1.0f, 4.0f) : SpongeEventFactory.createPlaySoundEventRecordStop(cause, apiJuke, location, recordType, Sound.Source.RECORD, recordType.sound(), 1.0f, 4.0f);
        SpongeCommon.post(event);
        return event;
    }

    public static PlaySoundEvent.AtEntity callPlaySoundAtEntityEvent(Cause cause, @Nullable PlayerEntity entity, LevelBridge worldMixin, double x, double y, double z, SoundCategory category, SoundEvent name, float pitch, float volume) {
        ServerLocation location = ServerLocation.of((ServerWorld)((Object)worldMixin), x, y, z);
        PlaySoundEvent.AtEntity event = SpongeEventFactory.createPlaySoundEventAtEntity(cause, location, Optional.ofNullable((ServerPlayer)entity), SpongeAdventure.asAdventure(category), (SoundType)name, pitch, volume);
        SpongeCommon.post(event);
        return event;
    }

    public static PlaySoundEvent.NoteBlock callPlaySoundNoteBlockEvent(Cause cause, World world, BlockPos pos, SoundEvent soundEvent, InstrumentType instrument, NotePitch notePitch, Float pitch) {
        ServerLocation location = ServerLocation.of((ServerWorld)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        PlaySoundEvent.NoteBlock event = SpongeEventFactory.createPlaySoundEventNoteBlock(cause, instrument, location, notePitch, Sound.Source.RECORD, (SoundType)soundEvent, pitch.floatValue(), 3.0f);
        SpongeCommon.post(event);
        return event;
    }

    public static Optional<MapInfo> fireCreateMapEvent(Cause cause) {
        return SpongeCommonEventFactory.fireCreateMapEvent(cause, Collections.emptySet());
    }

    public static Optional<MapInfo> fireCreateMapEvent(Cause cause, Set<Value<?>> values) {
        net.minecraft.world.server.ServerWorld defaultWorld = (net.minecraft.world.server.ServerWorld)Sponge.server().worldManager().world(DefaultWorldKeys.DEFAULT).get();
        MapIdTrackerBridge mapIdTrackerBridge = (MapIdTrackerBridge)defaultWorld.func_217481_x().func_215752_a(MapIdTracker::new, "idcounts");
        int id = mapIdTrackerBridge.bridge$getHighestMapId().orElse(-1) + 1;
        String s2 = "map_" + id;
        MapData mapData = new MapData(s2);
        mapData.field_76200_c = net.minecraft.world.World.field_234918_g_;
        MapInfo mapInfo = (MapInfo)mapData;
        for (Value<?> value : values) {
            mapInfo.offer(value);
        }
        CreateMapEvent event = SpongeEventFactory.createCreateMapEvent(cause, mapInfo);
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        int mcId = defaultWorld.func_217395_y();
        if (id != mcId) {
            SpongeCommon.logger().warn("Map size corruption, vanilla only allows 2147483647! Expected next number was not equal to the true next number.");
            SpongeCommon.logger().warn("Expected: " + id + ". Got: " + mcId);
            SpongeCommon.logger().warn("Automatically cancelling map creation");
            mapIdTrackerBridge.bridge$setHighestMapId(id - 1);
            return Optional.empty();
        }
        defaultWorld.func_217399_a(mapData);
        ((SpongeMapStorage)Sponge.server().mapStorage()).addMapInfo(mapInfo);
        return Optional.of(mapInfo);
    }

    public static enum CollisionType {
        MOVE,
        FALL,
        STEP_ON,
        INSIDE;

    }
}

