/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.MerchantContainer;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.util.text.ITextComponent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ChangeEntityEquipmentEvent;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.EnchantItemEvent;
import org.spongepowered.api.event.item.inventory.TransferInventoryEvent;
import org.spongepowered.api.event.item.inventory.UpdateAnvilEvent;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.inventory.AnvilCost;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.item.inventory.type.ViewableInventory;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.bridge.world.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.inventory.UpdateAnvilEventCost;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.enchantment.SpongeRandomEnchantmentListBuilder;
import org.spongepowered.common.item.util.ItemStackUtil;

public class InventoryEventFactory {
    public static boolean callPlayerChangeInventoryPickupPreEvent(PlayerEntity player, ItemEntity itemToPickup) {
        net.minecraft.item.ItemStack stack = itemToPickup.func_92059_d();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
        ChangeInventoryEvent.Pickup.Pre event = SpongeEventFactory.createChangeInventoryEventPickupPre(PhaseTracker.getCauseStackManager().currentCause(), Optional.empty(), Collections.singletonList(snapshot), (Inventory)player.field_71071_by, (Item)itemToPickup, snapshot);
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            return false;
        }
        if (event.custom().isPresent()) {
            List<ItemStackSnapshot> list = event.custom().get();
            if (list.isEmpty()) {
                itemToPickup.func_92059_d().func_190920_e(0);
                return false;
            }
            PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
            TransactionalCaptureSupplier transactor = context.getTransactor();
            try (EffectTransactor ignored = transactor.logPlayerInventoryChangeWithEffect(player, PlayerInventoryTransaction.EventCreator.PICKUP);){
                for (ItemStackSnapshot item : list) {
                    ItemStack itemStack = item.createStack();
                    player.field_71071_by.func_70441_a(ItemStackUtil.toNative(itemStack));
                    if (itemStack.isEmpty()) continue;
                    ignored.parent.markCancelled();
                    boolean bl = false;
                    return bl;
                }
            }
            if (!TrackingUtil.processBlockCaptures(context)) {
                return false;
            }
            itemToPickup.func_92059_d().func_190920_e(0);
        }
        return true;
    }

    public static net.minecraft.item.ItemStack callInventoryPickupEvent(IInventory inventory, ItemEntity item, net.minecraft.item.ItemStack stack) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(inventory);
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            ChangeInventoryEvent.Pickup.Pre event = SpongeEventFactory.createChangeInventoryEventPickupPre(frame.currentCause(), Optional.empty(), Collections.singletonList(snapshot), (Inventory)inventory, (Item)item, snapshot);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                net.minecraft.item.ItemStack itemStack = stack;
                return itemStack;
            }
            int size = inventory.func_70302_i_();
            net.minecraft.item.ItemStack[] prevInventory = new net.minecraft.item.ItemStack[size];
            for (int i = 0; i < size; ++i) {
                prevInventory[i] = inventory.func_70301_a(i);
            }
            if (event.custom().isPresent()) {
                net.minecraft.item.ItemStack itemStack;
                if (event.custom().get().isEmpty()) {
                    net.minecraft.item.ItemStack i = net.minecraft.item.ItemStack.field_190927_a;
                    return i;
                }
                boolean fullTransfer = true;
                for (ItemStackSnapshot snap : event.custom().get()) {
                    net.minecraft.item.ItemStack stackToAdd = ItemStackUtil.fromSnapshotToNative(snap);
                    net.minecraft.item.ItemStack remaining = HopperTileEntity.func_174918_a(null, (IInventory)inventory, (net.minecraft.item.ItemStack)stackToAdd, null);
                    if (remaining.func_190926_b()) continue;
                    fullTransfer = false;
                    break;
                }
                if (!fullTransfer) {
                    for (int i = 0; i < prevInventory.length; ++i) {
                        inventory.func_70299_a(i, prevInventory[i]);
                    }
                    net.minecraft.item.ItemStack itemStack2 = stack;
                    return itemStack2;
                }
                if (InventoryEventFactory.callInventoryPickupEvent(inventory, prevInventory)) {
                    itemStack = net.minecraft.item.ItemStack.field_190927_a;
                    return itemStack;
                }
                itemStack = stack;
                return itemStack;
            }
            net.minecraft.item.ItemStack remainder = HopperTileEntity.func_174918_a(null, (IInventory)inventory, (net.minecraft.item.ItemStack)stack, null);
            if (InventoryEventFactory.callInventoryPickupEvent(inventory, prevInventory)) {
                net.minecraft.item.ItemStack itemStack = remainder;
                return itemStack;
            }
            net.minecraft.item.ItemStack itemStack = stack;
            return itemStack;
        }
    }

    private static boolean callInventoryPickupEvent(IInventory inventory, net.minecraft.item.ItemStack[] prevInventory) {
        Inventory spongeInventory = InventoryUtil.toInventory(inventory, null);
        List<SlotTransaction> trans = InventoryEventFactory.generateTransactions(spongeInventory, inventory, prevInventory);
        if (trans.isEmpty()) {
            return true;
        }
        ChangeInventoryEvent.Pickup event = SpongeEventFactory.createChangeInventoryEventPickup(PhaseTracker.getCauseStackManager().currentCause(), spongeInventory, trans);
        SpongeCommon.post(event);
        PacketPhaseUtil.handleSlotRestore(null, null, event.transactions(), event.isCancelled());
        return !event.isCancelled();
    }

    private static List<SlotTransaction> generateTransactions(@Nullable Inventory inv, IInventory inventory, net.minecraft.item.ItemStack[] previous) {
        if (inv == null) {
            return Collections.emptyList();
        }
        ArrayList<SlotTransaction> trans = new ArrayList<SlotTransaction>();
        List<Slot> slots = inv.slots();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            net.minecraft.item.ItemStack prevStack;
            Slot slot = slots.get(i);
            net.minecraft.item.ItemStack newStack = inventory.func_70301_a(i);
            if (net.minecraft.item.ItemStack.func_77989_b((net.minecraft.item.ItemStack)newStack, (net.minecraft.item.ItemStack)(prevStack = previous[i]))) continue;
            trans.add(new SlotTransaction(slot, ItemStackUtil.snapshotOf(prevStack), ItemStackUtil.snapshotOf(newStack)));
        }
        return trans;
    }

    public static boolean callInteractContainerOpenEvent(ServerPlayerEntity player) {
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.empty(), newCursor);
        InteractContainerEvent.Open event = SpongeEventFactory.createInteractContainerEventOpen(PhaseTracker.getCauseStackManager().currentCause(), (Container)player.field_71070_bA, cursorTransaction);
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            player.func_71053_j();
            return false;
        }
        PacketPhaseUtil.handleCursorRestore((PlayerEntity)player, event.cursorTransaction());
        return true;
    }

    public static @Nullable net.minecraft.inventory.container.Container displayContainer(ServerPlayerEntity player, Inventory inventory, Component displayName) {
        net.minecraft.inventory.container.Container container;
        net.minecraft.inventory.container.Container previousContainer = player.field_71070_bA;
        Optional<ViewableInventory> viewable = inventory.asViewable();
        if (viewable.isPresent()) {
            if (viewable.get() instanceof INamedContainerProvider) {
                INamedContainerProvider namedContainerProvider = (INamedContainerProvider)viewable.get();
                if (displayName != null) {
                    namedContainerProvider = new SimpleNamedContainerProvider((IContainerProvider)namedContainerProvider, SpongeAdventure.asVanilla(displayName));
                }
                player.func_213829_a(namedContainerProvider);
            } else if (viewable.get() instanceof CarriedInventory) {
                Optional carrier = ((CarriedInventory)((Object)viewable.get())).carrier();
                if (carrier.get() instanceof AbstractHorseEntity) {
                    player.func_184826_a((AbstractHorseEntity)carrier.get(), (IInventory)viewable.get());
                }
            } else if (viewable.get() instanceof IMerchant) {
                OptionalInt containerId;
                IMerchant merchant = (IMerchant)viewable.get();
                ITextComponent display = null;
                int level = 0;
                if (merchant instanceof VillagerEntity) {
                    display = ((VillagerEntity)merchant).func_145748_c_();
                    level = ((VillagerEntity)merchant).func_213700_eh().func_221132_c();
                } else if (merchant instanceof WanderingTraderEntity) {
                    display = ((WanderingTraderEntity)merchant).func_145748_c_();
                    level = 1;
                }
                if (displayName != null) {
                    display = SpongeAdventure.asVanilla(displayName);
                }
                if ((containerId = player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInv, p) -> new MerchantContainer(id, playerInv, merchant), display))).isPresent() && !merchant.func_213706_dY().isEmpty()) {
                    player.func_213818_a(containerId.getAsInt(), merchant.func_213706_dY(), level, merchant.func_213708_dV(), merchant.func_213705_dZ(), merchant.func_223340_ej());
                }
            }
        }
        if (previousContainer == (container = player.field_71070_bA)) {
            return null;
        }
        if (!InventoryEventFactory.callInteractContainerOpenEvent(player)) {
            return null;
        }
        if (container instanceof ContainerBridge) {
            ((ContainerBridge)container).bridge$setCanInteractWith(p -> !p.field_70128_L);
        }
        return container;
    }

    public static TransferInventoryEvent.Pre callTransferPre(Inventory source, Inventory destination) {
        PhaseTracker.getCauseStackManager().pushCause(source);
        TransferInventoryEvent.Pre event = SpongeEventFactory.createTransferInventoryEventPre(PhaseTracker.getCauseStackManager().currentCause(), source, destination);
        SpongeCommon.post(event);
        PhaseTracker.getCauseStackManager().popCause();
        return event;
    }

    public static void callTransferPost(@Nullable TrackedInventoryBridge captureSource, @Nullable Inventory source, @Nullable Inventory destination, net.minecraft.item.ItemStack sourceStack, SlotTransaction sourceSlotTransaction) {
        if (captureSource == null || source == null || destination == null || sourceSlotTransaction == null) {
            return;
        }
        PhaseTracker.getCauseStackManager().pushCause(source);
        List<SlotTransaction> slotTransactions = captureSource.bridge$getCapturedSlotTransactions();
        sourceStack = sourceStack.func_77946_l();
        sourceStack.func_190920_e(1);
        ItemStackSnapshot transferredStack = ItemStackUtil.snapshotOf(sourceStack);
        Slot sourceSlot = sourceSlotTransaction.slot();
        Slot targetSlot = null;
        for (SlotTransaction transaction : slotTransactions) {
            if (transaction == sourceSlotTransaction) continue;
            targetSlot = transaction.slot();
            break;
        }
        TransferInventoryEvent.Post event = SpongeEventFactory.createTransferInventoryEventPost(PhaseTracker.getCauseStackManager().currentCause(), source, sourceSlot, destination, targetSlot, transferredStack);
        SpongeCommon.post(event);
        slotTransactions.clear();
        PhaseTracker.getCauseStackManager().popCause();
    }

    public static SlotTransaction captureTransaction(@Nullable TrackedInventoryBridge captureIn, @Nullable Inventory inv, int index, net.minecraft.item.ItemStack originalStack) {
        if (captureIn == null || inv == null) {
            return null;
        }
        Optional<Slot> slot = inv.slot(index);
        if (slot.isPresent()) {
            SlotTransaction trans = new SlotTransaction(slot.get(), ItemStackUtil.snapshotOf(originalStack), ItemStackUtil.snapshotOf(slot.get().peek()));
            captureIn.bridge$getCapturedSlotTransactions().add(trans);
            return trans;
        }
        SpongeCommon.logger().warn("Unable to capture transaction from " + inv.getClass() + " at index " + index);
        return null;
    }

    public static net.minecraft.item.ItemStack captureTransaction(@Nullable TrackedInventoryBridge captureIn, @Nullable Inventory inv, int index, Supplier<net.minecraft.item.ItemStack> transaction) {
        if (captureIn == null || inv == null) {
            return transaction.get();
        }
        Optional<Slot> slot = inv.slot(index);
        if (!slot.isPresent()) {
            SpongeCommon.logger().warn("Unable to capture transaction from " + inv.getClass() + " at index " + index);
            return transaction.get();
        }
        ItemStackSnapshot original = ItemStackUtil.snapshotOf(slot.get().peek());
        net.minecraft.item.ItemStack remaining = transaction.get();
        if (remaining.func_190926_b()) {
            ItemStackSnapshot replacement = ItemStackUtil.snapshotOf(slot.get().peek());
            captureIn.bridge$getCapturedSlotTransactions().add(new SlotTransaction(slot.get(), original, replacement));
        }
        return remaining;
    }

    public static UpdateAnvilEvent callUpdateAnvilEvent(RepairContainer anvil, net.minecraft.item.ItemStack slot1, net.minecraft.item.ItemStack slot2, net.minecraft.item.ItemStack result, String name, int levelCost, int materialCost) {
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.empty(), ItemStackUtil.snapshotOf(result));
        UpdateAnvilEventCost costs = new UpdateAnvilEventCost(levelCost, materialCost);
        UpdateAnvilEvent event = SpongeEventFactory.createUpdateAnvilEvent(PhaseTracker.getCauseStackManager().currentCause(), new Transaction<AnvilCost>(costs, costs), (Inventory)anvil, name, ItemStackUtil.snapshotOf(slot1), transaction, ItemStackUtil.snapshotOf(slot2));
        SpongeCommon.post(event);
        return event;
    }

    public static ChangeEntityEquipmentEvent callChangeEntityEquipmentEvent(LivingEntity entity, ItemStackSnapshot before, ItemStackSnapshot after, Slot slot) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(before, after);
            ChangeEntityEquipmentEvent event = after.isEmpty() ? SpongeEventFactory.createChangeEntityEquipmentEventBreak(frame.currentCause(), (Entity)entity, slot, transaction) : SpongeEventFactory.createChangeEntityEquipmentEvent(frame.currentCause(), (Entity)entity, slot, transaction);
            SpongeCommon.post(event);
            ChangeEntityEquipmentEvent changeEntityEquipmentEvent = event;
            return changeEntityEquipmentEvent;
        }
    }

    public static int callEnchantEventLevelRequirement(EnchantmentContainer container, int seed, int option, int power, net.minecraft.item.ItemStack itemStack, int levelRequirement) {
        Container enchantContainer = ContainerUtil.fromNative((net.minecraft.inventory.container.Container)container);
        PlayerEntity viewer = (PlayerEntity)enchantContainer.viewer();
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(viewer.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(cursor, cursor);
        EnchantItemEvent.CalculateLevelRequirement event = SpongeEventFactory.createEnchantItemEventCalculateLevelRequirement(PhaseTracker.getCauseStackManager().currentCause(), levelRequirement, levelRequirement, enchantContainer, cursorTrans, ItemStackUtil.snapshotOf(itemStack), option, power, seed);
        SpongeCommon.post(event);
        return event.levelRequirement();
    }

    public static List<EnchantmentData> callEnchantEventEnchantmentList(EnchantmentContainer container, int seed, net.minecraft.item.ItemStack itemStack, int option, int level, List<EnchantmentData> list) {
        List<Enchantment> enchList = Collections.unmodifiableList(SpongeRandomEnchantmentListBuilder.fromNative(list));
        Container enchantContainer = ContainerUtil.fromNative((net.minecraft.inventory.container.Container)container);
        PlayerEntity viewer = (PlayerEntity)enchantContainer.viewer();
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(viewer.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(cursor, cursor);
        EnchantItemEvent.CalculateEnchantment event = SpongeEventFactory.createEnchantItemEventCalculateEnchantment(PhaseTracker.getCauseStackManager().currentCause(), enchList, enchList, enchantContainer, cursorTrans, ItemStackUtil.snapshotOf(itemStack), level, option, seed);
        SpongeCommon.post(event);
        if (event.enchantments() != event.originalEnchantments()) {
            return SpongeRandomEnchantmentListBuilder.toNative(event.enchantments());
        }
        return list;
    }

    public static EnchantItemEvent.Post callEnchantEventEnchantPost(PlayerEntity playerIn, EnchantmentContainer container, SlotTransaction enchantedItem, SlotTransaction lapisItem, int option, int seed) {
        Container enchantContainer = ContainerUtil.fromNative((net.minecraft.inventory.container.Container)container);
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(playerIn.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(cursor, cursor);
        ArrayList<SlotTransaction> slotTrans = new ArrayList<SlotTransaction>();
        slotTrans.add(lapisItem);
        slotTrans.add(enchantedItem);
        EnchantItemEvent.Post event = SpongeEventFactory.createEnchantItemEventPost(PhaseTracker.getCauseStackManager().currentCause(), enchantContainer, cursorTrans, enchantedItem.slot(), Optional.empty(), slotTrans, option, seed);
        SpongeCommon.post(event);
        PacketPhaseUtil.handleSlotRestore(playerIn, (net.minecraft.inventory.container.Container)container, event.transactions(), event.isCancelled());
        PacketPhaseUtil.handleCursorRestore(playerIn, event.cursorTransaction());
        return event;
    }
}

